/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractDiscreteDistribution;
import cern.jet.random.engine.RandomEngine;

public class PoissonSlow
extends AbstractDiscreteDistribution {
    protected double mean;
    protected double cached_sq;
    protected double cached_alxm;
    protected double cached_g;
    protected static final double MEAN_MAX = 2.147483647E9;
    protected static final double SWITCH_MEAN = 12.0;
    protected static final double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    protected static PoissonSlow shared = new PoissonSlow(0.0, PoissonSlow.makeDefaultGenerator());

    public PoissonSlow(double mean, RandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setMean(mean);
    }

    public static double logGamma(double xx) {
        double x = xx - 1.0;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.000000000190015;
        double[] coeff = cof;
        for (int j = 0; j <= 5; ++j) {
            ser += coeff[j] / (x += 1.0);
        }
        return -tmp + Math.log(2.5066282746310007 * ser);
    }

    public int nextInt() {
        return this.nextInt(this.mean);
    }

    private int nextInt(double theMean) {
        double xm = theMean;
        double g = this.cached_g;
        if (xm == -1.0) {
            return 0;
        }
        if (xm < 12.0) {
            int poisson = -1;
            double product = 1.0;
            do {
                ++poisson;
            } while ((product *= this.randomGenerator.raw()) >= g);
            return poisson;
        }
        if (xm < 2.147483647E9) {
            double em;
            double sq = this.cached_sq;
            double alxm = this.cached_alxm;
            RandomEngine rand = this.randomGenerator;
            while (true) {
                double y;
                if ((em = sq * (y = Math.tan(Math.PI * rand.raw())) + xm) < 0.0) {
                    continue;
                }
                em = (int)em;
                double t = 0.9 * (1.0 + y * y) * Math.exp(em * alxm - PoissonSlow.logGamma(em + 1.0) - g);
                if (!(rand.raw() > t)) break;
            }
            return (int)em;
        }
        return (int)xm;
    }

    protected int nextIntSlow() {
        double bound = Math.exp(-this.mean);
        int count = 0;
        double product = 1.0;
        while (product >= bound && product > 0.0) {
            product *= this.randomGenerator.raw();
            ++count;
        }
        if (product <= 0.0 && bound > 0.0) {
            return (int)Math.round(this.mean);
        }
        return count - 1;
    }

    public void setMean(double mean) {
        if (mean != this.mean) {
            this.mean = mean;
            if (mean == -1.0) {
                return;
            }
            if (mean < 12.0) {
                this.cached_g = Math.exp(-mean);
            } else {
                this.cached_sq = Math.sqrt(2.0 * mean);
                this.cached_alxm = Math.log(mean);
                this.cached_g = mean * this.cached_alxm - PoissonSlow.logGamma(mean + 1.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int staticNextInt(double mean) {
        PoissonSlow poissonSlow = shared;
        synchronized (poissonSlow) {
            shared.setMean(mean);
            return shared.nextInt();
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.mean + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomGenerator) {
        PoissonSlow poissonSlow = shared;
        synchronized (poissonSlow) {
            shared.setRandomGenerator(randomGenerator);
        }
    }
}

