/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.objectalgo;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.ObjectMatrix3D;
import cern.colt.matrix.objectalgo.Formatter;
import cern.colt.matrix.objectalgo.ObjectMatrix1DComparator;
import cern.colt.matrix.objectalgo.ObjectMatrix2DComparator;
import java.util.Comparator;

public class Sorting
extends PersistentObject {
    public static final Sorting quickSort = new Sorting();
    public static final Sorting mergeSort = new Sorting(){

        protected void runSort(int[] a, int fromIndex, int toIndex, IntComparator c) {
            cern.colt.Sorting.mergeSort(a, fromIndex, toIndex, c);
        }

        protected void runSort(int fromIndex, int toIndex, IntComparator c, Swapper swapper) {
            GenericSorting.mergeSort(fromIndex, toIndex, c, swapper);
        }
    };

    protected Sorting() {
    }

    protected void runSort(int[] a, int fromIndex, int toIndex, IntComparator c) {
        cern.colt.Sorting.quickSort(a, fromIndex, toIndex, c);
    }

    protected void runSort(int fromIndex, int toIndex, IntComparator c, Swapper swapper) {
        GenericSorting.quickSort(fromIndex, toIndex, c, swapper);
    }

    public ObjectMatrix1D sort(final ObjectMatrix1D vector) {
        int[] indexes = new int[vector.size()];
        int i = indexes.length;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                Comparable bv;
                Comparable av = (Comparable)vector.getQuick(a);
                int r = av.compareTo(bv = (Comparable)vector.getQuick(b));
                return r < 0 ? -1 : (r > 0 ? 1 : 0);
            }
        };
        this.runSort(indexes, 0, indexes.length, comp);
        return vector.viewSelection(indexes);
    }

    public ObjectMatrix1D sort(final ObjectMatrix1D vector, final Comparator c) {
        int[] indexes = new int[vector.size()];
        int i = indexes.length;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return c.compare(vector.getQuick(a), vector.getQuick(b));
            }
        };
        this.runSort(indexes, 0, indexes.length, comp);
        return vector.viewSelection(indexes);
    }

    public ObjectMatrix2D sort(ObjectMatrix2D matrix, int column) {
        if (column < 0 || column >= matrix.columns()) {
            throw new IndexOutOfBoundsException("column=" + column + ", matrix=" + Formatter.shape(matrix));
        }
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        final ObjectMatrix1D col = matrix.viewColumn(column);
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                Comparable bv;
                Comparable av = (Comparable)col.getQuick(a);
                int r = av.compareTo(bv = (Comparable)col.getQuick(b));
                return r < 0 ? -1 : (r > 0 ? 1 : 0);
            }
        };
        this.runSort(rowIndexes, 0, rowIndexes.length, comp);
        return matrix.viewSelection(rowIndexes, null);
    }

    public ObjectMatrix2D sort(ObjectMatrix2D matrix, final ObjectMatrix1DComparator c) {
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        final ObjectMatrix1D[] views = new ObjectMatrix1D[matrix.rows()];
        int i2 = views.length;
        while (--i2 >= 0) {
            views[i2] = matrix.viewRow(i2);
        }
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return c.compare(views[a], views[b]);
            }
        };
        this.runSort(rowIndexes, 0, rowIndexes.length, comp);
        return matrix.viewSelection(rowIndexes, null);
    }

    public ObjectMatrix3D sort(ObjectMatrix3D matrix, int row, int column) {
        if (row < 0 || row >= matrix.rows()) {
            throw new IndexOutOfBoundsException("row=" + row + ", matrix=" + Formatter.shape(matrix));
        }
        if (column < 0 || column >= matrix.columns()) {
            throw new IndexOutOfBoundsException("column=" + column + ", matrix=" + Formatter.shape(matrix));
        }
        int[] sliceIndexes = new int[matrix.slices()];
        int i = sliceIndexes.length;
        while (--i >= 0) {
            sliceIndexes[i] = i;
        }
        final ObjectMatrix1D sliceView = matrix.viewRow(row).viewColumn(column);
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                Comparable bv;
                Comparable av = (Comparable)sliceView.getQuick(a);
                int r = av.compareTo(bv = (Comparable)sliceView.getQuick(b));
                return r < 0 ? -1 : (r > 0 ? 1 : 0);
            }
        };
        this.runSort(sliceIndexes, 0, sliceIndexes.length, comp);
        return matrix.viewSelection(sliceIndexes, null, null);
    }

    public ObjectMatrix3D sort(ObjectMatrix3D matrix, final ObjectMatrix2DComparator c) {
        int[] sliceIndexes = new int[matrix.slices()];
        int i = sliceIndexes.length;
        while (--i >= 0) {
            sliceIndexes[i] = i;
        }
        final ObjectMatrix2D[] views = new ObjectMatrix2D[matrix.slices()];
        int i2 = views.length;
        while (--i2 >= 0) {
            views[i2] = matrix.viewSlice(i2);
        }
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return c.compare(views[a], views[b]);
            }
        };
        this.runSort(sliceIndexes, 0, sliceIndexes.length, comp);
        return matrix.viewSelection(sliceIndexes, null, null);
    }
}

