/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Blas;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Functions;
import cern.jet.math.PlusMult;

public class SeqBlas
implements Blas {
    public static final Blas seqBlas = new SeqBlas();
    private static final Functions F = Functions.functions;

    protected SeqBlas() {
    }

    public void assign(DoubleMatrix2D A, DoubleFunction function) {
        A.assign(function);
    }

    public void assign(DoubleMatrix2D A, DoubleMatrix2D B, DoubleDoubleFunction function) {
        A.assign(B, function);
    }

    public double dasum(DoubleMatrix1D x) {
        return x.aggregate(Functions.plus, Functions.abs);
    }

    public void daxpy(double alpha, DoubleMatrix1D x, DoubleMatrix1D y) {
        y.assign(x, Functions.plusMult(alpha));
    }

    public void daxpy(double alpha, DoubleMatrix2D A, DoubleMatrix2D B) {
        B.assign(A, Functions.plusMult(alpha));
    }

    public void dcopy(DoubleMatrix1D x, DoubleMatrix1D y) {
        y.assign(x);
    }

    public void dcopy(DoubleMatrix2D A, DoubleMatrix2D B) {
        B.assign(A);
    }

    public double ddot(DoubleMatrix1D x, DoubleMatrix1D y) {
        return x.zDotProduct(y);
    }

    public void dgemm(boolean transposeA, boolean transposeB, double alpha, DoubleMatrix2D A, DoubleMatrix2D B, double beta, DoubleMatrix2D C) {
        A.zMult(B, C, alpha, beta, transposeA, transposeB);
    }

    public void dgemv(boolean transposeA, double alpha, DoubleMatrix2D A, DoubleMatrix1D x, double beta, DoubleMatrix1D y) {
        A.zMult(x, y, alpha, beta, transposeA);
    }

    public void dger(double alpha, DoubleMatrix1D x, DoubleMatrix1D y, DoubleMatrix2D A) {
        PlusMult fun = PlusMult.plusMult(0.0);
        int i = A.rows();
        while (--i >= 0) {
            fun.multiplicator = alpha * x.getQuick(i);
            A.viewRow(i).assign(y, fun);
        }
    }

    public double dnrm2(DoubleMatrix1D x) {
        return Math.sqrt(Algebra.DEFAULT.norm2(x));
    }

    public void drot(DoubleMatrix1D x, DoubleMatrix1D y, double c, double s) {
        x.checkSize(y);
        DoubleMatrix1D tmp = x.copy();
        x.assign(Functions.mult(c));
        x.assign(y, Functions.plusMult(s));
        y.assign(Functions.mult(c));
        y.assign(tmp, Functions.minusMult(s));
    }

    public void drotg(double a, double b, double[] rotvec) {
        double z;
        double s;
        double c;
        double r;
        double scale;
        double roe = b;
        if (Math.abs(a) > Math.abs(b)) {
            roe = a;
        }
        if ((scale = Math.abs(a) + Math.abs(b)) != 0.0) {
            double ra = a / scale;
            double rb = b / scale;
            r = scale * Math.sqrt(ra * ra + rb * rb);
            r = this.sign(1.0, roe) * r;
            c = a / r;
            s = b / r;
            z = 1.0;
            if (Math.abs(a) > Math.abs(b)) {
                z = s;
            }
            if (Math.abs(b) >= Math.abs(a) && c != 0.0) {
                z = 1.0 / c;
            }
        } else {
            c = 1.0;
            s = 0.0;
            r = 0.0;
            z = 0.0;
        }
        a = r;
        b = z;
        rotvec[0] = a;
        rotvec[1] = b;
        rotvec[2] = c;
        rotvec[3] = s;
    }

    public void dscal(double alpha, DoubleMatrix1D x) {
        x.assign(Functions.mult(alpha));
    }

    public void dscal(double alpha, DoubleMatrix2D A) {
        A.assign(Functions.mult(alpha));
    }

    public void dswap(DoubleMatrix1D x, DoubleMatrix1D y) {
        y.swap(x);
    }

    public void dswap(DoubleMatrix2D A, DoubleMatrix2D B) {
        A.checkShape(B);
        int i = A.rows();
        while (--i >= 0) {
            A.viewRow(i).swap(B.viewRow(i));
        }
    }

    public void dsymv(boolean isUpperTriangular, double alpha, DoubleMatrix2D A, DoubleMatrix1D x, double beta, DoubleMatrix1D y) {
        if (isUpperTriangular) {
            A = A.viewDice();
        }
        Property.DEFAULT.checkSquare(A);
        int size = A.rows();
        if (size != x.size() || size != y.size()) {
            throw new IllegalArgumentException(A.toStringShort() + ", " + x.toStringShort() + ", " + y.toStringShort());
        }
        DoubleMatrix1D tmp = x.like();
        for (int i = 0; i < size; ++i) {
            int j;
            double sum = 0.0;
            for (j = 0; j <= i; ++j) {
                sum += A.getQuick(i, j) * x.getQuick(j);
            }
            for (j = i + 1; j < size; ++j) {
                sum += A.getQuick(j, i) * x.getQuick(j);
            }
            tmp.setQuick(i, alpha * sum + beta * y.getQuick(i));
        }
        y.assign(tmp);
    }

    public void dtrmv(boolean isUpperTriangular, boolean transposeA, boolean isUnitTriangular, DoubleMatrix2D A, DoubleMatrix1D x) {
        int i;
        if (transposeA) {
            A = A.viewDice();
            isUpperTriangular = !isUpperTriangular;
        }
        Property.DEFAULT.checkSquare(A);
        int size = A.rows();
        if (size != x.size()) {
            throw new IllegalArgumentException(A.toStringShort() + ", " + x.toStringShort());
        }
        DoubleMatrix1D b = x.like();
        DoubleMatrix1D y = x.like();
        if (isUnitTriangular) {
            y.assign(1.0);
        } else {
            for (i = 0; i < size; ++i) {
                y.setQuick(i, A.getQuick(i, i));
            }
        }
        for (i = 0; i < size; ++i) {
            int j;
            double sum = 0.0;
            if (!isUpperTriangular) {
                for (j = 0; j < i; ++j) {
                    sum += A.getQuick(i, j) * x.getQuick(j);
                }
                sum += y.getQuick(i) * x.getQuick(i);
            } else {
                sum += y.getQuick(i) * x.getQuick(i);
                for (j = i + 1; j < size; ++j) {
                    sum += A.getQuick(i, j) * x.getQuick(j);
                }
            }
            b.setQuick(i, sum);
        }
        x.assign(b);
    }

    public int idamax(DoubleMatrix1D x) {
        int maxIndex = -1;
        double maxValue = Double.MIN_VALUE;
        int i = x.size();
        while (--i >= 0) {
            double v = Math.abs(x.getQuick(i));
            if (!(v > maxValue)) continue;
            maxValue = v;
            maxIndex = i;
        }
        return maxIndex;
    }

    private double sign(double a, double b) {
        if (b < 0.0) {
            return -Math.abs(a);
        }
        return Math.abs(a);
    }
}

