/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.map.AbstractIntObjectMap;
import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.ObjectMatrix3D;
import cern.colt.matrix.impl.SelectedSparseObjectMatrix3D;
import cern.colt.matrix.impl.SparseObjectMatrix2D;

public class SparseObjectMatrix3D
extends ObjectMatrix3D {
    protected AbstractIntObjectMap elements;

    public SparseObjectMatrix3D(Object[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length));
        this.assign(values);
    }

    public SparseObjectMatrix3D(int slices, int rows, int columns) {
        this(slices, rows, columns, slices * rows * (columns / 1000), 0.2, 0.5);
    }

    public SparseObjectMatrix3D(int slices, int rows, int columns, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(slices, rows, columns);
        this.elements = new OpenIntObjectHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    protected SparseObjectMatrix3D(int slices, int rows, int columns, AbstractIntObjectMap elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride) {
        this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = false;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    public Object getQuick(int slice, int row, int column) {
        return this.elements.get(this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride);
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix3D other) {
        if (other instanceof SelectedSparseObjectMatrix3D) {
            SelectedSparseObjectMatrix3D otherMatrix = (SelectedSparseObjectMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseObjectMatrix3D) {
            SparseObjectMatrix3D otherMatrix = (SparseObjectMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    protected int index(int slice, int row, int column) {
        return this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    public ObjectMatrix3D like(int slices, int rows, int columns) {
        return new SparseObjectMatrix3D(slices, rows, columns);
    }

    protected ObjectMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new SparseObjectMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride);
    }

    public void setQuick(int slice, int row, int column, Object value) {
        int index = this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        if (value == null) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    protected ObjectMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseObjectMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }
}

