/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.ObjectMatrix3D;
import cern.colt.matrix.impl.DenseObjectMatrix2D;
import cern.colt.matrix.impl.SelectedDenseObjectMatrix3D;

public class DenseObjectMatrix3D
extends ObjectMatrix3D {
    protected Object[] elements;

    public DenseObjectMatrix3D(Object[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length));
        this.assign(values);
    }

    public DenseObjectMatrix3D(int slices, int rows, int columns) {
        this.setUp(slices, rows, columns);
        this.elements = new Object[slices * rows * columns];
    }

    protected DenseObjectMatrix3D(int slices, int rows, int columns, Object[] elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride) {
        this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = false;
    }

    public ObjectMatrix3D assign(Object[][][] values) {
        if (this.isNoView) {
            if (values.length != this.slices) {
                throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
            }
            int i = this.slices * this.rows * this.columns - this.columns;
            int slice = this.slices;
            while (--slice >= 0) {
                Object[][] currentSlice = values[slice];
                if (currentSlice.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                }
                int row = this.rows;
                while (--row >= 0) {
                    Object[] currentRow = currentSlice[row];
                    if (currentRow.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                    }
                    System.arraycopy(currentRow, 0, this.elements, i, this.columns);
                    i -= this.columns;
                }
            }
        } else {
            super.assign(values);
        }
        return this;
    }

    public ObjectMatrix3D assign(ObjectMatrix3D source) {
        if (!(source instanceof DenseObjectMatrix3D)) {
            return super.assign(source);
        }
        DenseObjectMatrix3D other = (DenseObjectMatrix3D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.haveSharedCells(other)) {
            ObjectMatrix3D c = other.copy();
            if (!(c instanceof DenseObjectMatrix3D)) {
                return super.assign(source);
            }
            other = (DenseObjectMatrix3D)c;
        }
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(other);
    }

    public Object getQuick(int slice, int row, int column) {
        return this.elements[this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix3D other) {
        if (other instanceof SelectedDenseObjectMatrix3D) {
            SelectedDenseObjectMatrix3D otherMatrix = (SelectedDenseObjectMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseObjectMatrix3D) {
            DenseObjectMatrix3D otherMatrix = (DenseObjectMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    protected int index(int slice, int row, int column) {
        return this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    public ObjectMatrix3D like(int slices, int rows, int columns) {
        return new DenseObjectMatrix3D(slices, rows, columns);
    }

    protected ObjectMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new DenseObjectMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride);
    }

    public void setQuick(int slice, int row, int column, Object value) {
        this.elements[this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    protected ObjectMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseObjectMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }
}

