/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

import cern.colt.Arrays;
import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.doublealgo.Sorting;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;

class GenericSortingTest {
    protected GenericSortingTest() {
    }

    public static void demo1() {
        final int[] x = new int[]{3, 2, 1};
        final double[] y = new double[]{3.0, 2.0, 1.0};
        final double[] z = new double[]{6.0, 7.0, 8.0};
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                int t1 = x[a];
                x[a] = x[b];
                x[b] = t1;
                double t2 = y[a];
                y[a] = y[b];
                y[b] = t2;
                double t3 = z[a];
                z[a] = z[b];
                z[b] = t3;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return x[a] == x[b] ? 0 : (x[a] < x[b] ? -1 : 1);
            }
        };
        System.out.println("before:");
        System.out.println("X=" + Arrays.toString(x));
        System.out.println("Y=" + Arrays.toString(y));
        System.out.println("Z=" + Arrays.toString(z));
        int from = 0;
        int to = x.length;
        GenericSorting.quickSort(from, to, comp, swapper);
        System.out.println("after:");
        System.out.println("X=" + Arrays.toString(x));
        System.out.println("Y=" + Arrays.toString(y));
        System.out.println("Z=" + Arrays.toString(z));
        System.out.println("\n\n");
    }

    public static void demo2() {
        final int[] x = new int[]{6, 7, 8, 9};
        final double[] y = new double[]{3.0, 2.0, 1.0, 3.0};
        final double[] z = new double[]{5.0, 4.0, 4.0, 1.0};
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                int t1 = x[a];
                x[a] = x[b];
                x[b] = t1;
                double t2 = y[a];
                y[a] = y[b];
                y[b] = t2;
                double t3 = z[a];
                z[a] = z[b];
                z[b] = t3;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                if (y[a] == y[b]) {
                    return z[a] == z[b] ? 0 : (z[a] < z[b] ? -1 : 1);
                }
                return y[a] < y[b] ? -1 : 1;
            }
        };
        System.out.println("before:");
        System.out.println("X=" + Arrays.toString(x));
        System.out.println("Y=" + Arrays.toString(y));
        System.out.println("Z=" + Arrays.toString(z));
        int from = 0;
        int to = x.length;
        GenericSorting.quickSort(from, to, comp, swapper);
        System.out.println("after:");
        System.out.println("X=" + Arrays.toString(x));
        System.out.println("Y=" + Arrays.toString(y));
        System.out.println("Z=" + Arrays.toString(z));
        System.out.println("\n\n");
    }

    public static void testRandomly(int runs) {
        MersenneTwister engine = new MersenneTwister();
        Uniform gen = new Uniform(engine);
        for (int run = 0; run < runs; ++run) {
            int to;
            int from;
            int maxSize = 50;
            int maxSplittersSize = 2 * maxSize;
            int size = gen.nextIntFromTo(1, maxSize);
            if (size == 0) {
                from = 0;
                to = -1;
            } else {
                from = gen.nextIntFromTo(0, size - 1);
                to = gen.nextIntFromTo(Math.min(from, size - 1), size - 1);
            }
            DenseDoubleMatrix2D A1 = new DenseDoubleMatrix2D(size, size);
            DoubleMatrix2D P1 = A1.viewPart(from, from, size - to, size - to);
            int intervalFrom = gen.nextIntFromTo(size / 2, 2 * size);
            int intervalTo = gen.nextIntFromTo(intervalFrom, 2 * size);
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    A1.set(i, j, gen.nextIntFromTo(intervalFrom, intervalTo));
                }
            }
            DoubleMatrix2D A2 = A1.copy();
            DoubleMatrix2D P2 = A2.viewPart(from, from, size - to, size - to);
            int c = 0;
            DoubleMatrix2D S1 = Sorting.quickSort.sort(P1, c);
            DoubleMatrix2D S2 = Sorting.mergeSort.sort(P2, c);
            if (S1.viewColumn(c).equals(S2.viewColumn(c))) continue;
            throw new InternalError();
        }
        System.out.println("All tests passed. No bug detected.");
    }
}

