/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.compression;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.compression.Decoder;
import it.unimi.dsi.compression.PrefixCodec;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import junit.framework.TestCase;

public abstract class CodecTest
extends TestCase {
    protected void checkPrefixCodec(PrefixCodec codec, Random r) throws IOException {
        int i;
        int[] symbol = new int[100];
        BooleanArrayList bits = new BooleanArrayList();
        for (i = 0; i < symbol.length; ++i) {
            symbol[i] = r.nextInt(codec.size());
        }
        for (i = 0; i < symbol.length; ++i) {
            BitVector word = codec.codeWords()[symbol[i]];
            for (int j = 0; j < word.size(); ++j) {
                bits.add((Boolean)word.get(j));
            }
        }
        BooleanIterator booleanIterator = bits.iterator();
        Decoder decoder = codec.decoder();
        for (int i2 = 0; i2 < symbol.length; ++i2) {
            CodecTest.assertEquals((int)decoder.decode(booleanIterator), (int)symbol[i2]);
        }
        FastByteArrayOutputStream fbaos = new FastByteArrayOutputStream();
        OutputBitStream obs = new OutputBitStream((OutputStream)fbaos, 0);
        obs.write(bits.iterator());
        obs.flush();
        InputBitStream ibs = new InputBitStream(fbaos.array);
        for (int i3 = 0; i3 < symbol.length; ++i3) {
            CodecTest.assertEquals((int)decoder.decode(ibs), (int)symbol[i3]);
        }
    }

    protected void checkLengths(int[] frequency, int[] codeLength, BitVector[] codeWord) {
        for (int i = 0; i < frequency.length; ++i) {
            CodecTest.assertEquals((String)Integer.toString(i), (int)codeLength[i], (int)codeWord[i].size());
        }
    }
}

