/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.bits;

import it.unimi.dsi.bits.BooleanListBitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.util.LongBigList;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import test.it.unimi.dsi.bits.BitVectorTestCase;

public class LongArrayBitVectorTest
extends TestCase {
    public void testSetClearFlip() {
        LongArrayBitVector v = LongArrayBitVector.getInstance();
        v.size(1);
        BitVectorTestCase.testSetClearFlip(v);
        v.size(64);
        BitVectorTestCase.testSetClearFlip(v);
        v.size(80);
        BitVectorTestCase.testSetClearFlip(v);
        v.size(150);
        BitVectorTestCase.testSetClearFlip(v);
        BitVectorTestCase.testSetClearFlip(v.subVector(0L, 90L));
        BitVectorTestCase.testSetClearFlip(v.subVector(5L, 90L));
    }

    public void testFillFlip() {
        LongArrayBitVector v = LongArrayBitVector.getInstance();
        v.size(100);
        BitVectorTestCase.testFillFlip(v);
        BitVectorTestCase.testFillFlip(v.subVector(0L, 90L));
        BitVectorTestCase.testFillFlip(v.subVector(5L, 90L));
    }

    public void testRemove() {
        BitVectorTestCase.testRemove(LongArrayBitVector.getInstance());
        LongArrayBitVector v = LongArrayBitVector.getInstance();
        v.clear();
        v.size(65);
        v.set(64);
        v.removeBoolean(0);
        LongArrayBitVectorTest.assertEquals((long)0L, (long)v.bits()[1]);
    }

    public void testAdd() {
        BitVectorTestCase.testAdd(LongArrayBitVector.getInstance());
    }

    public void testCopy() {
        BitVectorTestCase.testCopy(LongArrayBitVector.getInstance());
    }

    public void testBits() {
        BitVectorTestCase.testBits(LongArrayBitVector.getInstance());
    }

    public void testLongBigListView() {
        BitVectorTestCase.testLongBigListView(LongArrayBitVector.getInstance());
    }

    public void testLongSetView() {
        BitVectorTestCase.testLongSetView(LongArrayBitVector.getInstance());
    }

    public void testFirstLast() {
        BitVectorTestCase.testFirstLastPrefix(LongArrayBitVector.getInstance());
    }

    public void testLogicOperators() {
        BitVectorTestCase.testLogicOperators(LongArrayBitVector.getInstance());
    }

    public void testCount() {
        BitVectorTestCase.testCount(LongArrayBitVector.getInstance());
    }

    public void testSerialisation() throws IOException, ClassNotFoundException {
        BitVectorTestCase.testSerialisation(LongArrayBitVector.getInstance());
    }

    public void testReplace() {
        BitVectorTestCase.testReplace(LongArrayBitVector.getInstance());
    }

    public void testTrim() {
        LongArrayBitVectorTest.assertTrue((boolean)LongArrayBitVector.getInstance(100L).trim());
        LongArrayBitVectorTest.assertFalse((boolean)LongArrayBitVector.getInstance(100L).length(65L).trim());
        LongArrayBitVectorTest.assertFalse((boolean)LongArrayBitVector.getInstance(0L).trim());
    }

    public void testClone() throws CloneNotSupportedException {
        LongArrayBitVector v = LongArrayBitVector.getInstance().length(100L);
        for (int i = 0; i < 50; ++i) {
            v.set(i * 2);
        }
        LongArrayBitVectorTest.assertEquals((Object)v, (Object)v.clone());
    }

    public void testEquals() {
        LongArrayBitVector v = LongArrayBitVector.getInstance().length(100L);
        for (int i = 0; i < 50; ++i) {
            v.set(i * 2);
        }
        LongArrayBitVector w = v.copy();
        LongArrayBitVectorTest.assertEquals((Object)v, (Object)w);
        w.length(101L);
        LongArrayBitVectorTest.assertFalse((boolean)v.equals(w));
        w.length(100L);
        w.set(3);
        LongArrayBitVectorTest.assertFalse((boolean)v.equals(w));
    }

    public void testConstructor() {
        long[] bits = new long[]{0L, 1L, 0L};
        boolean ok = false;
        try {
            LongArrayBitVector.wrap(bits, 64L);
        }
        catch (IllegalArgumentException e) {
            ok = true;
        }
        LongArrayBitVectorTest.assertTrue((boolean)ok);
        LongArrayBitVector.wrap(bits, 65L);
        LongArrayBitVector.wrap(bits, 128L);
        ok = false;
        try {
            LongArrayBitVector.wrap(bits, 193L);
        }
        catch (IllegalArgumentException e) {
            ok = true;
        }
        LongArrayBitVectorTest.assertTrue((boolean)ok);
        bits[0] = 10L;
        bits[1] = 0L;
        ok = false;
        try {
            LongArrayBitVector.wrap(bits, 3L);
        }
        catch (IllegalArgumentException e) {
            ok = true;
        }
        LongArrayBitVectorTest.assertTrue((boolean)ok);
        LongArrayBitVector.wrap(bits, 4L);
        bits[2] = 1L;
        ok = false;
        try {
            LongArrayBitVector.wrap(bits, 4L);
        }
        catch (IllegalArgumentException e) {
            ok = true;
        }
        LongArrayBitVectorTest.assertTrue((boolean)ok);
    }

    public void testLongBig() {
        LongArrayBitVector v = LongArrayBitVector.getInstance(16384L);
        LongBigList l = v.asLongBigList(16);
        l.set(0, 511L);
        LongArrayBitVectorTest.assertEquals((long)511L, (long)v.bits()[0]);
        System.err.println(Long.toHexString(v.bits()[0]));
    }

    public void testCopyAnotherVector() {
        int i;
        int i2;
        Random r = new Random(1L);
        LongArrayBitVector bv = LongArrayBitVector.getInstance(200L);
        for (i2 = 0; i2 < 100; ++i2) {
            bv.add(r.nextBoolean());
        }
        LongArrayBitVectorTest.assertEquals((Object)LongArrayBitVector.copy(bv), (Object)bv);
        bv = LongArrayBitVector.getInstance(256L);
        for (i2 = 0; i2 < 256; ++i2) {
            bv.add(r.nextBoolean());
        }
        LongArrayBitVectorTest.assertEquals((Object)LongArrayBitVector.copy(bv), (Object)bv);
        bv = LongArrayBitVector.getInstance(10L);
        for (i2 = 0; i2 < 10; ++i2) {
            bv.add(r.nextBoolean());
        }
        LongArrayBitVectorTest.assertEquals((Object)LongArrayBitVector.copy(bv), (Object)bv);
        BooleanListBitVector bbv = BooleanListBitVector.getInstance(200L);
        for (i = 0; i < 100; ++i) {
            bbv.add(r.nextBoolean());
        }
        LongArrayBitVectorTest.assertEquals((Object)LongArrayBitVector.copy(bbv), (Object)bbv);
        bbv = BooleanListBitVector.getInstance(256L);
        for (i = 0; i < 256; ++i) {
            bbv.add(r.nextBoolean());
        }
        LongArrayBitVectorTest.assertEquals((Object)LongArrayBitVector.copy(bbv), (Object)bbv);
        bbv = BooleanListBitVector.getInstance(10L);
        for (i = 0; i < 10; ++i) {
            bbv.add(r.nextBoolean());
        }
        LongArrayBitVectorTest.assertEquals((Object)LongArrayBitVector.copy(bbv), (Object)bbv);
    }
}

