/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.fastutil.longs.AbstractLongList;
import it.unimi.dsi.fastutil.longs.AbstractLongListIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.util.LongBigList;
import java.io.Serializable;
import java.util.NoSuchElementException;

public abstract class AbstractLongBigList
extends AbstractLongList
implements LongBigList {
    protected void ensureIndex(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.length()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.length()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    public long set(long index, long value) {
        throw new UnsupportedOperationException();
    }

    public void add(long index, long value) {
        throw new UnsupportedOperationException();
    }

    public long removeLong(long index) {
        throw new UnsupportedOperationException();
    }

    public LongBigList length(long newLength) {
        throw new UnsupportedOperationException();
    }

    public long getLong(int index) {
        return this.getLong(index);
    }

    public int size() {
        long length = this.length();
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("The number of elements of this bit list (" + length + ") exceeds Integer.MAX_INT");
        }
        return (int)length;
    }

    public LongBigList subList(long from, long to) {
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new LongSubBigList(this, from, to);
    }

    protected static class LongSubBigList
    extends AbstractLongBigList
    implements Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final LongBigList l;
        protected final long from;
        protected long to;
        private static final boolean ASSERTS = false;

        public LongSubBigList(LongBigList l, long from, long to) {
            this.l = l;
            this.from = from;
            this.to = to;
        }

        private void assertRange() {
        }

        public boolean add(long k) {
            this.l.add(this.to, k);
            ++this.to;
            return true;
        }

        public void add(int index, long k) {
            this.ensureIndex(index);
            this.l.add(this.from + (long)index, k);
            ++this.to;
        }

        public long getLong(long index) {
            this.ensureRestrictedIndex(index);
            return this.l.getLong(this.from + index);
        }

        public long removeLong(long index) {
            this.ensureRestrictedIndex(index);
            --this.to;
            return this.l.removeLong(this.from + index);
        }

        public long set(int index, long k) {
            this.ensureRestrictedIndex(index);
            return this.l.set(this.from + (long)index, k);
        }

        public void clear() {
            this.removeElements(0, this.size());
        }

        public long length() {
            return this.to - this.from;
        }

        public LongListIterator listIterator(final int index) {
            this.ensureIndex(index);
            return new AbstractLongListIterator(){
                long pos;
                long last;
                {
                    this.pos = index;
                    this.last = -1L;
                }

                public boolean hasNext() {
                    return this.pos < (long)LongSubBigList.this.size();
                }

                public boolean hasPrevious() {
                    return this.pos > 0L;
                }

                public long nextLong() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return LongSubBigList.this.l.getLong(LongSubBigList.this.from + this.last);
                }

                public long previousLong() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return LongSubBigList.this.l.getLong(LongSubBigList.this.from + this.pos);
                }

                public int nextIndex() {
                    return (int)this.pos;
                }

                public int previousIndex() {
                    return (int)this.pos - 1;
                }

                public void add(long k) {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    LongSubBigList.this.add(this.pos++, k);
                    this.last = -1L;
                }

                public void set(long k) {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    LongSubBigList.this.set(this.last, k);
                }

                public void remove() {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    LongSubBigList.this.removeLong(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1L;
                }
            };
        }
    }
}

