/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.lang;

import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.lang.MutableString;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectParser
extends StringParser {
    final String[] packages;
    final String[] factoryMethod;
    final Class<?> type;

    public ObjectParser(Class<?> type, String[] packages, String[] factoryMethod) {
        this.type = type;
        this.packages = packages;
        this.factoryMethod = factoryMethod;
    }

    public ObjectParser(Class<?> type, String[] packages) {
        this(type, packages, null);
    }

    public ObjectParser(Class<?> type) {
        this(type, null);
    }

    public ObjectParser() {
        this(Object.class);
    }

    public Object parse(String spec) throws ParseException {
        try {
            return ObjectParser.fromSpec(spec, this.type, this.packages, this.factoryMethod);
        }
        catch (Exception e) {
            throw new ParseException((Throwable)e);
        }
    }

    public static Object fromSpec(String spec) throws IllegalArgumentException, ClassNotFoundException {
        return ObjectParser.fromSpec(spec, Object.class, null, null);
    }

    public static <S> S fromSpec(String spec, Class<S> type) throws IllegalArgumentException, ClassNotFoundException {
        return ObjectParser.fromSpec(spec, type, null, null);
    }

    public static <S> S fromSpec(String spec, Class<S> type, String[] packages) throws IllegalArgumentException, ClassNotFoundException {
        return ObjectParser.fromSpec(spec, type, packages, null);
    }

    public static <S> S fromSpec(String spec, Class<S> type, String[] packages, String[] factoryMethod) throws IllegalArgumentException, ClassNotFoundException {
        Constructor<?> constr;
        String className;
        Class<?> klass;
        int length;
        int endOfName;
        block35: {
            spec = spec.trim();
            endOfName = spec.indexOf(40);
            length = spec.length();
            if (endOfName < 0) {
                endOfName = length;
            }
            klass = null;
            className = spec.substring(0, endOfName).trim();
            try {
                klass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                if (packages == null) break block35;
                for (String p : packages) {
                    try {
                        klass = Class.forName(p + "." + className);
                    }
                    catch (ClassNotFoundException niceTry) {
                        // empty catch block
                    }
                    if (klass != null) break;
                }
            }
        }
        if (klass == null) {
            throw new ClassNotFoundException(className);
        }
        if (!type.isAssignableFrom(klass)) {
            throw new ClassCastException("Class " + klass.getSimpleName() + " is not assignable to " + type);
        }
        ObjectArrayList args = new ObjectArrayList();
        if (endOfName < length) {
            MutableString arg = new MutableString();
            if (spec.charAt(length - 1) != ')') {
                throw new IllegalArgumentException("\")\" missing at the end of argument list");
            }
            int pos = endOfName;
            while (pos < length) {
                ++pos;
                while (pos < length && Character.isWhitespace(spec.charAt(pos))) {
                    ++pos;
                }
                if (pos == length || args.size() == 0 && pos == length - 1 && spec.charAt(pos) == ')') break;
                arg.setLength(0);
                boolean inQuotes = spec.charAt(pos) == '\"';
                if (inQuotes) {
                    ++pos;
                }
                boolean escaped = false;
                while (true) {
                    char c = spec.charAt(pos);
                    if (!inQuotes) {
                        if (c == ',' || pos == length - 1 && c == ')') break;
                        arg.append(c);
                    } else {
                        if (c == '\"' && !escaped) {
                            while (++pos < length && Character.isWhitespace(spec.charAt(pos))) {
                            }
                            if (pos != length && (spec.charAt(pos) == ')' || spec.charAt(pos) == ',')) break;
                            throw new IllegalArgumentException();
                        }
                        if (c == '\\' && !escaped) {
                            escaped = true;
                        } else {
                            arg.append(c);
                            escaped = false;
                        }
                    }
                    ++pos;
                }
                args.add((Object)arg.trim().toString());
            }
        }
        String[] argArray = (String[])args.toArray((Object[])new String[0]);
        Class[] argTypes = new Class[args.size()];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = String.class;
        }
        Method method = null;
        Object instance = null;
        if (factoryMethod != null) {
            for (String f : factoryMethod) {
                try {
                    method = klass.getMethod(f, argTypes);
                    if (Modifier.isStatic(method.getModifiers())) {
                        instance = method.invoke(null, (Object[])argArray);
                    }
                }
                catch (Exception niceTry) {
                    // empty catch block
                }
                if (instance != null) {
                    return (S)instance;
                }
                try {
                    method = klass.getMethod(f, String[].class);
                    if (Modifier.isStatic(method.getModifiers())) {
                        instance = method.invoke(null, new Object[]{argArray});
                    }
                }
                catch (Exception niceTry) {
                    // empty catch block
                }
                if (instance == null) continue;
                return (S)instance;
            }
        }
        try {
            constr = klass.getConstructor(argTypes);
            instance = constr.newInstance(argArray);
        }
        catch (Exception niceTry) {
            // empty catch block
        }
        if (instance != null) {
            return (S)instance;
        }
        try {
            constr = klass.getConstructor(String[].class);
            return (S)constr.newInstance(new Object[]{argArray});
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No constructor with " + argTypes.length + " strings as argument for class " + klass.getName());
        }
    }

    public static String toSpec(Object o) {
        Method toSpec = null;
        try {
            toSpec = o.getClass().getMethod("toSpec", new Class[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (toSpec != null) {
            try {
                return (String)toSpec.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return o.getClass().getName();
    }
}

