/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.io;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.SafelyCloseable;
import it.unimi.dsi.lang.MutableString;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLinesCollection
extends AbstractCollection<MutableString> {
    private final String filename;
    private final String encoding;
    private int size = -1;
    private final boolean zipped;

    public FileLinesCollection(CharSequence filename, String encoding) {
        this(filename, encoding, false);
    }

    public FileLinesCollection(CharSequence filename, String encoding, boolean zipped) {
        this.zipped = zipped;
        this.filename = ((Object)filename).toString();
        this.encoding = encoding;
    }

    public FileLinesIterator iterator() {
        return new FileLinesIterator(this.filename, this.encoding, this.zipped);
    }

    @Override
    public synchronized int size() {
        if (this.size == -1) {
            FileLinesIterator i = this.iterator();
            this.size = 0;
            while (i.hasNext()) {
                ++this.size;
                i.next();
            }
            i.close();
        }
        return this.size;
    }

    public List<MutableString> allLines() {
        ObjectArrayList result = new ObjectArrayList();
        FileLinesIterator i = this.iterator();
        while (i.hasNext()) {
            result.add((Object)((MutableString)i.next()).copy());
        }
        return result;
    }

    @Override
    public String toString() {
        MutableString s = new MutableString();
        FileLinesIterator i = this.iterator();
        while (i.hasNext()) {
            s.append((MutableString)i.next()).append('\n');
        }
        return s.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FileLinesIterator
    implements Iterator<MutableString>,
    SafelyCloseable {
        private FastBufferedReader fbr;
        MutableString s = new MutableString();
        MutableString next;
        boolean toAdvance = true;

        private FileLinesIterator(String filename, String encoding, boolean zipped) {
            try {
                this.fbr = encoding != null ? new FastBufferedReader(new InputStreamReader(zipped ? new GZIPInputStream(new FileInputStream(filename)) : new FileInputStream(filename), encoding)) : new FastBufferedReader(new FileReader(filename));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.toAdvance) {
                try {
                    this.next = this.fbr.readLine(this.s);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.toAdvance = false;
            }
            return this.next != null;
        }

        @Override
        public MutableString next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.s;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void close() {
            if (this.fbr == null) {
                throw new IllegalStateException();
            }
            try {
                this.fbr.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.fbr = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void finalize() throws Throwable {
            try {
                if (this.fbr != null) {
                    this.close();
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

