/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.compression;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.compression.CodeWordCoder;
import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;

public final class Fast64CodeWordCoder
extends CodeWordCoder {
    private static final long serialVersionUID = 1L;
    private final long[] longCodeWord;
    private final int[] length;

    public Fast64CodeWordCoder(BitVector[] codeWord, long[] longCodeWord) {
        super(codeWord);
        this.longCodeWord = longCodeWord;
        this.length = new int[codeWord.length];
        int i = this.length.length;
        while (i-- != 0) {
            this.length[i] = codeWord[i].size();
        }
    }

    public int encode(int symbol, OutputBitStream obs) throws IOException {
        return obs.writeLong(this.longCodeWord[symbol], this.length[symbol]);
    }
}

