/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

import it.unimi.dsi.bits.AbstractBitVector;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.compression.PrefixCoder;
import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixCoderTransformationStrategy
implements TransformationStrategy<CharSequence> {
    private static final long serialVersionUID = 1L;
    protected final BitVector[] codeWord;
    protected final Char2IntOpenHashMap char2symbol;
    protected final boolean prefixFree;

    public PrefixCoderTransformationStrategy(PrefixCoder coder, Char2IntOpenHashMap char2symbol, boolean prefixFree) {
        this(coder.codeWords(), char2symbol, prefixFree);
    }

    protected PrefixCoderTransformationStrategy(PrefixCoderTransformationStrategy transformationStrategy) {
        this(transformationStrategy.codeWord, transformationStrategy.char2symbol, transformationStrategy.prefixFree);
    }

    protected PrefixCoderTransformationStrategy(BitVector[] codeWord, Char2IntOpenHashMap char2symbol, boolean prefixFree) {
        this.codeWord = codeWord;
        this.char2symbol = char2symbol;
        this.prefixFree = prefixFree;
    }

    @Override
    public BitVector toBitVector(CharSequence s) {
        return new CodedCharSequenceBitVector(s, this);
    }

    @Override
    public long numBits() {
        long numBits = 0L;
        int i = this.codeWord.length;
        while (i-- != 0) {
            numBits += (long)this.codeWord[i].size();
        }
        return numBits;
    }

    public PrefixCoderTransformationStrategy copy() {
        return new PrefixCoderTransformationStrategy(this);
    }

    private static final class CodedCharSequenceBitVector
    extends AbstractBitVector {
        private final PrefixCoderTransformationStrategy strategy;
        private final CharSequence s;
        private long length = -1L;

        public CodedCharSequenceBitVector(CharSequence s, PrefixCoderTransformationStrategy strategy) {
            this.s = s;
            this.strategy = strategy;
        }

        public boolean getBoolean(long index) {
            BitVector[] codeWord = this.strategy.codeWord;
            Char2IntOpenHashMap char2symbol = this.strategy.char2symbol;
            int pos = 0;
            int bits = 0;
            int incr = 0;
            int length = this.s.length();
            while (pos < length && (long)(bits + (incr = codeWord[char2symbol.get(this.s.charAt(pos))].size())) <= index) {
                ++pos;
                bits += incr;
            }
            if (pos == length) {
                if (this.strategy.prefixFree && index - (long)bits < (long)codeWord[0].size()) {
                    return codeWord[0].getBoolean(index - (long)bits);
                }
                throw new IllegalArgumentException();
            }
            return codeWord[char2symbol.get(this.s.charAt(pos))].getBoolean(index - (long)bits);
        }

        public long length() {
            if (this.length != -1L) {
                return this.length;
            }
            BitVector[] codeWord = this.strategy.codeWord;
            Char2IntOpenHashMap char2symbol = this.strategy.char2symbol;
            this.length = this.strategy.prefixFree ? (long)codeWord[0].size() : 0L;
            int i = this.s.length();
            while (i-- != 0) {
                int symbol = char2symbol.get(this.s.charAt(i));
                if (symbol == -1) {
                    return -1L;
                }
                this.length += (long)codeWord[symbol].size();
            }
            return this.length;
        }
    }
}

