/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

import it.unimi.dsi.bits.AbstractBitVector;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.util.LongBigList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class LongArrayBitVector
extends AbstractBitVector
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int LOG2_BITS_PER_WORD = 6;
    public static final int BITS_PER_WORD = 64;
    public static final int WORD_MASK = 63;
    public static final int LAST_BIT = 63;
    public static final long ALL_ONES = -1L;
    public static final long LAST_BIT_MASK = Long.MIN_VALUE;
    public static final boolean CHECKS = true;
    private long length;
    private transient long[] bits;

    protected static final int numWords(long size) {
        if (size + 63L >>> 6 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return (int)(size + 63L >>> 6);
    }

    protected static final int word(long index) {
        if (index >>> 6 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return (int)(index >>> 6);
    }

    protected static final int bit(long index) {
        return (int)(index & 0x3FL);
    }

    protected static final long mask(long index) {
        return 1L << (int)(index & 0x3FL);
    }

    protected LongArrayBitVector(long capacity) {
        this.bits = capacity > 0L ? new long[LongArrayBitVector.numWords(capacity)] : LongArrays.EMPTY_ARRAY;
    }

    public static LongArrayBitVector getInstance(long capacity) {
        return new LongArrayBitVector(capacity);
    }

    public static LongArrayBitVector getInstance() {
        return new LongArrayBitVector(0L);
    }

    public static LongArrayBitVector ofLength(long length) {
        return new LongArrayBitVector(length).length(length);
    }

    public static LongArrayBitVector of(int ... bit) {
        LongArrayBitVector bitVector = new LongArrayBitVector(bit.length);
        for (int b : bit) {
            bitVector.add(b);
        }
        return bitVector;
    }

    public long[] bits() {
        return this.bits;
    }

    public long length() {
        return this.length;
    }

    public LongArrayBitVector ensureCapacity(long numBits) {
        this.bits = LongArrays.grow((long[])this.bits, (int)LongArrayBitVector.numWords(numBits), (int)LongArrayBitVector.numWords(this.length));
        return this;
    }

    public LongArrayBitVector length(long newLength) {
        this.bits = LongArrays.ensureCapacity((long[])this.bits, (int)LongArrayBitVector.numWords(newLength), (int)LongArrayBitVector.numWords(this.length));
        long oldLength = this.length;
        this.length = newLength;
        if (newLength > oldLength) {
            this.fill(oldLength, newLength, false);
        }
        return this;
    }

    public boolean trim() {
        if (this.bits.length == LongArrayBitVector.numWords(this.length)) {
            return false;
        }
        this.bits = LongArrays.setLength((long[])this.bits, (int)LongArrayBitVector.numWords(this.length));
        return true;
    }

    public void clear() {
        this.length = 0L;
        LongArrays.fill((long[])this.bits, (long)0L);
    }

    public BitVector copy(long from, long to) {
        BitVectors.ensureFromTo(this.length, from, to);
        LongArrayBitVector copy = new LongArrayBitVector(to - from);
        copy.length = to - from;
        if (copy.length == 0L) {
            return copy;
        }
        int numWords = LongArrayBitVector.numWords(to - from);
        int startWord = LongArrayBitVector.word(from);
        int startBit = LongArrayBitVector.bit(from);
        int endBit = LongArrayBitVector.bit(to);
        if (startBit == 0) {
            System.arraycopy(this.bits, startWord, copy.bits, 0, numWords);
            if (endBit > 0) {
                int n = numWords - 1;
                copy.bits[n] = copy.bits[n] & (1L << endBit) - 1L;
            }
        } else if (startWord == LongArrayBitVector.word(to - 1L)) {
            copy.bits[0] = this.bits[startWord] >>> startBit & (1L << (int)(to - from)) - 1L;
        } else {
            copy.bits[0] = this.bits[startWord] >>> startBit;
            for (int word = 1; word < numWords; ++word) {
                int n = word - 1;
                copy.bits[n] = copy.bits[n] | this.bits[word + startWord] << 64 - startBit;
                copy.bits[word] = this.bits[word + startWord] >>> startBit;
            }
            if (endBit > 0) {
                int n = numWords - 1;
                copy.bits[n] = copy.bits[n] & (1L << endBit) - 1L;
            }
        }
        return copy;
    }

    public LongArrayBitVector copy() {
        LongArrayBitVector copy = new LongArrayBitVector(this.length);
        copy.length = this.length;
        System.arraycopy(this.bits, 0, copy.bits, 0, LongArrayBitVector.numWords(this.length));
        return copy;
    }

    public static LongArrayBitVector copy(BitVector bv) {
        LongArrayBitVector copy = new LongArrayBitVector(0L).length(bv.length());
        long fullBits = bv.length() - bv.length() % 64L;
        for (long i = 0L; i < fullBits; i += 64L) {
            copy.bits[(int)(i / 64L)] = bv.getLong(i, i + 64L);
        }
        if (bv.length() % 64L != 0L) {
            copy.bits[(int)(fullBits / 64L)] = bv.getLong(fullBits, bv.length());
        }
        return copy;
    }

    public boolean getBoolean(long index) {
        this.ensureRestrictedIndex(index);
        return (this.bits[LongArrayBitVector.word(index)] & LongArrayBitVector.mask(index)) != 0L;
    }

    public boolean set(long index, boolean value) {
        boolean oldValue;
        this.ensureRestrictedIndex(index);
        int word = LongArrayBitVector.word(index);
        long mask = LongArrayBitVector.mask(index);
        boolean bl = oldValue = (this.bits[word] & mask) != 0L;
        if (value) {
            int n = word;
            this.bits[n] = this.bits[n] | mask;
        } else {
            int n = word;
            this.bits[n] = this.bits[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return oldValue != value;
    }

    public void set(long index) {
        this.ensureRestrictedIndex(index);
        int n = LongArrayBitVector.word(index);
        this.bits[n] = this.bits[n] | LongArrayBitVector.mask(index);
    }

    public void clear(long index) {
        this.ensureRestrictedIndex(index);
        int n = LongArrayBitVector.word(index);
        this.bits[n] = this.bits[n] & (LongArrayBitVector.mask(index) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void add(long index, boolean value) {
        this.ensureIndex(index);
        if (this.length == (long)(this.bits.length << 6)) {
            this.bits = LongArrays.grow((long[])this.bits, (int)LongArrayBitVector.numWords(this.length + 1L));
        }
        ++this.length;
        if (index == this.length - 1L) {
            this.set(index, value);
        } else {
            int word = LongArrayBitVector.word(index);
            int bit = LongArrayBitVector.bit(index);
            boolean carry = (this.bits[word] & Long.MIN_VALUE) != 0L;
            long t = this.bits[word];
            t = bit == 63 ? (t &= Long.MAX_VALUE) : (t & -(1L << bit)) << 1 | t & (1L << bit) - 1L;
            if (value) {
                t |= 1L << bit;
            }
            this.bits[word] = t;
            int numWords = LongArrayBitVector.numWords(this.length);
            for (int i = word + 1; i < numWords; ++i) {
                boolean nextCarry = (this.bits[i] & Long.MIN_VALUE) != 0L;
                int n = i;
                this.bits[n] = this.bits[n] << 1;
                if (carry) {
                    int n2 = i;
                    this.bits[n2] = this.bits[n2] | 1L;
                }
                carry = nextCarry;
            }
        }
    }

    public boolean removeBoolean(long index) {
        this.ensureRestrictedIndex(index);
        boolean oldValue = this.getBoolean(index);
        long[] bits = this.bits;
        int word = LongArrayBitVector.word(index);
        int bit = LongArrayBitVector.bit(index);
        bits[word] = (bits[word] & -(1L << bit) << 1) >>> 1 | bits[word] & (1L << bit) - 1L;
        int numWords = LongArrayBitVector.numWords(this.length--);
        int i = word + 1;
        while (i < numWords) {
            if ((bits[i] & 1L) != 0L) {
                int n = i - 1;
                bits[n] = bits[n] | Long.MIN_VALUE;
            }
            int n = i++;
            bits[n] = bits[n] >>> 1;
        }
        return oldValue;
    }

    public LongArrayBitVector append(long value, int width) {
        long length;
        if (width == 0) {
            return this;
        }
        if (width < 64 && (value & 1L << width) != 0L) {
            throw new IllegalArgumentException("The specified value (" + value + ") is larger than the maximum value for the given width (" + width + ")");
        }
        long start = length = this.length;
        long end = length + (long)width - 1L;
        int startWord = LongArrayBitVector.word(start);
        int endWord = LongArrayBitVector.word(end);
        this.ensureCapacity(length + (long)width);
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] | value << LongArrayBitVector.bit(start);
        } else {
            int startBit = LongArrayBitVector.bit(start);
            int n = startWord;
            this.bits[n] = this.bits[n] | value << startBit;
            this.bits[endWord] = value >>> 64 - startBit;
        }
        this.length += (long)width;
        return this;
    }

    public long getLong(long from, long to) {
        if (to > this.length) {
            throw new IndexOutOfBoundsException(Long.toString(to));
        }
        if (from < 0L) {
            throw new IndexOutOfBoundsException(Long.toString(from));
        }
        if (from % 64L == 0L && to == from + 64L) {
            return this.bits[(int)(from / 64L)];
        }
        if (from == to) {
            return 0L;
        }
        int startWord = LongArrayBitVector.word(from);
        int endWord = LongArrayBitVector.word(--to);
        int startBit = LongArrayBitVector.bit(from);
        long mask = 1L << (int)(to - from);
        mask |= mask - 1L;
        if (startWord == endWord) {
            return this.bits[startWord] >>> startBit & mask;
        }
        return this.bits[startWord] >>> startBit | this.bits[endWord] << 64 - startBit & mask;
    }

    public long count() {
        long c = 0L;
        int i = LongArrayBitVector.numWords(this.length);
        while (i-- != 0) {
            c += (long)Fast.count(this.bits[i]);
        }
        return c;
    }

    public long nextOne(long index) {
        if (index >= this.length) {
            return -1L;
        }
        long[] bits = this.bits;
        long words = LongArrayBitVector.numWords(this.length);
        int from = LongArrayBitVector.word(index);
        long maskedFirstWord = bits[from] & -(1L << LongArrayBitVector.bit(index));
        if (maskedFirstWord != 0L) {
            return from * 64 + Fast.leastSignificantBit(maskedFirstWord);
        }
        int i = from + 1;
        while ((long)i < words) {
            if (bits[i] != 0L) {
                return i * 64 + Fast.leastSignificantBit(bits[i]);
            }
            ++i;
        }
        return -1L;
    }

    public long previousOne(long index) {
        long mask;
        if (index == 0L) {
            return -1L;
        }
        long[] bits = this.bits;
        int from = LongArrayBitVector.word(index - 1L);
        long maskedFirstWord = bits[from] & ((mask = 1L << LongArrayBitVector.bit(index - 1L)) | mask - 1L);
        if (maskedFirstWord != 0L) {
            return from * 64 + Fast.mostSignificantBit(maskedFirstWord);
        }
        int i = from;
        while (i-- != 0) {
            if (bits[i] == 0L) continue;
            return i * 64 + Fast.mostSignificantBit(bits[i]);
        }
        return -1L;
    }

    public long longestCommonPrefixLength(BitVector v) {
        if (v instanceof LongArrayBitVector) {
            return this.longestCommonPrefixLength((LongArrayBitVector)v);
        }
        return super.longestCommonPrefixLength(v);
    }

    public long longestCommonPrefixLength(LongArrayBitVector v) {
        long words = Math.min(this.bits.length, v.bits.length);
        long[] bits = this.bits;
        long[] vBits = v.bits;
        int i = 0;
        while ((long)i < words) {
            if (bits[i] != vBits[i]) {
                return i * 64 + Fast.leastSignificantBit(bits[i] ^ vBits[i]);
            }
            ++i;
        }
        return Math.min(v.length(), this.length());
    }

    public BitVector and(BitVector v) {
        if (v instanceof LongArrayBitVector) {
            LongArrayBitVector l = (LongArrayBitVector)v;
            int words = Math.min(LongArrayBitVector.numWords(this.length()), LongArrayBitVector.numWords(l.length()));
            while (words-- != 0) {
                int n = words;
                this.bits[n] = this.bits[n] & l.bits[words];
            }
        } else {
            super.and(v);
        }
        return this;
    }

    public BitVector or(BitVector v) {
        if (v instanceof LongArrayBitVector) {
            LongArrayBitVector l = (LongArrayBitVector)v;
            int words = Math.min(LongArrayBitVector.numWords(this.length()), LongArrayBitVector.numWords(l.length()));
            while (words-- != 0) {
                int n = words;
                this.bits[n] = this.bits[n] | l.bits[words];
            }
        } else {
            super.or(v);
        }
        return this;
    }

    public BitVector xor(BitVector v) {
        if (v instanceof LongArrayBitVector) {
            LongArrayBitVector l = (LongArrayBitVector)v;
            int words = Math.min(LongArrayBitVector.numWords(this.length()), LongArrayBitVector.numWords(l.length()));
            while (words-- != 0) {
                int n = words;
                this.bits[n] = this.bits[n] ^ l.bits[words];
            }
        } else {
            super.xor(v);
        }
        return this;
    }

    public static LongArrayBitVector wrap(long[] array, long size) {
        if (size > (long)(array.length << 6)) {
            throw new IllegalArgumentException("The provided array is too short (" + array.length + " elements) for the given size (" + size + ")");
        }
        LongArrayBitVector result = new LongArrayBitVector(0L);
        result.length = size;
        result.bits = array;
        int lastWord = (int)(size / 64L);
        int arrayLength = array.length;
        if (lastWord < arrayLength && (array[lastWord] & ((1L << (int)(size % 64L)) - 1L ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            throw new IllegalArgumentException("Garbage beyond size in bit array");
        }
        for (int i = lastWord + 1; i < arrayLength; ++i) {
            if (array[i] == 0L) continue;
            throw new IllegalArgumentException("Garbage beyond size in bit array");
        }
        return result;
    }

    public static LongArrayBitVector wrap(long[] array) {
        return LongArrayBitVector.wrap(array, array.length * 64);
    }

    public LongArrayBitVector clone() throws CloneNotSupportedException {
        LongArrayBitVector copy = (LongArrayBitVector)super.clone();
        copy.bits = (long[])this.bits.clone();
        return copy;
    }

    public LongArrayBitVector replace(LongArrayBitVector bv) {
        this.clear();
        this.ensureCapacity(bv.length());
        long[] bits = this.bits;
        long[] bvBits = bv.bits;
        int i = LongArrayBitVector.word(bv.length - 1L);
        while (i-- != 0) {
            bits[i] = bvBits[i];
        }
        this.length = bv.length;
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof LongArrayBitVector) {
            return this.equals((LongArrayBitVector)o);
        }
        return super.equals(o);
    }

    public boolean equals(LongArrayBitVector v) {
        if (this.length != v.length()) {
            return false;
        }
        int i = LongArrayBitVector.numWords(this.length);
        while (i-- != 0) {
            if (this.bits[i] == v.bits[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long h = 1234L;
        int i = LongArrayBitVector.numWords(this.length);
        while (i-- != 0) {
            h ^= this.bits[i] * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    public LongBigList asLongBigList(int width) {
        return new LongBigListView(this, width);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int numWords = LongArrayBitVector.numWords(this.length);
        for (int i = 0; i < numWords; ++i) {
            s.writeLong(this.bits[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numWords = LongArrayBitVector.numWords(this.length);
        this.bits = new long[numWords];
        for (int i = 0; i < numWords; ++i) {
            this.bits[i] = s.readLong();
        }
    }

    protected static class LongBigListView
    extends AbstractBitVector.LongBigListView {
        private static final long serialVersionUID = 1L;
        private static final boolean ASSERTS = false;
        private final LongArrayBitVector bitVector;

        public LongBigListView(LongArrayBitVector bitVector, int width) {
            super(bitVector, width);
            this.bitVector = bitVector;
        }

        public boolean add(long value) {
            this.bitVector.append(value, this.width);
            return true;
        }

        public long getLong(long index) {
            long start = index * (long)this.width;
            return this.bitVector.getLong(start, start + (long)this.width);
        }

        public void clear() {
            this.bitVector.clear();
        }

        public long set(long index, long value) {
            long oldValue;
            if (this.width == 0) {
                return 0L;
            }
            if (this.width != 64 && value > this.maxValue) {
                throw new IllegalArgumentException("Value too large:" + value);
            }
            long[] bits = this.bitVector.bits;
            long start = index * (long)this.width;
            int startWord = LongArrayBitVector.word(start);
            int endWord = LongArrayBitVector.word(start + (long)this.width - 1L);
            int startBit = LongArrayBitVector.bit(start);
            if (startWord == endWord) {
                oldValue = bits[startWord] >>> startBit & this.maxValue;
                int n = startWord;
                bits[n] = bits[n] & (this.maxValue << startBit ^ 0xFFFFFFFFFFFFFFFFL);
                int n2 = startWord;
                bits[n2] = bits[n2] | value << startBit;
            } else {
                oldValue = bits[startWord] >>> startBit | bits[endWord] << 64 - startBit & this.maxValue;
                int n = startWord;
                bits[n] = bits[n] & (1L << startBit) - 1L;
                int n3 = startWord;
                bits[n3] = bits[n3] | value << startBit;
                int n4 = endWord;
                bits[n4] = bits[n4] & -(1L << this.width - 64 + startBit);
                int n5 = endWord;
                bits[n5] = bits[n5] | value >>> 64 - startBit;
            }
            return oldValue;
        }
    }
}

