/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

import it.unimi.dsi.bits.AbstractBitVector;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.TransformationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitVectors {
    private static final TransformationStrategy<BitVector> IDENTITY = new TransformationStrategy<BitVector>(){
        private static final long serialVersionUID = 1L;

        @Override
        public BitVector toBitVector(BitVector object) {
            return object;
        }

        @Override
        public long numBits() {
            return 0L;
        }

        @Override
        public TransformationStrategy<BitVector> copy() {
            return this;
        }
    };
    public static final BitVector EMPTY_VECTOR = new AbstractBitVector(){

        public final long length() {
            return 0L;
        }

        public final BitVector copy(long from, long to) {
            BitVectors.ensureFromTo(0L, from, to);
            return EMPTY_VECTOR;
        }

        public final boolean getBoolean(long index) {
            throw new IndexOutOfBoundsException();
        }
    };
    public static final BitVector ZERO = new AbstractBitVector(){

        public final long length() {
            return 1L;
        }

        public final BitVector copy(long from, long to) {
            BitVectors.ensureFromTo(1L, from, to);
            return from == to ? EMPTY_VECTOR : this;
        }

        public final boolean getBoolean(long index) {
            if (index > 0L) {
                throw new IndexOutOfBoundsException();
            }
            return false;
        }
    };
    public static final BitVector ONE = new AbstractBitVector(){

        public final long length() {
            return 1L;
        }

        public final BitVector copy(long from, long to) {
            BitVectors.ensureFromTo(1L, from, to);
            return from == to ? EMPTY_VECTOR : this;
        }

        public final boolean getBoolean(long index) {
            if (index > 0L) {
                throw new IndexOutOfBoundsException();
            }
            return true;
        }
    };

    private BitVectors() {
    }

    public static <T extends BitVector> TransformationStrategy<T> identity() {
        return IDENTITY;
    }

    public static void ensureFromTo(long bitVectorLength, long from, long to) {
        if (from < 0L) {
            throw new ArrayIndexOutOfBoundsException("Start index (" + from + ") is negative");
        }
        if (from > to) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        if (to > bitVectorLength) {
            throw new ArrayIndexOutOfBoundsException("End index (" + to + ") is greater than array length (" + bitVectorLength + ")");
        }
    }
}

