/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.stringparsers;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.PropertyStringParser;
import com.martiansoftware.jsap.stringparsers.BooleanStringParser;
import java.io.File;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileStringParser
extends PropertyStringParser {
    public static final String MUSTBEFILE = "mustBeFile";
    public static final String MUSTBEDIRECTORY = "mustBeDirectory";
    public static final String MUSTEXIST = "mustExist";
    private boolean mustExist;
    private boolean mustBeDirectory;
    private boolean mustBeFile;

    public static FileStringParser getParser() {
        return new FileStringParser();
    }

    public void setUp() throws ParseException {
        BooleanStringParser booleanStringParser = JSAP.BOOLEAN_PARSER;
        this.setMustExist((Boolean)booleanStringParser.parse(this.getProperty(MUSTEXIST, "false")));
        this.setMustBeDirectory((Boolean)booleanStringParser.parse(this.getProperty(MUSTBEDIRECTORY, "false")));
        this.setMustBeFile((Boolean)booleanStringParser.parse(this.getProperty(MUSTBEFILE, "false")));
    }

    public void setMustBeDirectory(boolean bl) {
        this.mustBeDirectory = bl;
    }

    public void setMustBeFile(boolean bl) {
        this.mustBeFile = bl;
    }

    public void setMustExist(boolean bl) {
        this.mustExist = bl;
    }

    public boolean mustBeDirectory() {
        return this.mustBeDirectory;
    }

    public boolean mustBeFile() {
        return this.mustBeFile;
    }

    public boolean mustExist() {
        return this.mustExist;
    }

    public void tearDown() {
    }

    public Object parse(String string) throws ParseException {
        File file = null;
        try {
            file = new File(string);
            if (this.mustBeDirectory() && !file.isDirectory()) {
                throw new ParseException(file + " is not a directory.");
            }
            if (this.mustBeFile() && file.isDirectory()) {
                throw new ParseException(file + " is a directory.");
            }
            if (this.mustExist() && !file.exists()) {
                throw new ParseException(file + " does not exist.");
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new ParseException("No File given to parse", nullPointerException);
        }
        return file;
    }

    private final /* synthetic */ void this() {
        this.mustExist = false;
        this.mustBeDirectory = false;
        this.mustBeFile = false;
    }

    public FileStringParser() {
        this.this();
    }
}

