/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.defaultsources;

import com.martiansoftware.jsap.DefaultSource;
import com.martiansoftware.jsap.Defaults;
import com.martiansoftware.jsap.ExceptionMap;
import com.martiansoftware.jsap.IDMap;
import com.martiansoftware.jsap.JSAPException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PropertyDefaultSource
implements DefaultSource {
    private boolean loadFromFile;
    private boolean loadFromProperties;
    private boolean loadFromInputStream;
    private InputStream in;
    private String propertyFileName;
    private boolean throwIOExceptions;
    private Properties properties;
    private boolean loaded;

    private final Properties getProperties() throws IOException {
        Properties properties;
        block5: {
            if (!this.loaded) {
                try {
                    if (this.loadFromFile) {
                        this.in = new BufferedInputStream(new FileInputStream(this.propertyFileName));
                    }
                    properties = new Properties();
                    properties.load(this.in);
                    this.in.close();
                    this.in = null;
                    this.properties = properties;
                    this.loaded = true;
                }
                catch (IOException iOException) {
                    if (!this.throwIOExceptions) break block5;
                    throw iOException;
                }
            }
        }
        if ((properties = this.properties) == null) {
            properties = this.properties = new Properties();
            this.loaded = true;
        }
        return properties;
    }

    public Defaults getDefaults(IDMap iDMap, ExceptionMap exceptionMap) {
        Defaults defaults = new Defaults();
        try {
            Properties properties = this.getProperties();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (iDMap.idExists(string)) {
                    defaults.addDefault(string, properties.getProperty(string));
                    continue;
                }
                String string2 = iDMap.getIDByLongFlag(string);
                if (string2 != null) {
                    defaults.addDefault(string2, properties.getProperty(string));
                    continue;
                }
                if (string.length() == 1) {
                    string2 = iDMap.getIDByShortFlag(string.charAt(0));
                    if (string2 != null) {
                        defaults.addDefault(string2, properties.getProperty(string));
                        continue;
                    }
                    exceptionMap.addException(null, new JSAPException("Unknown parameter: " + string));
                    continue;
                }
                exceptionMap.addException(null, new JSAPException("Unknown parameter: " + string));
            }
        }
        catch (IOException iOException) {
            exceptionMap.addException(null, new JSAPException("Unable to load properties.", iOException));
        }
        return defaults;
    }

    private final /* synthetic */ void this() {
        this.loadFromFile = false;
        this.loadFromProperties = false;
        this.loadFromInputStream = false;
        this.in = null;
        this.propertyFileName = null;
        this.throwIOExceptions = true;
        this.properties = null;
        this.loaded = false;
    }

    public PropertyDefaultSource(String string, boolean bl) {
        this.this();
        this.loadFromFile = true;
        this.propertyFileName = string;
        this.throwIOExceptions = bl;
    }

    public PropertyDefaultSource(Properties properties) {
        this.this();
        this.loadFromProperties = true;
        this.properties = properties;
        this.loaded = true;
    }

    public PropertyDefaultSource(InputStream inputStream, boolean bl) {
        this.this();
        this.loadFromInputStream = true;
        this.in = inputStream;
        this.throwIOExceptions = bl;
    }
}

