/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.util;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.mg4j.util.SemiExternalOffsetList;
import java.io.IOException;
import junit.framework.TestCase;

public class SemiExternalOffsetListTest
extends TestCase {
    private static InputBitStream buildInputStream(LongList offsets) throws IOException {
        byte[] array = new byte[offsets.size() * 4];
        OutputBitStream streamer = new OutputBitStream(array);
        long previous = 0L;
        for (int i = 0; i < offsets.size(); ++i) {
            long value = offsets.getLong(i);
            streamer.writeLongGamma(value - previous);
            previous = value;
        }
        int size = (int)(streamer.writtenBits() / 8L) + (streamer.writtenBits() % 8L == 0L ? 0 : 1);
        byte[] smaller = new byte[size];
        System.arraycopy(array, 0, smaller, 0, size);
        return new InputBitStream(smaller);
    }

    public void testSemiExternalOffsetListGammaCoding() throws IOException {
        int i;
        long[] offsets = new long[]{10L, 300L, 450L, 650L, 1000L, 1290L, 1699L};
        LongArrayList listOffsets = new LongArrayList(offsets);
        SemiExternalOffsetList list = new SemiExternalOffsetList(SemiExternalOffsetListTest.buildInputStream((LongList)listOffsets), 1, listOffsets.size());
        for (i = 0; i < offsets.length; ++i) {
            SemiExternalOffsetListTest.assertEquals((String)("test failed for index: " + i), (long)offsets[i], (long)list.getLong(i));
        }
        list = new SemiExternalOffsetList(SemiExternalOffsetListTest.buildInputStream((LongList)listOffsets), 2, listOffsets.size());
        for (i = 0; i < offsets.length; ++i) {
            SemiExternalOffsetListTest.assertEquals((String)("test failed for index: " + i), (long)offsets[i], (long)list.getLong(i));
        }
        list = new SemiExternalOffsetList(SemiExternalOffsetListTest.buildInputStream((LongList)listOffsets), 4, listOffsets.size());
        for (i = 0; i < offsets.length; ++i) {
            SemiExternalOffsetListTest.assertEquals((String)("test failed for index: " + i), (long)offsets[i], (long)list.getLong(i));
        }
        list = new SemiExternalOffsetList(SemiExternalOffsetListTest.buildInputStream((LongList)listOffsets), 7, listOffsets.size());
        for (i = 0; i < offsets.length; ++i) {
            SemiExternalOffsetListTest.assertEquals((String)("test failed for index: " + i), (long)offsets[i], (long)list.getLong(i));
        }
        list = new SemiExternalOffsetList(SemiExternalOffsetListTest.buildInputStream((LongList)listOffsets), 8, listOffsets.size());
        for (i = 0; i < offsets.length; ++i) {
            SemiExternalOffsetListTest.assertEquals((String)("test failed for index: " + i), (long)offsets[i], (long)list.getLong(i));
        }
    }

    public void testEmptySemiExternalOffsetListGammaCoding() throws IOException {
        long[] offsets = new long[]{};
        LongArrayList listOffsets = new LongArrayList(offsets);
        new SemiExternalOffsetList(SemiExternalOffsetListTest.buildInputStream((LongList)listOffsets), 1, listOffsets.size());
        SemiExternalOffsetListTest.assertTrue((boolean)true);
    }
}

