/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.tool;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import it.unimi.dsi.Util;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.bits.Utf16TransformationStrategy;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Object2LongFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.WordReader;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.mg4j.document.CompositeDocumentSequence;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.DocumentSequence;
import it.unimi.dsi.mg4j.document.IdentityDocumentFactory;
import it.unimi.dsi.mg4j.document.InputStreamDocumentSequence;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.DiskBasedIndex;
import it.unimi.dsi.mg4j.index.DowncaseTermProcessor;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.index.cluster.ContiguousLexicalStrategy;
import it.unimi.dsi.mg4j.index.cluster.DocumentalStrategies;
import it.unimi.dsi.mg4j.index.cluster.IndexCluster;
import it.unimi.dsi.mg4j.index.cluster.LexicalStrategies;
import it.unimi.dsi.mg4j.tool.Concatenate;
import it.unimi.dsi.mg4j.tool.IndexBuilder;
import it.unimi.dsi.mg4j.tool.Merge;
import it.unimi.dsi.mg4j.tool.PartitionDocumentally;
import it.unimi.dsi.mg4j.tool.PartitionLexically;
import it.unimi.dsi.mg4j.tool.Scan;
import it.unimi.dsi.mg4j.tool.VirtualDocumentResolver;
import it.unimi.dsi.sux4j.mph.MWHCFunction;
import it.unimi.dsi.sux4j.util.ShiftAddXorSignedStringMap;
import it.unimi.dsi.util.Properties;
import it.unimi.dsi.util.StringMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.log4j.Level;
import test.it.unimi.dsi.mg4j.document.DateArrayDocumentCollection;
import test.it.unimi.dsi.mg4j.document.IntArrayDocumentCollection;
import test.it.unimi.dsi.mg4j.document.MapVirtualDocumentCollection;
import test.it.unimi.dsi.mg4j.document.StringArrayDocumentCollection;
import test.it.unimi.dsi.mg4j.tool.Modulo3DocumentalClusteringStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexTest
extends TestCase {
    private String basename;
    private final int NUMBER_OF_DOCUMENTS = 100;
    private final int[] INTEGER_DOCUMENT = new int[100];
    private final Date[] DATE_DOCUMENT = new Date[100];
    private final Int2ObjectMap<String>[] VIRTUAL_DOCUMENT = new Int2ObjectMap[100];
    private final VirtualDocumentResolver RESOLVER;
    public static final TermProcessor KILL_A_PROCESSOR;
    static final int[] INDEXED_FIELD;
    private DocumentSequence lastSequence;

    public IndexTest() {
        int i = this.INTEGER_DOCUMENT.length;
        while (i-- != 0) {
            this.INTEGER_DOCUMENT[i] = i;
        }
        i = this.DATE_DOCUMENT.length;
        while (i-- != 0) {
            this.DATE_DOCUMENT[i] = new Date((long)i * 86400000L);
        }
        i = this.VIRTUAL_DOCUMENT.length;
        while (i-- != 0) {
            this.VIRTUAL_DOCUMENT[i] = new Int2ObjectArrayMap();
            this.VIRTUAL_DOCUMENT[i].put(i - 1, (Object)"link to previous document");
            this.VIRTUAL_DOCUMENT[i].put(i, (Object)"link to this document");
            this.VIRTUAL_DOCUMENT[i].put(i + 1, (Object)"link to next document");
        }
        this.RESOLVER = new MapVirtualDocumentCollection.TrivialVirtualDocumentResolver(100);
    }

    private static StringMap<? extends CharSequence> createMap(String basename) {
        FileLinesCollection flc = new FileLinesCollection((CharSequence)basename, "UTF-8");
        return new ShiftAddXorSignedStringMap((Iterator)flc.iterator(), (Object2LongFunction)new MWHCFunction((Iterable)flc, (TransformationStrategy)new Utf16TransformationStrategy()));
    }

    private void sameIndex(String basename0, String basename1, String ... excludedProperty) throws IOException, ConfigurationException {
        for (String ext : new String[]{".index", ".offsets", ".terms", ".sizes", ".frequencies", ".globcounts"}) {
            File f0 = new File(basename0 + ext);
            File f1 = new File(basename1 + ext);
            IndexTest.assertEquals((String)ext, (boolean)f0.exists(), (boolean)f1.exists());
            if (!f0.exists()) continue;
            IndexTest.assertTrue((String)ext, (boolean)IOUtils.contentEquals((InputStream)new FileInputStream(f0), (InputStream)new FileInputStream(f1)));
        }
        Properties properties0 = new Properties(basename0 + ".properties");
        Properties properties1 = new Properties(basename1 + ".properties");
        for (String p : excludedProperty) {
            properties0.setProperty(p, null);
            properties1.setProperty(p, null);
        }
        IndexTest.assertEquals((Object)properties0, (Object)properties1);
    }

    public void sameContent(CharSequence basename0, CharSequence basename1, FileLinesCollection.FileLinesIterator terms) throws ConfigurationException, SecurityException, IOException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.sameContent(Index.getInstance(basename0), Index.getInstance(basename1), terms);
    }

    public void sameContent(CharSequence basename0, CharSequence basename1) throws ConfigurationException, SecurityException, IOException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.sameContent(basename0, basename1, null);
    }

    public void sameContent(Index index0, Index index1) throws IOException {
        this.sameContent(index0, index1, null);
    }

    public void sameContent(Index index0, Index index1, FileLinesCollection.FileLinesIterator terms) throws IOException {
        IndexTest.assertEquals((boolean)index0.hasCounts, (boolean)index1.hasCounts);
        IndexTest.assertEquals((boolean)index0.hasPositions, (boolean)index1.hasPositions);
        IndexTest.assertEquals((boolean)index0.hasPayloads, (boolean)index1.hasPayloads);
        IndexTest.assertEquals((int)index0.numberOfTerms, (int)index1.numberOfTerms);
        IndexTest.assertEquals((int)index0.numberOfDocuments, (int)index1.numberOfDocuments);
        int numTerms = index0.numberOfTerms;
        int[] p0 = IntArrays.EMPTY_ARRAY;
        int[] p1 = IntArrays.EMPTY_ARRAY;
        boolean hasCounts = index0.hasCounts;
        boolean hasPositions = index0.hasPositions;
        IndexReader reader0 = index0.getReader();
        IndexReader reader1 = index1.getReader();
        for (int i = 0; i < numTerms; ++i) {
            IndexIterator i1;
            IndexIterator i0;
            if (terms != null) {
                MutableString term = terms.next();
                i0 = reader0.documents((CharSequence)term);
                i1 = reader1.documents((CharSequence)term);
            } else {
                i0 = reader0.documents(i);
                i1 = reader1.documents(i);
            }
            while (i0.hasNext() && i1.hasNext()) {
                int document = i0.nextDocument();
                IndexTest.assertEquals((String)("term " + i), (int)document, (int)i1.nextDocument());
                if (!hasCounts) continue;
                IndexTest.assertEquals((String)("term " + i + ", document " + document), (int)i0.count(), (int)i1.count());
                if (i0.count() > p0.length) {
                    p0 = new int[i0.count()];
                }
                if (i1.count() > p1.length) {
                    p1 = new int[i1.count()];
                }
                if (!hasPositions) continue;
                int p = i0.count();
                while (p-- != 0) {
                    IndexTest.assertEquals((String)("term " + i + ", document " + document + ", position " + p), (int)p0[p], (int)p1[p]);
                }
            }
            IndexTest.assertEquals((String)("term " + i), (boolean)i0.hasNext(), (boolean)i1.hasNext());
        }
        reader0.close();
        reader1.close();
    }

    public int processDocument(WordReader wordReader, int documentIndex, int startPos, Object2ObjectOpenHashMap<MutableString, ObjectArrayList<int[]>> termMap, TermProcessor termProcessor) throws IOException {
        IndexTest.assertTrue((documentIndex >= 0 ? 1 : 0) != 0);
        Object2ObjectOpenHashMap terms = new Object2ObjectOpenHashMap();
        MutableString word = new MutableString();
        MutableString nonWord = new MutableString();
        int pos = startPos;
        while (wordReader.next(word, nonWord)) {
            if (word.length() == 0) continue;
            if (!termProcessor.processTerm(word)) {
                ++pos;
                continue;
            }
            IntArrayList positions = (IntArrayList)terms.get((Object)word);
            if (positions == null) {
                positions = new IntArrayList();
                terms.put((Object)word.copy(), (Object)positions);
            }
            positions.add(pos++);
        }
        for (MutableString term : terms.keySet()) {
            ObjectArrayList list = (ObjectArrayList)termMap.get((Object)term);
            IntArrayList positions = (IntArrayList)terms.get((Object)term);
            if (list == null) {
                list = new ObjectArrayList();
                termMap.put((Object)term, (Object)list);
            }
            int[] t = new int[positions.size() + 1];
            t[0] = documentIndex;
            System.arraycopy(positions.elements(), 0, t, 1, positions.size());
            list.add((Object)t);
        }
        return pos;
    }

    public void checkAgainstContent(DocumentSequence sequence, int[] map, VirtualDocumentResolver resolver, int gap, Index ... index) throws IOException {
        int i;
        Document document;
        DocumentIterator iterator = sequence.iterator();
        DocumentFactory factory = sequence.factory();
        int n = index.length;
        int[] field = new int[n];
        int[][] currMaxPos = new int[n][];
        int[] maxDoc = new int[n];
        IntArrays.fill((int[])maxDoc, (int)-1);
        Object2ObjectOpenHashMap[] termMap = new Object2ObjectOpenHashMap[n];
        IntArrayList[] payloadPointers = new IntArrayList[n];
        ObjectArrayList[] payloadContent = new ObjectArrayList[n];
        block17: for (int i2 = 0; i2 < n; ++i2) {
            field[i2] = factory.fieldIndex(index[i2].field);
            switch (factory.fieldType(field[i2])) {
                case VIRTUAL: {
                    currMaxPos[i2] = new int[resolver.numberOfDocuments()];
                }
                case TEXT: {
                    termMap[i2] = new Object2ObjectOpenHashMap();
                    continue block17;
                }
                case DATE: 
                case INT: {
                    payloadPointers[i2] = new IntArrayList();
                    payloadContent[i2] = new ObjectArrayList();
                }
            }
        }
        int documentIndex = 0;
        while ((document = iterator.nextDocument()) != null) {
            block19: for (i = 0; i < field.length; ++i) {
                switch (factory.fieldType(field[i])) {
                    case TEXT: {
                        this.processDocument(document.wordReader(field[i]).setReader((Reader)document.content(field[i])), map == null ? documentIndex : map[documentIndex], 0, (Object2ObjectOpenHashMap<MutableString, ObjectArrayList<int[]>>)termMap[i], index[i].termProcessor);
                        continue block19;
                    }
                    case VIRTUAL: {
                        ObjectArrayList fragments = (ObjectArrayList)document.content(field[i]);
                        resolver.context(document);
                        for (Scan.VirtualDocumentFragment fragment : fragments) {
                            int d = resolver.resolve((CharSequence)fragment.documentSpecifier());
                            if (d == -1) continue;
                            if (map != null) {
                                d = map[d];
                            }
                            if (maxDoc[i] < d) {
                                maxDoc[i] = d;
                            }
                            currMaxPos[i][d] = this.processDocument(document.wordReader(field[i]).setReader((Reader)new FastBufferedReader(fragment.text())), d, currMaxPos[i][d], (Object2ObjectOpenHashMap<MutableString, ObjectArrayList<int[]>>)termMap[i], index[i].termProcessor) + gap;
                        }
                        continue block19;
                    }
                    case DATE: 
                    case INT: {
                        Object x = document.content(field[i]);
                        if (x == null) continue block19;
                        payloadPointers[i].add(map == null ? documentIndex : map[documentIndex]);
                        payloadContent[i].add(x);
                    }
                }
            }
            document.close();
            ++documentIndex;
        }
        iterator.close();
        for (i = 0; i < n; ++i) {
            if (termMap[i] != null) {
                for (ObjectArrayList list : termMap[i].values()) {
                    Collections.sort(list, new Comparator<int[]>(){

                        @Override
                        public int compare(int[] p0, int[] p1) {
                            return p0[0] - p1[0];
                        }
                    });
                    switch (factory.fieldType(field[i])) {
                        case VIRTUAL: {
                            ObjectArrayList newList = new ObjectArrayList();
                            int k = 0;
                            while (k < list.size()) {
                                int s;
                                for (s = k + 1; s < list.size() && ((int[])list.get(k))[0] == ((int[])list.get(s))[0]; ++s) {
                                }
                                int count = 0;
                                for (int t = k; t < s; ++t) {
                                    count += ((int[])list.get(t)).length - 1;
                                }
                                int[] posting = new int[count + 1];
                                posting[0] = ((int[])list.get(k))[0];
                                count = 1;
                                for (int t = k; t < s; ++t) {
                                    System.arraycopy(list.get(t), 1, posting, count, ((int[])list.get(t)).length - 1);
                                    count += ((int[])list.get(t)).length - 1;
                                }
                                k = s;
                                newList.add((Object)posting);
                            }
                            list.clear();
                            list.addAll((Collection)newList);
                            break;
                        }
                    }
                }
            }
            if (payloadPointers[i] == null) continue;
            final int[] p = payloadPointers[i].elements();
            final Object[] b = payloadContent[i].elements();
            GenericSorting.quickSort((int)0, (int)payloadPointers[i].size(), (IntComparator)new IntComparator(){

                public int compare(int i0, int i1) {
                    return p[i0] - p[i1];
                }
            }, (Swapper)new Swapper(){

                public void swap(int i0, int i1) {
                    int t = p[i0];
                    p[i0] = p[i1];
                    p[i1] = t;
                    Object o = b[i0];
                    b[i0] = b[i1];
                    b[i1] = o;
                }
            });
        }
        block27: for (i = 0; i < n; ++i) {
            IndexTest.assertEquals((String)index[i].toString(), (int)(factory.fieldType(field[i]) == DocumentFactory.FieldType.VIRTUAL ? maxDoc[i] + 1 : documentIndex), (int)index[i].numberOfDocuments);
            switch (factory.fieldType(field[i])) {
                case VIRTUAL: 
                case TEXT: {
                    IndexTest.assertEquals((int)termMap[i].size(), (int)index[i].numberOfTerms);
                    int postings = 0;
                    int occurrences = 0;
                    for (ObjectArrayList l : termMap[i].values()) {
                        postings += l.size();
                        for (int[] p : l) {
                            occurrences += p.length - 1;
                        }
                    }
                    IndexTest.assertEquals((String)index[i].toString(), (long)postings, (long)index[i].numberOfPostings);
                    IndexTest.assertEquals((long)occurrences, (long)index[i].numberOfOccurrences);
                    IndexReader indexReader = index[i].getReader();
                    for (MutableString term : (MutableString[])new ObjectRBTreeSet((ObjectCollection)termMap[i].keySet()).toArray((Object[])new MutableString[termMap[i].size()])) {
                        String msg = index[i] + ":" + term;
                        IndexIterator indexIterator = indexReader.documents((CharSequence)term);
                        ObjectArrayList list = (ObjectArrayList)termMap[i].get((Object)term);
                        int k = 0;
                        while (indexIterator.hasNext()) {
                            IndexTest.assertEquals((String)msg, (int)((int[])list.get(k))[0], (int)indexIterator.nextDocument());
                            IndexTest.assertEquals((String)msg, (int)(((int[])list.get(k)).length - 1), (int)indexIterator.count());
                            int[] position = indexIterator.positionArray();
                            for (int p = 0; p < indexIterator.count(); ++p) {
                                IndexTest.assertEquals((String)msg, (int)((int[])list.get(k))[p + 1], (int)position[p]);
                            }
                            ++k;
                        }
                        IndexTest.assertEquals((int)k, (int)list.size());
                    }
                    indexReader.close();
                    continue block27;
                }
                case DATE: 
                case INT: {
                    IndexTest.assertEquals((String)index[i].toString(), (long)payloadPointers[i].size(), (long)index[i].numberOfPostings);
                    IndexTest.assertEquals((String)index[i].toString(), (int)(documentIndex != 0 ? 1 : 0), (int)index[i].numberOfTerms);
                    IndexTest.assertEquals((String)index[i].toString(), (long)-1L, (long)index[i].numberOfOccurrences);
                    if (documentIndex == 0) continue block27;
                    IndexIterator indexIterator = index[i].documents(0);
                    int k = 0;
                    while (indexIterator.hasNext()) {
                        IndexTest.assertEquals((int)payloadPointers[i].getInt(k), (int)indexIterator.nextDocument());
                        if (factory.fieldType(field[i]) == DocumentFactory.FieldType.INT) {
                            IndexTest.assertEquals((long)((Number)payloadContent[i].get(k)).longValue(), (long)((Number)indexIterator.payload().get()).longValue());
                        } else {
                            IndexTest.assertEquals((Object)payloadContent[i].get(k), (Object)indexIterator.payload().get());
                        }
                        ++k;
                    }
                    indexIterator.dispose();
                    IndexTest.assertEquals((int)k, (int)payloadContent[i].size());
                }
            }
        }
    }

    public void setUp() throws IOException {
        this.basename = File.createTempFile(((Object)((Object)this)).getClass().getSimpleName(), "test").getCanonicalPath();
    }

    public void tearDown() throws IOException {
        for (Object f : FileUtils.listFiles((File)new File(this.basename).getParentFile(), (IOFileFilter)FileFilterUtils.prefixFileFilter((String)((Object)((Object)this)).getClass().getSimpleName()), null)) {
            ((File)f).delete();
        }
        if (this.lastSequence != null) {
            this.lastSequence.close();
        }
    }

    public DocumentSequence getSequence() throws ConfigurationException, IOException {
        if (this.lastSequence != null) {
            this.lastSequence.close();
        }
        this.lastSequence = new CompositeDocumentSequence(new InputStreamDocumentSequence(((Object)((Object)this)).getClass().getResourceAsStream("documents.data"), 10, new IdentityDocumentFactory(new String[]{"encoding=UTF-8"}), 100), new IntArrayDocumentCollection(this.INTEGER_DOCUMENT), new DateArrayDocumentCollection(this.DATE_DOCUMENT), new MapVirtualDocumentCollection(this.VIRTUAL_DOCUMENT));
        return this.lastSequence;
    }

    public DocumentSequence getEmptySequence() throws ConfigurationException, IOException {
        if (this.lastSequence != null) {
            this.lastSequence.close();
        }
        this.lastSequence = new CompositeDocumentSequence(new StringArrayDocumentCollection(new String[0]), new IntArrayDocumentCollection(new int[0]), new DateArrayDocumentCollection(new Date[0]), new MapVirtualDocumentCollection(new Int2ObjectMap[0]));
        return this.lastSequence;
    }

    public void testIndex(int quantum, int height, TermProcessor termProcessor) throws ConfigurationException, SecurityException, IOException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        boolean interleaved;
        boolean bl = interleaved = quantum >= 0;
        if (!interleaved) {
            quantum = -quantum;
        }
        new IndexBuilder(this.basename, this.getSequence()).termProcessor(termProcessor).skipBufferSize(1024).pasteBufferSize(1024).interleaved(interleaved).skips(quantum != 0).quantum(quantum).height(height).virtualDocumentResolver(3, this.RESOLVER).documentsPerBatch(20).run();
        this.checkAgainstContent(this.getSequence(), null, this.RESOLVER, 64, Index.getInstance(this.basename + "-text"), Index.getInstance(this.basename + "-int"), Index.getInstance(this.basename + "-date"), Index.getInstance(this.basename + "-virtual"));
        String basenameZipped = this.basename + "-zipped";
        new IndexBuilder(this.basename, this.getSequence()).termProcessor(termProcessor).skipBufferSize(1024).pasteBufferSize(1024).interleaved(interleaved).skips(quantum != 0).quantum(quantum).height(height).virtualDocumentResolver(3, this.RESOLVER).documentsPerBatch(20).zipCollectionBasename(basenameZipped).run();
        new IndexBuilder(basenameZipped, (DocumentSequence)BinIO.loadObject((CharSequence)(basenameZipped + ".collection"))).termProcessor(termProcessor).indexedFields(0, 1, 2, 3).skipBufferSize(1024).pasteBufferSize(1024).interleaved(interleaved).skips(quantum != 0).quantum(quantum).height(height).virtualDocumentResolver(3, this.RESOLVER).documentsPerBatch(20).run();
        this.sameIndex(this.basename + "-text", basenameZipped + "-text", new String[0]);
        this.sameIndex(this.basename + "-int", basenameZipped + "-int", "batches");
        this.sameIndex(this.basename + "-date", basenameZipped + "-date", "batches");
        this.sameIndex(this.basename + "-virtual", basenameZipped + "-virtual", "batches");
        new IndexBuilder(this.basename + "-onebatch", this.getSequence()).termProcessor(termProcessor).skipBufferSize(1024).pasteBufferSize(1024).interleaved(interleaved).skips(quantum != 0).quantum(quantum).height(height).virtualDocumentResolver(3, this.RESOLVER).documentsPerBatch(100).run();
        this.sameIndex(this.basename + "-text", this.basename + "-onebatch-text", "batches");
        this.sameIndex(this.basename + "-int", this.basename + "-onebatch-int", "batches");
        this.sameIndex(this.basename + "-date", this.basename + "-onebatch-date", "batches");
        this.sameIndex(this.basename + "-virtual", this.basename + "-onebatch-virtual", "batches");
    }

    public void testIndex(int quantum, int height) throws ConfigurationException, SecurityException, IOException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.testIndex(quantum, height, DowncaseTermProcessor.getInstance());
    }

    public void testIndex() throws ConfigurationException, SecurityException, IOException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.testIndex(0, 0);
        this.testIndex(0, 0, KILL_A_PROCESSOR);
        this.testIndex(1, 1);
        this.testIndex(1, 2);
        this.testIndex(4, 1);
        this.testIndex(4, 4);
        this.testIndex(8, 1);
        this.testIndex(8, 4);
        this.testIndex(-1, 1);
        this.testIndex(-1, 2);
        this.testIndex(-4, 1);
        this.testIndex(-4, 4);
        this.testIndex(-8, 1);
        this.testIndex(-8, 4);
    }

    public void testRemappedIndex(int quantum, int height, TermProcessor termProcessor) throws IOException, ConfigurationException, SecurityException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        boolean interleaved;
        boolean bl = interleaved = quantum >= 0;
        if (!interleaved) {
            quantum = -quantum;
        }
        String basenameMapped = this.basename + "-map";
        int[] map = IntIterators.unwrap((IntIterator)BinIO.asIntIterator((DataInput)new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream("documents.permutation.data"))));
        String mapFile = File.createTempFile(((Object)((Object)this)).getClass().getSimpleName(), "map").toString();
        BinIO.storeInts((int[])map, (CharSequence)mapFile);
        new IndexBuilder(basenameMapped, this.getSequence()).termProcessor(termProcessor).skipBufferSize(1024).pasteBufferSize(1024).interleaved(interleaved).skips(quantum != 0).quantum(quantum).height(height).virtualDocumentResolver(3, this.RESOLVER).documentsPerBatch(20).mapFile(mapFile).run();
        this.checkAgainstContent(this.getSequence(), map, this.RESOLVER, 64, Index.getInstance(basenameMapped + "-text"), Index.getInstance(basenameMapped + "-int"), Index.getInstance(basenameMapped + "-date"), Index.getInstance(basenameMapped + "-virtual"));
        new IndexBuilder(basenameMapped + "-onebatch", this.getSequence()).termProcessor(termProcessor).skipBufferSize(1024).pasteBufferSize(1024).interleaved(interleaved).skips(quantum != 0).quantum(quantum).height(height).virtualDocumentResolver(3, this.RESOLVER).documentsPerBatch(100).mapFile(mapFile).run();
        this.sameIndex(basenameMapped + "-text", basenameMapped + "-onebatch-text", "batches");
        this.sameIndex(basenameMapped + "-int", basenameMapped + "-onebatch-int", "batches");
        this.sameIndex(basenameMapped + "-date", basenameMapped + "-onebatch-date", "batches");
        this.sameIndex(basenameMapped + "-virtual", basenameMapped + "-onebatch-virtual", "batches");
    }

    public void testRemappedIndex(int quantum, int height) throws ConfigurationException, SecurityException, IOException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.testRemappedIndex(quantum, height, DowncaseTermProcessor.getInstance());
    }

    public void testRemappedIndex() throws ConfigurationException, SecurityException, IOException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.testRemappedIndex(0, 0);
        this.testRemappedIndex(0, 0, KILL_A_PROCESSOR);
        this.testRemappedIndex(1, 1);
        this.testRemappedIndex(1, 2);
        this.testRemappedIndex(4, 1);
        this.testRemappedIndex(4, 4);
        this.testRemappedIndex(8, 1);
        this.testRemappedIndex(8, 4);
    }

    public void testPartitionConcatenate(int quantum, int height) throws Exception {
        String[] localIndex;
        boolean interleaved;
        boolean bl = interleaved = quantum >= 0;
        if (!interleaved) {
            quantum = -quantum;
        }
        new IndexBuilder(this.basename, this.getSequence()).skipBufferSize(1024).pasteBufferSize(1024).interleaved(interleaved).skips(quantum != 0).quantum(quantum).height(height).virtualDocumentResolver(3, this.RESOLVER).run();
        Reference2ReferenceArrayMap flags = new Reference2ReferenceArrayMap();
        flags.putAll(CompressionFlags.DEFAULT_STANDARD_INDEX);
        if (interleaved) {
            flags.put((Object)CompressionFlags.Component.POSITIONS, (Object)CompressionFlags.Coding.GOLOMB);
        }
        BinIO.storeObject((Object)DocumentalStrategies.uniform(3, 100), (CharSequence)(this.basename + "-strategy"));
        new PartitionDocumentally(this.basename + "-text", this.basename + "-text-part", DocumentalStrategies.uniform(3, 100), this.basename + "-strategy", 0, 1024, (Map<CompressionFlags.Component, CompressionFlags.Coding>)flags, interleaved, quantum != 0, quantum, height, 0x100000, 10000L).run();
        new PartitionDocumentally(this.basename + "-int", this.basename + "-int-part", DocumentalStrategies.uniform(3, 100), this.basename + "-strategy", 0, 1024, CompressionFlags.DEFAULT_PAYLOAD_INDEX, interleaved, quantum != 0, quantum, height, 0x100000, 10000L).run();
        new PartitionDocumentally(this.basename + "-date", this.basename + "-date-part", DocumentalStrategies.uniform(3, 100), this.basename + "-strategy", 0, 1024, CompressionFlags.DEFAULT_PAYLOAD_INDEX, interleaved, quantum != 0, quantum, height, 0x100000, 10000L).run();
        new PartitionDocumentally(this.basename + "-virtual", this.basename + "-virtual-part", DocumentalStrategies.uniform(3, 100), this.basename + "-strategy", 0, 1024, CompressionFlags.DEFAULT_STANDARD_INDEX, interleaved, quantum != 0, quantum, height, 0x100000, 10000L).run();
        for (String index : localIndex = new Properties(this.basename + "-text-part" + ".properties").getStringArray((Enum)IndexCluster.PropertyKeys.LOCALINDEX)) {
            BinIO.storeObject(IndexTest.createMap(index + ".terms"), (CharSequence)(index + ".termmap"));
        }
        this.sameContent(this.basename + "-text", this.basename + "-text-part", new FileLinesCollection((CharSequence)(this.basename + "-text" + ".terms"), "UTF-8").iterator());
        this.sameContent(this.basename + "-int", this.basename + "-int-part");
        this.sameContent(this.basename + "-date", this.basename + "-date-part");
        for (String index : localIndex = new Properties(this.basename + "-virtual-part" + ".properties").getStringArray((Enum)IndexCluster.PropertyKeys.LOCALINDEX)) {
            BinIO.storeObject(IndexTest.createMap(index + ".terms"), (CharSequence)(index + ".termmap"));
        }
        this.sameContent(this.basename + "-virtual", this.basename + "-virtual-part", new FileLinesCollection((CharSequence)(this.basename + "-virtual" + ".terms"), "UTF-8").iterator());
        localIndex = new Properties(this.basename + "-text-part" + ".properties").getStringArray((Enum)IndexCluster.PropertyKeys.LOCALINDEX);
        new Concatenate(this.basename + "-text-merged", localIndex, false, 1024, CompressionFlags.DEFAULT_STANDARD_INDEX, interleaved, quantum != 0, quantum, height, 0x100000, 10000L).run();
        this.sameIndex(this.basename + "-text", this.basename + "-text-merged", "batches");
        localIndex = new Properties(this.basename + "-int-part" + ".properties").getStringArray((Enum)IndexCluster.PropertyKeys.LOCALINDEX);
        new Concatenate(this.basename + "-int-merged", localIndex, false, 1024, CompressionFlags.DEFAULT_PAYLOAD_INDEX, interleaved, quantum != 0, quantum, height, 0x100000, 10000L).run();
        this.sameIndex(this.basename + "-int", this.basename + "-int-merged", "batches");
        localIndex = new Properties(this.basename + "-date-part" + ".properties").getStringArray((Enum)IndexCluster.PropertyKeys.LOCALINDEX);
        new Concatenate(this.basename + "-date-merged", localIndex, false, 1024, CompressionFlags.DEFAULT_PAYLOAD_INDEX, interleaved, quantum != 0, quantum, height, 0x100000, 10000L).run();
        this.sameIndex(this.basename + "-date", this.basename + "-date-merged", "batches");
        localIndex = new Properties(this.basename + "-virtual-part" + ".properties").getStringArray((Enum)IndexCluster.PropertyKeys.LOCALINDEX);
        new Concatenate(this.basename + "-virtual-merged", localIndex, false, 1024, CompressionFlags.DEFAULT_STANDARD_INDEX, interleaved, quantum != 0, quantum, height, 0x100000, 10000L).run();
        this.sameIndex(this.basename + "-virtual", this.basename + "-virtual-merged", "batches");
    }

    public void testPartitionConcatenate() throws Exception {
        this.testPartitionConcatenate(0, 0);
        this.testPartitionConcatenate(1, 1);
        this.testPartitionConcatenate(1, 2);
        this.testPartitionConcatenate(4, 1);
        this.testPartitionConcatenate(4, 4);
        this.testPartitionConcatenate(8, 1);
        this.testPartitionConcatenate(8, 4);
        this.testPartitionConcatenate(-1, 1);
        this.testPartitionConcatenate(-1, 2);
        this.testPartitionConcatenate(-4, 1);
        this.testPartitionConcatenate(-4, 4);
        this.testPartitionConcatenate(-8, 1);
        this.testPartitionConcatenate(-8, 4);
    }

    public void testPartitionMerge(int quantum, int height) throws ConfigurationException, SecurityException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, Exception {
        String[] localIndex;
        boolean interleaved;
        boolean bl = interleaved = quantum >= 0;
        if (!interleaved) {
            quantum = -quantum;
        }
        new IndexBuilder(this.basename, this.getSequence()).skipBufferSize(1024).pasteBufferSize(1024).interleaved(interleaved).skips(quantum != 0).quantum(quantum).height(height).virtualDocumentResolver(3, this.RESOLVER).run();
        Modulo3DocumentalClusteringStrategy modulo3 = new Modulo3DocumentalClusteringStrategy(100);
        BinIO.storeObject((Object)modulo3, (CharSequence)(this.basename + "-strategy"));
        new PartitionDocumentally(this.basename + "-text", this.basename + "-text-part", modulo3, this.basename + "-strategy", 0, 1024, CompressionFlags.DEFAULT_STANDARD_INDEX, interleaved, quantum != 0, quantum, height, 0x100000, 10000L).run();
        new PartitionDocumentally(this.basename + "-int", this.basename + "-int-part", modulo3, this.basename + "-strategy", 0, 1024, CompressionFlags.DEFAULT_PAYLOAD_INDEX, interleaved, quantum != 0, quantum, height, 0x100000, 10000L).run();
        new PartitionDocumentally(this.basename + "-date", this.basename + "-date-part", modulo3, this.basename + "-strategy", 0, 1024, CompressionFlags.DEFAULT_PAYLOAD_INDEX, interleaved, quantum != 0, quantum, height, 0x100000, 10000L).run();
        new PartitionDocumentally(this.basename + "-virtual", this.basename + "-virtual-part", modulo3, this.basename + "-strategy", 0, 1024, CompressionFlags.DEFAULT_STANDARD_INDEX, interleaved, quantum != 0, quantum, height, 0x100000, 10000L).run();
        for (String index : localIndex = new Properties(this.basename + "-text-part" + ".properties").getStringArray((Enum)IndexCluster.PropertyKeys.LOCALINDEX)) {
            BinIO.storeObject(IndexTest.createMap(index + ".terms"), (CharSequence)(index + ".termmap"));
        }
        this.sameContent(this.basename + "-text", this.basename + "-text-part", new FileLinesCollection((CharSequence)(this.basename + "-text" + ".terms"), "UTF-8").iterator());
        this.sameContent(this.basename + "-int", this.basename + "-int-part");
        this.sameContent(this.basename + "-date", this.basename + "-date-part");
        for (String index : localIndex = new Properties(this.basename + "-virtual-part" + ".properties").getStringArray((Enum)IndexCluster.PropertyKeys.LOCALINDEX)) {
            BinIO.storeObject(IndexTest.createMap(index + ".terms"), (CharSequence)(index + ".termmap"));
        }
        this.sameContent(this.basename + "-virtual", this.basename + "-virtual-part", new FileLinesCollection((CharSequence)(this.basename + "-virtual" + ".terms"), "UTF-8").iterator());
        localIndex = new Properties(this.basename + "-text-part" + ".properties").getStringArray((Enum)IndexCluster.PropertyKeys.LOCALINDEX);
        new Merge(this.basename + "-text-merged", localIndex, false, 1024, CompressionFlags.DEFAULT_STANDARD_INDEX, interleaved, quantum != 0, quantum, height, 0x100000, 10000L).run();
        this.sameIndex(this.basename + "-text", this.basename + "-text-merged", "batches");
        localIndex = new Properties(this.basename + "-int-part" + ".properties").getStringArray((Enum)IndexCluster.PropertyKeys.LOCALINDEX);
        new Merge(this.basename + "-int-merged", localIndex, false, 1024, CompressionFlags.DEFAULT_PAYLOAD_INDEX, interleaved, quantum != 0, quantum, height, 0x100000, 10000L).run();
        this.sameIndex(this.basename + "-int", this.basename + "-int-merged", "batches");
        localIndex = new Properties(this.basename + "-date-part" + ".properties").getStringArray((Enum)IndexCluster.PropertyKeys.LOCALINDEX);
        new Merge(this.basename + "-date-merged", localIndex, false, 1024, CompressionFlags.DEFAULT_PAYLOAD_INDEX, interleaved, quantum != 0, quantum, height, 0x100000, 10000L).run();
        this.sameIndex(this.basename + "-date", this.basename + "-date-merged", "batches");
        localIndex = new Properties(this.basename + "-virtual-part" + ".properties").getStringArray((Enum)IndexCluster.PropertyKeys.LOCALINDEX);
        new Merge(this.basename + "-virtual-merged", localIndex, false, 1024, CompressionFlags.DEFAULT_STANDARD_INDEX, interleaved, quantum != 0, quantum, height, 0x100000, 10000L).run();
        this.sameIndex(this.basename + "-virtual", this.basename + "-virtual-merged", "batches");
    }

    public void testPartitionMerge() throws Exception {
        this.testPartitionMerge(0, 0);
        this.testPartitionMerge(1, 1);
        this.testPartitionMerge(1, 2);
        this.testPartitionMerge(4, 1);
        this.testPartitionMerge(4, 4);
        this.testPartitionMerge(8, 1);
        this.testPartitionMerge(8, 4);
        this.testPartitionMerge(-1, 1);
        this.testPartitionMerge(-1, 2);
        this.testPartitionMerge(-4, 1);
        this.testPartitionMerge(-4, 4);
        this.testPartitionMerge(-8, 1);
        this.testPartitionMerge(-8, 4);
    }

    public void testLexicalPartitioning(boolean interleaved) throws ConfigurationException, SecurityException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, Exception {
        String[] localIndex;
        new IndexBuilder(this.basename, this.getSequence()).interleaved(interleaved).skipBufferSize(1024).pasteBufferSize(1024).virtualDocumentResolver(3, this.RESOLVER).run();
        ContiguousLexicalStrategy uniform = LexicalStrategies.uniform(3, DiskBasedIndex.getInstance(this.basename + "-text"));
        BinIO.storeObject((Object)uniform, (CharSequence)(this.basename + "-strategy"));
        new PartitionLexically(this.basename + "-text", this.basename + "-text-part", uniform, this.basename + "-strategy", 1024, 10000L).run();
        new PartitionLexically(this.basename + "-virtual", this.basename + "-virtual-part", uniform, this.basename + "-strategy", 1024, 10000L).run();
        for (String index : localIndex = new Properties(this.basename + "-text-part" + ".properties").getStringArray((Enum)IndexCluster.PropertyKeys.LOCALINDEX)) {
            BinIO.storeObject(IndexTest.createMap(index + ".terms"), (CharSequence)(index + ".termmap"));
        }
        this.sameContent(this.basename + "-text", this.basename + "-text-part", new FileLinesCollection((CharSequence)(this.basename + "-text" + ".terms"), "UTF-8").iterator());
        this.sameContent(this.basename + "-virtual", this.basename + "-virtual-part");
    }

    public void testLexicalPartitioning() throws ConfigurationException, SecurityException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, Exception {
        this.testLexicalPartitioning(true);
        this.testLexicalPartitioning(false);
    }

    public void testEmpty(int quantum, int height) throws ConfigurationException, SecurityException, IOException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        boolean interleaved;
        boolean bl = interleaved = quantum >= 0;
        if (!interleaved) {
            quantum = -quantum;
        }
        new IndexBuilder(this.basename, this.getEmptySequence()).skipBufferSize(1024).pasteBufferSize(1024).interleaved(interleaved).skips(quantum != 0).quantum(quantum).height(height).virtualDocumentResolver(3, this.RESOLVER).documentsPerBatch(20).run();
        this.checkAgainstContent(this.getEmptySequence(), null, this.RESOLVER, 64, Index.getInstance(this.basename + "-text"), Index.getInstance(this.basename + "-int"), Index.getInstance(this.basename + "-date"), Index.getInstance(this.basename + "-virtual"));
        String mapFile = File.createTempFile(((Object)((Object)this)).getClass().getSimpleName(), "permutation").toString();
        new IndexBuilder(this.basename + "-mapped", this.getEmptySequence()).skipBufferSize(1024).pasteBufferSize(1024).interleaved(interleaved).skips(quantum != 0).quantum(quantum).height(height).virtualDocumentResolver(3, this.RESOLVER).mapFile(mapFile).documentsPerBatch(20).run();
        this.sameIndex(this.basename + "-text", this.basename + "-mapped-text", new String[0]);
        this.sameIndex(this.basename + "-int", this.basename + "-mapped-int", new String[0]);
        this.sameIndex(this.basename + "-date", this.basename + "-mapped-date", new String[0]);
        this.sameIndex(this.basename + "-virtual", this.basename + "-mapped-virtual", new String[0]);
    }

    public void testEmpty() throws Exception {
        this.testEmpty(0, 0);
        this.testEmpty(1, 1);
        this.testEmpty(1, 2);
        this.testEmpty(4, 1);
        this.testEmpty(4, 4);
        this.testEmpty(8, 1);
        this.testEmpty(8, 4);
        this.testEmpty(-1, 1);
        this.testEmpty(-1, 2);
        this.testEmpty(-8, 1);
        this.testEmpty(-8, 4);
        this.testEmpty(-8, 1);
        this.testEmpty(-8, 4);
    }

    public void testLoadOptions(int quantum, int height) throws ConfigurationException, SecurityException, IOException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        boolean interleaved;
        boolean bl = interleaved = quantum >= 0;
        if (!interleaved) {
            quantum = -quantum;
        }
        new IndexBuilder(this.basename, this.getSequence()).skipBufferSize(1024).pasteBufferSize(1024).interleaved(interleaved).skips(quantum != 0).quantum(quantum).height(height).virtualDocumentResolver(3, this.RESOLVER).documentsPerBatch(20).run();
        for (String options : new String[]{"inmemory=1", "mapped=1", "offsetstep=0", "offsetstep=-2"}) {
            this.checkAgainstContent(this.getSequence(), null, this.RESOLVER, 64, Index.getInstance(this.basename + "-text?" + options), Index.getInstance(this.basename + "-int?" + options), Index.getInstance(this.basename + "-date?" + options), Index.getInstance(this.basename + "-virtual?" + options));
        }
    }

    public void testLoadOptions() throws Exception {
        this.testLoadOptions(0, 0);
        this.testLoadOptions(1, 1);
        this.testLoadOptions(-1, 1);
    }

    static {
        Util.ensureLog4JIsConfigured((Level)Level.INFO);
        KILL_A_PROCESSOR = KillATermProcessor.getInstance();
        INDEXED_FIELD = new int[]{0, 1, 2};
    }

    public static final class KillATermProcessor
    implements TermProcessor {
        private static final long serialVersionUID = 1L;
        private static final KillATermProcessor INSTANCE = new KillATermProcessor();

        public TermProcessor copy() {
            return this;
        }

        public static TermProcessor getInstance() {
            return INSTANCE;
        }

        public boolean processPrefix(MutableString prefix) {
            return true;
        }

        public boolean processTerm(MutableString term) {
            return term.indexOf('a') == -1;
        }
    }
}

