/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.NullTermProcessor;
import it.unimi.dsi.mg4j.index.TooManyTermsException;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import it.unimi.dsi.util.Interval;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArrayIndexIterator
extends AbstractIntIterator
implements IndexIterator {
    private static final Index index = new TestIndex();
    private final int[] document;
    private final int[][] position;
    private int curr = -1;
    private IntervalIterator currentIterator;
    private String term;
    private int id;
    private final int termNumber;

    public IntArrayIndexIterator(int[] document, int[][] position) {
        this(0, document, position);
    }

    public IntArrayIndexIterator(int termNumber, int[] document, int[][] position) {
        int i;
        this.termNumber = termNumber;
        this.document = document;
        this.position = position;
        if (document.length != position.length) {
            throw new IllegalArgumentException();
        }
        for (i = 0; i < document.length - 1; ++i) {
            if (document[i] < document[i + 1]) continue;
            throw new IllegalArgumentException("Document array is not increasing");
        }
        for (i = 0; i < document.length; ++i) {
            int j = position[i].length - 1;
            while (j-- != 0) {
                if (position[i][j] < position[i][j + 1]) continue;
                throw new IllegalArgumentException("Non-increasing position list for document " + i + ": " + Arrays.toString(position[i]));
            }
        }
    }

    @Override
    public int termNumber() {
        return this.termNumber;
    }

    public boolean hasNext() {
        return this.curr < this.document.length - 1;
    }

    @Override
    public int nextInt() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.curr;
        this.currentIterator = null;
        return this.document[this.curr];
    }

    @Override
    public int nextDocument() {
        if (!this.hasNext()) {
            return -1;
        }
        return this.nextInt();
    }

    @Override
    public int skipTo(int n) {
        if (this.curr != -1 && this.document[this.curr] >= n) {
            return this.document[this.curr];
        }
        while (this.hasNext()) {
            int result = this.nextInt();
            if (result < n) continue;
            return result;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean accept(DocumentIteratorVisitor visitor) throws IOException {
        return visitor.visit(this);
    }

    @Override
    public boolean acceptOnTruePaths(DocumentIteratorVisitor visitor) throws IOException {
        return visitor.visit(this);
    }

    @Override
    public void dispose() {
    }

    @Override
    public int document() {
        if (this.curr == -1) {
            throw new IllegalStateException();
        }
        return this.document[this.curr];
    }

    @Override
    public ReferenceSet<Index> indices() {
        return ReferenceSets.singleton((Object)index);
    }

    @Override
    public IntervalIterator intervalIterator() {
        if (this.curr == -1) {
            throw new IllegalStateException();
        }
        if (this.currentIterator != null) {
            return this.currentIterator;
        }
        if (this.position[this.curr].length == 0) {
            return IntervalIterators.FALSE;
        }
        this.currentIterator = new ArraySingletonIntervalIterator(this.position[this.curr]);
        return this.currentIterator;
    }

    @Override
    public IntervalIterator intervalIterator(Index index) {
        return this.intervalIterator();
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntervalIterator iterator() {
        return this.intervalIterator();
    }

    public void reset() {
        this.curr = -1;
    }

    public String toString() {
        MutableString result = new MutableString();
        result.append('[');
        for (int i = 0; i < this.document.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append('<').append(this.document[i]).append(':').append(Arrays.toString(this.position[i])).append('>');
        }
        return result.append(']').toString();
    }

    @Override
    public int count() {
        return this.position[this.curr].length;
    }

    @Override
    public int frequency() {
        return this.document.length;
    }

    @Override
    public void id(int id) {
        this.id = id;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public Index index() {
        return index;
    }

    @Override
    public Payload payload() {
        return null;
    }

    @Override
    public int[] positionArray() {
        return this.position[this.curr];
    }

    @Override
    public IntIterator positions() {
        return IntIterators.wrap((int[])this.position[this.curr]);
    }

    @Override
    public int positions(int[] position) {
        if (this.position[this.curr].length > position.length) {
            return -this.position[this.curr].length - 1;
        }
        System.arraycopy(this.position[this.curr], 0, position, 0, this.position[this.curr].length);
        return this.position[this.curr].length;
    }

    @Override
    public String term() {
        return this.term;
    }

    @Override
    public void term(CharSequence term) {
        this.term = ((Object)term).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArraySingletonIntervalIterator
    extends AbstractObjectIterator<Interval>
    implements IntervalIterator {
        private int curr = -1;
        private final int[] position;

        public ArraySingletonIntervalIterator(int[] position) {
            this.position = position;
        }

        @Override
        public int extent() {
            return 1;
        }

        @Override
        public void reset() {
            this.curr = -1;
        }

        @Override
        public void intervalTerms(IntSet terms) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.position.length - 1;
        }

        @Override
        public Interval next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.curr;
            return Interval.valueOf((int)this.position[this.curr]);
        }

        @Override
        public Interval nextInterval() {
            if (!this.hasNext()) {
                return null;
            }
            return this.next();
        }

        public String toString() {
            return Arrays.toString(this.position);
        }
    }

    private static class TestIndex
    extends Index {
        private static final long serialVersionUID = 1L;

        public TestIndex() {
            super(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, null, true, true, NullTermProcessor.getInstance(), "text", null, null);
        }

        public IndexIterator documents(CharSequence prefix, int limit) throws IOException, TooManyTermsException {
            throw new UnsupportedOperationException();
        }

        public IndexReader getReader() throws IOException {
            throw new UnsupportedOperationException();
        }

        public IndexReader getReader(int bufferSize) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

