/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.io.WordReader;
import it.unimi.dsi.mg4j.document.AbstractDocumentCollection;
import it.unimi.dsi.mg4j.document.AbstractDocumentFactory;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateArrayDocumentCollection
extends AbstractDocumentCollection {
    public final Date[] date;
    final DocumentFactory factory = new DateArrayDocumentFactory();

    public DateArrayDocumentCollection(Date ... date) {
        this.date = date;
    }

    @Override
    public int size() {
        return this.date.length;
    }

    @Override
    public Document document(final int index) {
        return new Document(){

            public void close() {
            }

            public Object content(int field) throws IOException {
                DateArrayDocumentCollection.this.ensureDocumentIndex(index);
                return DateArrayDocumentCollection.this.date[index];
            }

            public CharSequence title() {
                return null;
            }

            public CharSequence uri() {
                return null;
            }

            public WordReader wordReader(int field) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public InputStream stream(int index) throws IOException {
        return new FastByteArrayInputStream(this.date[index].toString().getBytes("ASCII"));
    }

    @Override
    public Reference2ObjectMap<Enum<?>, Object> metadata(int index) throws IOException {
        return Reference2ObjectMaps.EMPTY_MAP;
    }

    @Override
    public DocumentCollection copy() {
        return this;
    }

    @Override
    public DocumentFactory factory() {
        return this.factory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DateArrayDocumentFactory
    extends AbstractDocumentFactory {
        private static final long serialVersionUID = 1L;

        @Override
        public DocumentFactory copy() {
            return this;
        }

        @Override
        public int fieldIndex(String fieldName) {
            if ("date".equals(fieldName)) {
                return 0;
            }
            return -1;
        }

        @Override
        public String fieldName(int field) {
            this.ensureFieldIndex(field);
            return "date";
        }

        @Override
        public DocumentFactory.FieldType fieldType(int field) {
            this.ensureFieldIndex(field);
            return DocumentFactory.FieldType.DATE;
        }

        @Override
        public Document getDocument(InputStream rawContent, Reference2ObjectMap<Enum<?>, Object> metadata) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int numberOfFields() {
            return 1;
        }
    }
}

