/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util.parser.callback;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.mg4j.tool.Scan;
import it.unimi.dsi.parser.Attribute;
import it.unimi.dsi.parser.BulletParser;
import it.unimi.dsi.parser.Element;
import it.unimi.dsi.parser.callback.DefaultCallback;
import it.unimi.dsi.util.CircularCharArrayBuffer;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnchorExtractor
extends DefaultCallback {
    public static final Logger LOGGER = Logger.getLogger(AnchorExtractor.class);
    public static final boolean DEBUG = false;
    public final ObjectList<Anchor> anchors = new ObjectArrayList();
    private final CircularCharArrayBuffer preAnchor;
    private final MutableString anchor;
    private final int maxAnchor;
    private final int maxAfter;
    private final MutableString postAnchor;
    private MutableString url;
    private MutableString result;
    private char[] preAnchorArray;
    private State state;

    public AnchorExtractor(int maxBefore, int maxAnchor, int maxAfter) {
        this.preAnchor = new CircularCharArrayBuffer(maxBefore);
        this.anchor = new MutableString(maxAnchor);
        this.postAnchor = new MutableString(maxAfter);
        this.result = new MutableString(maxBefore + maxAnchor + maxAfter);
        this.maxAfter = maxAfter;
        this.maxAnchor = maxAnchor;
        this.state = State.BEFORE_ANCHOR;
    }

    public void configure(BulletParser parser) {
        parser.parseTags(true);
        parser.parseAttributes(true);
        parser.parseText(true);
        parser.parseAttribute(Attribute.HREF);
    }

    public void startDocument() {
        this.state = State.BEFORE_ANCHOR;
        this.anchors.clear();
        this.preAnchor.clear();
        this.anchor.setLength(0);
        this.postAnchor.setLength(0);
        this.url = null;
    }

    public void endDocument() {
        if (this.url != null) {
            this.emit();
        }
        this.url = null;
    }

    public boolean startElement(Element element, Map<Attribute, MutableString> attrMap) {
        if (element == Element.A && attrMap != null && attrMap.containsKey(Attribute.HREF)) {
            if (this.state == State.AFTER_ANCHOR) {
                this.emit();
                this.state = State.BEFORE_ANCHOR;
            }
            if (this.state == State.BEFORE_ANCHOR) {
                this.preAnchorArray = this.preAnchor.toCharArray();
                this.preAnchor.clear();
                this.state = State.IN_ANCHOR;
                this.url = attrMap.get(Attribute.HREF);
                this.anchor.setLength(0);
                this.postAnchor.setLength(0);
            }
        }
        return true;
    }

    public boolean endElement(Element element) {
        if (element == Element.A && this.state == State.IN_ANCHOR) {
            this.state = State.AFTER_ANCHOR;
        }
        return true;
    }

    public boolean characters(char[] characters, int offset, int length, boolean flowBroken) {
        switch (this.state) {
            case BEFORE_ANCHOR: {
                this.preAnchor.add(characters, offset, length);
                break;
            }
            case IN_ANCHOR: {
                this.anchor.append(characters, offset, Math.min(length, this.maxAnchor - this.anchor.length()));
                break;
            }
            case AFTER_ANCHOR: {
                this.preAnchor.add(characters, offset, length);
                this.postAnchor.append(characters, offset, Math.min(length, this.maxAfter - this.postAnchor.length()));
            }
        }
        if (this.state == State.AFTER_ANCHOR && this.postAnchor.length() == this.maxAfter && this.url != null) {
            this.emit();
            this.state = State.BEFORE_ANCHOR;
        }
        return true;
    }

    private void emit() {
        int posAnchor;
        int posPre;
        if (this.preAnchorArray.length > 0 && Character.isLetterOrDigit(this.preAnchorArray[posPre])) {
            for (posPre = 0; posPre < this.preAnchorArray.length && Character.isLetterOrDigit(this.preAnchorArray[posPre]); ++posPre) {
            }
        }
        char[] postAnchorArray = this.postAnchor.array();
        int posPost = this.postAnchor.length() - 1;
        if (posPost >= 0 && Character.isLetterOrDigit(postAnchorArray[posPost])) {
            while (posPost >= 0 && Character.isLetterOrDigit(postAnchorArray[posPost])) {
                --posPost;
            }
        }
        char[] anchorArray = this.anchor.array();
        if (this.anchor.length() == this.maxAnchor && posAnchor >= 0 && Character.isLetterOrDigit(anchorArray[posAnchor])) {
            for (posAnchor = this.anchor.length() - 1; posAnchor >= 0 && Character.isLetterOrDigit(anchorArray[posAnchor]); --posAnchor) {
            }
        }
        this.result.setLength(0);
        this.result.append(this.preAnchorArray, posPre, this.preAnchorArray.length - posPre).append(anchorArray, 0, posAnchor + 1).append(postAnchorArray, 0, posPost + 1);
        this.anchors.add((Object)new Anchor(this.url, this.result.copy()));
        this.url = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        BEFORE_ANCHOR,
        IN_ANCHOR,
        AFTER_ANCHOR;

    }

    public static final class Anchor
    implements Scan.VirtualDocumentFragment {
        private static final long serialVersionUID = 1L;
        private final MutableString href;
        private final MutableString anchorText;

        public Anchor(MutableString href, MutableString anchorText) {
            this.href = href;
            this.anchorText = anchorText;
        }

        public MutableString documentSpecifier() {
            return this.href;
        }

        public MutableString text() {
            return this.anchorText;
        }

        public String toString() {
            return "<" + this.href + ", \"" + this.anchorText + "\">";
        }
    }
}

