/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import cern.colt.GenericPermuting;
import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import cern.jet.random.engine.MersenneTwister;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.mg4j.index.AbstractTermMap;
import it.unimi.dsi.mg4j.index.TermMap;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.io.FileLinesCollection;
import it.unimi.dsi.mg4j.io.LineIterator;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MG4JClassParser;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class MinimalPerfectHash
extends AbstractTermMap
implements Serializable {
    private static final Logger LOGGER = Util.getLogger(MinimalPerfectHash.class);
    public static final float ENLARGEMENT_FACTOR = 1.26f;
    public static final int NODE_OVERHEAD = 16;
    public static final int TERM_THRESHOLD = 16;
    public static final int WEIGHT_UNKNOWN = -1;
    public static final int WEIGHT_UNKNOWN_SORTED_TERMS = -2;
    protected final int n;
    protected final int m;
    protected final int rightShift;
    protected final int[] init;
    protected final int[] weight0;
    protected final int[] weight1;
    protected final int[] weight2;
    protected final int weightLength;
    protected final int[] g;
    protected transient long n4;
    protected transient CharSequence[] t;
    public static final long serialVersionUID = 2L;

    protected void hash(CharSequence term, int[] h) {
        int h0 = this.init[0];
        int h1 = this.init[1];
        int h2 = this.init[2];
        int i = term.length();
        if (this.weightLength < i) {
            i = this.weightLength;
        }
        while (i-- != 0) {
            char c = term.charAt(i);
            h0 ^= this.weight0[i] * c;
            h1 ^= this.weight1[i] * c;
            h2 ^= this.weight2[i] * c;
        }
        h0 = (h0 >>> this.rightShift) % this.m;
        h1 = (h1 >>> this.rightShift) % this.m;
        h2 = (h2 >>> this.rightShift) % this.m;
        if (h0 == h1 || h1 == h2) {
            h1 = this.m + h1 % 8;
        }
        if (h0 == h2) {
            h2 = this.m + 8 + h2 % 8;
        }
        h[0] = h0;
        h[1] = h1;
        h[2] = h2;
    }

    @Override
    public int getNumber(CharSequence term) {
        if (this.t != null) {
            return this.getFromT(term);
        }
        int h0 = this.init[0];
        int h1 = this.init[1];
        int h2 = this.init[2];
        int i = term.length();
        if (this.weightLength < i) {
            i = this.weightLength;
        }
        while (i-- != 0) {
            char c = term.charAt(i);
            h0 ^= this.weight0[i] * c;
            h1 ^= this.weight1[i] * c;
            h2 ^= this.weight2[i] * c;
        }
        h0 = (h0 >>> this.rightShift) % this.m;
        h1 = (h1 >>> this.rightShift) % this.m;
        h2 = (h2 >>> this.rightShift) % this.m;
        if (h0 == h1 || h1 == h2) {
            h1 = this.m + h1 % 8;
        }
        if (h0 == h2) {
            h2 = this.m + 8 + h2 % 8;
        }
        return (int)(((long)this.g[h0] + (long)this.g[h1] + (long)this.g[h2] + this.n4) % (long)this.n);
    }

    public int getNumber(MutableString term) {
        if (this.t != null) {
            return this.getFromT(term);
        }
        int h0 = this.init[0];
        int h1 = this.init[1];
        int h2 = this.init[2];
        int i = term.length();
        char[] a = term.array;
        if (this.weightLength < i) {
            i = this.weightLength;
        }
        while (i-- != 0) {
            char c = a[i];
            h0 ^= this.weight0[i] * c;
            h1 ^= this.weight1[i] * c;
            h2 ^= this.weight2[i] * c;
        }
        h0 = (h0 >>> this.rightShift) % this.m;
        h1 = (h1 >>> this.rightShift) % this.m;
        h2 = (h2 >>> this.rightShift) % this.m;
        if (h0 == h1 || h1 == h2) {
            h1 = this.m + h1 % 8;
        }
        if (h0 == h2) {
            h2 = this.m + 8 + h2 % 8;
        }
        return (int)(((long)this.g[h0] + (long)this.g[h1] + (long)this.g[h2] + this.n4) % (long)this.n);
    }

    public int getNumber(byte[] a, int off, int len) {
        if (this.t != null) {
            try {
                return this.getFromT(new String(a, off, len, "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException cantHappen) {
                throw new RuntimeException(cantHappen);
            }
        }
        int h0 = this.init[0];
        int h1 = this.init[1];
        int h2 = this.init[2];
        int i = len;
        if (this.weightLength < i) {
            i = this.weightLength;
        }
        while (i-- != 0) {
            int c = a[off + i] & 0xFF;
            h0 ^= this.weight0[i] * c;
            h1 ^= this.weight1[i] * c;
            h2 ^= this.weight2[i] * c;
        }
        h0 = (h0 >>> this.rightShift) % this.m;
        h1 = (h1 >>> this.rightShift) % this.m;
        h2 = (h2 >>> this.rightShift) % this.m;
        if (h0 == h1 || h1 == h2) {
            h1 = this.m + h1 % 8;
        }
        if (h0 == h2) {
            h2 = this.m + 8 + h2 % 8;
        }
        return (int)(((long)this.g[h0] + (long)this.g[h1] + (long)this.g[h2] + this.n4) % (long)this.n);
    }

    public int getNumber(byte[] a) {
        return this.getNumber(a, 0, a.length);
    }

    protected int getFromT(CharSequence term) {
        int i = this.n;
        while (i-- != 0) {
            if (!this.t[i].equals(term)) continue;
            return i;
        }
        return 0;
    }

    public int weightLength() {
        return this.weightLength;
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public boolean hasTerms() {
        return false;
    }

    public MinimalPerfectHash(Iterable<? extends CharSequence> terms) {
        this(terms, -1);
    }

    public MinimalPerfectHash(Iterable<? extends CharSequence> terms, int weightLength) {
        if (weightLength != -1 && weightLength != -2 && weightLength <= 0) {
            throw new IllegalArgumentException("Non-positive weight length: " + weightLength);
        }
        if (terms instanceof Collection) {
            this.n = ((Collection)terms).size();
        } else {
            int c = 0;
            for (CharSequence charSequence : terms) {
                ++c;
            }
            this.n = c;
        }
        this.n4 = this.n * 4;
        this.m = (int)Math.ceil((float)this.n * 1.26f);
        this.rightShift = (32 - Fast.mostSignificantBit(this.m)) / 2;
        this.g = new int[this.m + 16];
        if (weightLength < 0) {
            int n;
            LOGGER.info((Object)"Computing weight length...");
            Iterator<? extends CharSequence> i = terms.iterator();
            int maxLength = Integer.MIN_VALUE;
            int n2 = Integer.MIN_VALUE;
            if (i.hasNext()) {
                int prevLength;
                MutableString prevTerm = new MutableString(i.next());
                maxLength = prevLength = prevTerm.length();
                while (i.hasNext()) {
                    CharSequence currTerm = i.next();
                    int currLength = currTerm.length();
                    if (weightLength == -2) {
                        int k;
                        for (k = 0; k < prevLength && k < currLength && currTerm.charAt(k) == prevTerm.charAt(k); ++k) {
                        }
                        if (k == currLength && k == prevLength) {
                            throw new IllegalArgumentException("The term list contains a duplicate (" + currTerm + ")");
                        }
                        n = Math.max(n, k + 1);
                        prevTerm.replace(currTerm);
                        prevLength = currLength;
                    }
                    maxLength = Math.max(maxLength, currLength);
                }
            }
            weightLength = weightLength == -2 ? n : maxLength;
            LOGGER.info((Object)("Completed [max term length=" + maxLength + "; weight length=" + weightLength + "]."));
        }
        if (weightLength < 0) {
            weightLength = 0;
        }
        this.weight0 = new int[weightLength];
        this.weight1 = new int[weightLength];
        this.weight2 = new int[weightLength];
        this.init = new int[3];
        this.weightLength = weightLength;
        if (this.n < 16) {
            int j = 0;
            this.t = new MutableString[this.n];
            Iterator<? extends CharSequence> i = terms.iterator();
            while (i.hasNext()) {
                this.t[j++] = new MutableString(i.next());
            }
        } else {
            this.t = null;
            new Visit(terms);
        }
    }

    public MinimalPerfectHash(String termFile, String encoding, int weightLength, boolean zipped) {
        this(new FileLinesCollection(termFile, encoding, zipped), weightLength);
    }

    public MinimalPerfectHash(String termFile, String encoding, boolean zipped) {
        this(termFile, encoding, -1, zipped);
    }

    public MinimalPerfectHash(String termFile, String encoding, int weightLength) {
        this(new FileLinesCollection(termFile, encoding), weightLength);
    }

    public MinimalPerfectHash(String termFile, String encoding) {
        this(termFile, encoding, -1, false);
    }

    protected MinimalPerfectHash(MinimalPerfectHash mph) {
        this.n = mph.n;
        this.m = mph.m;
        this.weightLength = mph.weightLength;
        this.weight0 = mph.weight0;
        this.weight1 = mph.weight1;
        this.weight2 = mph.weight2;
        this.init = mph.init;
        this.g = mph.g;
        this.rightShift = mph.rightShift;
        this.n4 = mph.n4;
        this.t = mph.t;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.n < 16) {
            s.writeObject(this.t);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n4 = this.n * 4;
        if (this.n < 16) {
            this.t = (CharSequence[])s.readObject();
        }
    }

    protected static void main(Class<? extends MinimalPerfectHash> klass, String[] arg) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException, JSAPException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(klass.getName(), "Builds a minimal perfect hash table reading a newline-separated list of terms.", new Parameter[]{new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, "64Ki", false, 'b', "buffer-size", "The size of the I/O buffer used to read terms."), new FlaggedOption("class", (StringParser)MG4JClassParser.getParser(), klass.getName(), false, 'c', "class", "A subclass of MinimalPerfectHash to be used when creating the table."), new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The term file encoding."), new Switch("zipped", 'z', "zipped", "The term list is compressed in gzip format."), new Switch("sorted", 's', "sorted", "The term list is sorted--optimise weight length."), new Switch("check", 'C', "check", "Check an existing map rather than build a new one."), new FlaggedOption("termFile", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'o', "offline", "Read terms from this file (without loading them into core memory) instead of standard input."), new UnflaggedOption("table", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised minimal perfect hash table.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int bufferSize = jsapResult.getInt("bufferSize");
        String tableName = jsapResult.getString("table");
        String termFile = jsapResult.getString("termFile");
        Class tableClass = jsapResult.getClass("class");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        boolean sorted = jsapResult.getBoolean("sorted");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean check = jsapResult.getBoolean("check");
        if (check) {
            TermMap mph = (TermMap)BinIO.loadObject((CharSequence)tableName);
            ProgressLogger pl = new ProgressLogger(LOGGER);
            pl.itemsName = "terms";
            LineIterator termIterator = new LineIterator(new FastBufferedReader(new InputStreamReader(termFile != null ? new FileInputStream(termFile) : System.in, encoding), bufferSize), pl);
            int size = mph.size();
            pl.start((CharSequence)"Reading terms...");
            for (int i = 0; i < size; ++i) {
                if (mph.getNumber(termIterator.next()) == i) continue;
                System.out.println(i);
            }
            pl.done();
            if (termIterator.hasNext()) {
                System.out.println("More terms than elements in the map");
            }
        } else {
            MinimalPerfectHash minimalPerfectHash;
            if (termFile == null) {
                ArrayList<MutableString> termList = new ArrayList<MutableString>();
                ProgressLogger pl = new ProgressLogger(LOGGER);
                pl.itemsName = "terms";
                LineIterator termIterator = new LineIterator(new FastBufferedReader(new InputStreamReader(System.in, encoding), bufferSize), pl);
                pl.start((CharSequence)"Reading terms...");
                while (termIterator.hasNext()) {
                    termList.add(termIterator.next().copy());
                }
                pl.done();
                LOGGER.info((Object)"Building minimal perfect hash table...");
                minimalPerfectHash = (MinimalPerfectHash)tableClass.getConstructor(Iterable.class, Integer.TYPE).newInstance(termList, sorted ? -2 : -1);
            } else {
                LOGGER.info((Object)"Building minimal perfect hash table...");
                minimalPerfectHash = (MinimalPerfectHash)tableClass.getConstructor(String.class, String.class, Integer.TYPE, Boolean.TYPE).newInstance(termFile, encoding.toString(), sorted ? -2 : -1, zipped);
            }
            LOGGER.info((Object)"Writing to file...");
            BinIO.storeObject((Object)minimalPerfectHash, (CharSequence)tableName);
            LOGGER.info((Object)"Completed.");
        }
    }

    public static void main(String[] arg) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException, JSAPException, ClassNotFoundException {
        MinimalPerfectHash.main(MinimalPerfectHash.class, arg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Visit {
        final int mPlusOverhead;
        final int[][] edge;
        final boolean[] removed;
        final int[] inc;
        final int[] last;
        final int[] incOffset;
        final int[] stack;
        final int[] d;
        int top;
        final int[] recStackI;
        final int[] recStackK;

        /*
         * WARNING - void declaration
         */
        public Visit(Iterable<? extends CharSequence> terms) {
            int j;
            this.mPlusOverhead = MinimalPerfectHash.this.m + 16;
            this.edge = new int[3][MinimalPerfectHash.this.n];
            this.removed = new boolean[MinimalPerfectHash.this.n];
            this.inc = new int[this.mPlusOverhead * 3];
            this.last = new int[this.mPlusOverhead];
            this.incOffset = new int[this.mPlusOverhead];
            this.stack = new int[MinimalPerfectHash.this.n];
            this.d = new int[this.mPlusOverhead];
            this.recStackI = new int[MinimalPerfectHash.this.n];
            this.recStackK = new int[MinimalPerfectHash.this.n];
            final int[][] edge = this.edge;
            final int[] last = this.last;
            int[] inc = this.inc;
            int[] incOffset = this.incOffset;
            int[] stack = this.stack;
            int[] d = this.d;
            MersenneTwister r = new MersenneTwister(new Date());
            int v = -1;
            int[] h = new int[3];
            do {
                int i;
                LOGGER.info((Object)"Generating random hypergraph...");
                this.top = 0;
                MinimalPerfectHash.this.init[0] = r.nextInt();
                MinimalPerfectHash.this.init[1] = r.nextInt();
                MinimalPerfectHash.this.init[2] = r.nextInt();
                for (i = 0; i < MinimalPerfectHash.this.weightLength; ++i) {
                    MinimalPerfectHash.this.weight0[i] = r.nextInt();
                    MinimalPerfectHash.this.weight1[i] = r.nextInt();
                    MinimalPerfectHash.this.weight2[i] = r.nextInt();
                }
                i = 0;
                Object var16_15 = null;
                IntArrays.fill((int[])d, (int)0);
                for (CharSequence charSequence : terms) {
                    MinimalPerfectHash.this.hash(charSequence, h);
                    if (h[0] == h[1] || h[1] == h[2] || h[2] == h[0]) break;
                    edge[0][i] = h[0];
                    edge[1][i] = h[1];
                    edge[2][i] = h[2];
                    ++i;
                }
                if (i < MinimalPerfectHash.this.n) {
                    void var16_14;
                    LOGGER.info((Object)("Hypergraph generation interrupted by degenerate hyperedge " + i + " (string: \"" + var16_14 + "\")."));
                    continue;
                }
                for (j = 0; j < 3; ++j) {
                    i = MinimalPerfectHash.this.n;
                    while (i-- != 0) {
                        int n = edge[j][i];
                        d[n] = d[n] + 1;
                    }
                }
                LOGGER.info((Object)"Checking for duplicate hyperedges...");
                i = MinimalPerfectHash.this.n;
                while (i-- != 0) {
                    last[i] = i;
                }
                GenericSorting.quickSort((int)0, (int)MinimalPerfectHash.this.n, (IntComparator)new IntComparator(){

                    public int compare(int x, int y) {
                        int r = edge[0][x] - edge[0][y];
                        if (r != 0) {
                            return r;
                        }
                        r = edge[1][x] - edge[1][y];
                        if (r != 0) {
                            return r;
                        }
                        return edge[2][x] - edge[2][y];
                    }
                }, (Swapper)new Swapper(){

                    public void swap(int x, int y) {
                        int e0 = edge[0][x];
                        int e1 = edge[1][x];
                        int e2 = edge[2][x];
                        int p = last[x];
                        edge[0][x] = edge[0][y];
                        edge[1][x] = edge[1][y];
                        edge[2][x] = edge[2][y];
                        edge[0][y] = e0;
                        edge[1][y] = e1;
                        edge[2][y] = e2;
                        last[x] = last[y];
                        last[y] = p;
                    }
                });
                i = MinimalPerfectHash.this.n - 1;
                while (i-- != 0 && (edge[0][i + 1] != edge[0][i] || edge[1][i + 1] != edge[1][i] || edge[2][i + 1] != edge[2][i])) {
                }
                if (i != -1) {
                    LOGGER.info((Object)("Found double hyperedge for terms " + last[i + 1] + " and " + last[i] + "."));
                    continue;
                }
                i = MinimalPerfectHash.this.n;
                while (i-- != 0) {
                    stack[last[i]] = i;
                }
                GenericPermuting.permute((int[])stack, (Swapper)new Swapper(){

                    public void swap(int x, int y) {
                        int e0 = edge[0][x];
                        int e1 = edge[1][x];
                        int e2 = edge[2][x];
                        edge[0][x] = edge[0][y];
                        edge[1][x] = edge[1][y];
                        edge[2][x] = edge[2][y];
                        edge[0][y] = e0;
                        edge[1][y] = e1;
                        edge[2][y] = e2;
                    }
                }, (int[])last, (int[])incOffset);
                LOGGER.info((Object)"Visiting hypergraph...");
                IntArrays.fill((int[])last, (int)0);
                incOffset[0] = 0;
                for (i = 1; i < this.mPlusOverhead; ++i) {
                    incOffset[i] = incOffset[i - 1] + d[i - 1];
                }
                for (i = 0; i < MinimalPerfectHash.this.n; ++i) {
                    for (j = 0; j < 3; ++j) {
                        int n = v = edge[j][i];
                        int n2 = last[n];
                        last[n] = n2 + 1;
                        inc[incOffset[v] + n2] = i;
                    }
                }
                BooleanArrays.fill((boolean[])this.removed, (boolean)false);
                for (i = 0; i < this.mPlusOverhead; ++i) {
                    if (d[i] != 1) continue;
                    this.visit(i);
                }
                if (this.top == MinimalPerfectHash.this.n) {
                    LOGGER.info((Object)"Visit completed.");
                    continue;
                }
                LOGGER.info((Object)("Visit failed: stripped " + this.top + " hyperedges out of " + MinimalPerfectHash.this.n + "."));
            } while (this.top != MinimalPerfectHash.this.n);
            LOGGER.info((Object)"Assigning values...");
            IntArrays.fill((int[])MinimalPerfectHash.this.g, (int)-1);
            while (this.top > 0) {
                int k = stack[--this.top];
                int s = 0;
                for (j = 0; j < 3; ++j) {
                    if (MinimalPerfectHash.this.g[edge[j][k]] == -1) {
                        MinimalPerfectHash.this.g[edge[j][k]] = 0;
                        v = edge[j][k];
                        continue;
                    }
                    s += MinimalPerfectHash.this.g[edge[j][k]];
                }
                MinimalPerfectHash.this.g[v] = ((k - s) % MinimalPerfectHash.this.n + MinimalPerfectHash.this.n) % MinimalPerfectHash.this.n;
            }
            LOGGER.info((Object)"Completed.");
        }

        private void visit(int x) {
            int[] recStackI = this.recStackI;
            int[] recStackK = this.recStackK;
            int[][] edge = this.edge;
            int[] last = this.last;
            int[] inc = this.inc;
            int[] incOffset = this.incOffset;
            int[] stack = this.stack;
            int[] d = this.d;
            boolean[] removed = this.removed;
            int k = -1;
            int recTop = 0;
            boolean inside = false;
            while (true) {
                int i;
                if (!inside) {
                    for (i = 0; i < last[x] && removed[k = inc[incOffset[x] + i]]; ++i) {
                    }
                    stack[this.top++] = k;
                    removed[k] = true;
                    for (i = 0; i < 3; ++i) {
                        int n = edge[i][k];
                        d[n] = d[n] - 1;
                    }
                }
                for (i = 0; i < 3; ++i) {
                    if (edge[i][k] == x || d[edge[i][k]] != 1) continue;
                    recStackI[recTop] = i + 1;
                    recStackK[recTop] = k;
                    ++recTop;
                    x = edge[i][k];
                    inside = false;
                    break;
                }
                if (i < 3) continue;
                if (--recTop < 0) {
                    return;
                }
                i = recStackI[recTop];
                k = recStackK[recTop];
                inside = true;
            }
        }
    }
}

