/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import cern.colt.bitvector.BitVector;
import cern.colt.bitvector.QuickBitVector;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.Intervals;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.Serializable;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ImmutableBinaryTrie
implements Serializable {
    private static final boolean ASSERTS = false;
    public static final long serialVersionUID = 1L;
    protected final Node root;
    private int size;

    public ImmutableBinaryTrie(List<BitVector> words) {
        int numWords = words.size();
        if (numWords > 1) {
            BitVector prev = words.get(0);
            ListIterator<BitVector> i = words.listIterator(1);
            while (--numWords != 0) {
                BitVector curr = i.next();
                int minLength = Math.min(prev.size(), curr.size());
                for (int j = 0; j < minLength; ++j) {
                    if (prev.get(j) && !curr.get(j)) {
                        throw new IllegalArgumentException("The provided bit vector list is not lexicographically increasing");
                    }
                    if (!prev.get(j) && curr.get(j)) break;
                }
                prev = curr;
            }
        }
        this.root = this.buildTrie(words, 0);
    }

    private Node buildTrie(List<BitVector> words, int pos) {
        Node n;
        BitVector curr;
        if (words.size() == 0) {
            return null;
        }
        BitVector first = words.get(0);
        int prefix = first.size();
        int change = -1;
        if (words.size() == 1) {
            return new Node(pos < prefix ? first.partFromTo(pos, prefix - 1) : null, this.size++);
        }
        ListIterator<BitVector> i = words.listIterator(1);
        while (i.hasNext()) {
            int j;
            curr = i.next();
            if (curr.size() < prefix) {
                prefix = curr.size();
            }
            for (j = pos; j < prefix && first.get(j) == curr.get(j); ++j) {
            }
            if (j >= prefix) continue;
            change = i.previousIndex();
            prefix = j;
        }
        if (prefix == first.size()) {
            change = 1;
            ListIterator<BitVector> i2 = words.listIterator(1);
            while (i2.hasNext() && !(curr = i2.next()).get(prefix)) {
                ++change;
            }
            n = new Node(prefix > pos ? first.partFromTo(pos, prefix - 1) : null, this.size++);
            n.left = this.buildTrie(words.subList(1, change), prefix + 1);
            n.right = this.buildTrie(words.subList(change, words.size()), prefix + 1);
        } else {
            n = new Node(prefix > pos ? first.partFromTo(pos, prefix - 1) : null);
            n.left = this.buildTrie(words.subList(0, change), prefix + 1);
            n.right = this.buildTrie(words.subList(change, words.size()), prefix + 1);
        }
        return n;
    }

    public int size() {
        return this.size;
    }

    public int get(BitVector word) {
        int length = word.size();
        Node n = this.root;
        int pos = 0;
        while (n != null) {
            if (pos == length) {
                return n.word;
            }
            long[] path = n.path;
            if (path != null) {
                int i;
                int minLength = Math.min(length - pos, n.pathLength);
                for (i = 0; i < minLength && word.get(pos + i) == QuickBitVector.get((long[])path, (int)i); ++i) {
                }
                if (i < minLength) {
                    return -1;
                }
                if ((pos += i) == length) {
                    return n.word;
                }
            }
            n = word.get(pos++) ? n.right : n.left;
        }
        return -1;
    }

    public int get(BooleanIterator iterator) {
        Node n = this.root;
        while (n != null) {
            if (!iterator.hasNext()) {
                return n.word;
            }
            int pathLength = n.pathLength;
            if (pathLength != 0) {
                int i;
                long[] path = n.path;
                for (i = 0; i < pathLength && iterator.hasNext() && iterator.nextBoolean() == QuickBitVector.get((long[])path, (int)i); ++i) {
                }
                if (i < pathLength) {
                    return -1;
                }
                if (!iterator.hasNext()) {
                    return n.word;
                }
            }
            n = iterator.nextBoolean() ? n.right : n.left;
        }
        return -1;
    }

    public Interval getInterval(BitVector word) {
        int length = word.size();
        Node n = this.root;
        int pos = 0;
        while (n != null && pos != length) {
            long[] path = n.path;
            if (path != null) {
                int i;
                int maxLength = Math.min(length - pos, n.pathLength);
                for (i = 0; i < maxLength && word.get(pos + i) == QuickBitVector.get((long[])path, (int)i); ++i) {
                }
                if (i < maxLength) {
                    return Intervals.EMPTY_INTERVAL;
                }
                if ((pos += i) == length) break;
            }
            n = word.get(pos++) ? n.right : n.left;
        }
        if (n == null) {
            return Intervals.EMPTY_INTERVAL;
        }
        Node l = n;
        while (l.word < 0) {
            l = l.left != null ? l.left : l.right;
        }
        while (!n.isLeaf()) {
            n = n.right != null ? n.right : n.left;
        }
        return Interval.valueOf(l.word, n.word);
    }

    public Interval getInterval(BooleanIterator iterator) {
        Node n = this.root;
        boolean mismatch = false;
        while (n != null && iterator.hasNext()) {
            int pathLength = n.pathLength;
            if (pathLength != 0) {
                long[] path = n.path;
                for (int i = 0; i < pathLength && iterator.hasNext() && !(mismatch = iterator.nextBoolean() != QuickBitVector.get((long[])path, (int)i)); ++i) {
                }
                if (mismatch) {
                    return Intervals.EMPTY_INTERVAL;
                }
                if (!iterator.hasNext()) break;
            }
            n = iterator.nextBoolean() ? n.right : n.left;
        }
        if (n == null) {
            return Intervals.EMPTY_INTERVAL;
        }
        Node l = n;
        while (l.word < 0) {
            l = l.left != null ? l.left : l.right;
        }
        while (!n.isLeaf()) {
            n = n.right != null ? n.right : n.left;
        }
        return Interval.valueOf(l.word, n.word);
    }

    public Interval getApproximatedInterval(BitVector word) {
        int length = word.size();
        Node n = this.root;
        boolean exactMatch = false;
        int pos = 0;
        while (n != null) {
            boolean nextBit;
            long[] path = n.path;
            if (pos == length) {
                if (n.word < 0 || path != null) break;
                exactMatch = true;
                break;
            }
            if (path != null) {
                int i;
                int maxLength = Math.min(length - pos, n.pathLength);
                for (i = 0; i < maxLength && word.get(pos + i) == QuickBitVector.get((long[])path, (int)i); ++i) {
                }
                if (i < maxLength) {
                    if (QuickBitVector.get((long[])path, (int)i)) {
                        while (n.word < 0) {
                            n = n.left != null ? n.left : n.right;
                        }
                        return n.word > 0 ? Interval.valueOf(n.word - 1) : Intervals.EMPTY_INTERVAL;
                    }
                    while (!n.isLeaf()) {
                        n = n.right != null ? n.right : n.left;
                    }
                    return Interval.valueOf(n.word);
                }
                if ((pos += i) == length) {
                    if (i != n.pathLength || n.word < 0) break;
                    exactMatch = true;
                    break;
                }
            }
            if (n.isLeaf()) break;
            if ((nextBit = word.get(pos++)) && n.right == null) {
                while (!n.isLeaf()) {
                    n = n.right != null ? n.right : n.left;
                }
                return Interval.valueOf(n.word);
            }
            if (!nextBit && n.left == null) {
                while (n.word < 0) {
                    n = n.left != null ? n.left : n.right;
                }
                return Interval.valueOf(n.word);
            }
            n = nextBit ? n.right : n.left;
        }
        Node l = n;
        while (l.word < 0) {
            l = l.left != null ? l.left : l.right;
        }
        while (!n.isLeaf()) {
            n = n.right != null ? n.right : n.left;
        }
        if (pos == length && !exactMatch) {
            if (l.word == 0) {
                return Intervals.EMPTY_INTERVAL;
            }
            return Interval.valueOf(l.word - 1, n.word);
        }
        return Interval.valueOf(l.word, n.word);
    }

    public Interval getApproximatedInterval(BooleanIterator iterator) {
        Node n = this.root;
        boolean exactMatch = false;
        boolean mismatch = false;
        while (true) {
            long[] path = n.path;
            if (!iterator.hasNext()) {
                if (n.word < 0 || path != null) break;
                exactMatch = true;
                break;
            }
            if (path != null) {
                int i;
                int pathSize = n.pathLength;
                for (i = 0; i < pathSize && iterator.hasNext() && !(mismatch = iterator.nextBoolean() != QuickBitVector.get((long[])path, (int)i)); ++i) {
                }
                if (mismatch) {
                    if (QuickBitVector.get((long[])path, (int)i)) {
                        while (n.word < 0) {
                            n = n.left != null ? n.left : n.right;
                        }
                        return n.word > 0 ? Interval.valueOf(n.word - 1) : Intervals.EMPTY_INTERVAL;
                    }
                    while (!n.isLeaf()) {
                        n = n.right != null ? n.right : n.left;
                    }
                    return Interval.valueOf(n.word);
                }
                if (!iterator.hasNext()) {
                    if (i != pathSize || n.word < 0) break;
                    exactMatch = true;
                    break;
                }
            }
            if (n.isLeaf()) break;
            boolean nextBit = iterator.nextBoolean();
            if (nextBit && n.right == null) {
                while (!n.isLeaf()) {
                    n = n.right != null ? n.right : n.left;
                }
                return Interval.valueOf(n.word);
            }
            if (!nextBit && n.left == null) {
                while (n.word < 0) {
                    n = n.left != null ? n.left : n.right;
                }
                return Interval.valueOf(n.word);
            }
            n = nextBit ? n.right : n.left;
        }
        Node l = n;
        while (l.word < 0) {
            l = l.left != null ? l.left : l.right;
        }
        while (!n.isLeaf()) {
            n = n.right != null ? n.right : n.left;
        }
        if (!iterator.hasNext() && !exactMatch) {
            if (l.word == 0) {
                return mismatch ? Intervals.EMPTY_INTERVAL : Interval.valueOf(0);
            }
            return Interval.valueOf(l.word - 1, n.word);
        }
        return Interval.valueOf(l.word, n.word);
    }

    private void recToString(Node n, MutableString printPrefix, MutableString result, MutableString path, int level) {
        if (n == null) {
            return;
        }
        result.append(printPrefix).append('(').append(level).append(')');
        if (path != null) {
            path.append(path);
            result.append(" path:").append(path);
        }
        if (n.word >= 0) {
            result.append(" word: ").append(n.word).append(" (").append(path).append(')');
        }
        result.append('\n');
        path.append('0');
        this.recToString(n.left, printPrefix.append('\t').append("0 => "), result, path, level + 1);
        path.charAt(path.length() - 1, '1');
        this.recToString(n.right, printPrefix.replace(printPrefix.length() - 5, printPrefix.length(), "1 => "), result, path, level + 1);
        path.delete(path.length() - 1, path.length());
        printPrefix.delete(printPrefix.length() - 6, printPrefix.length());
        path.delete(path.length() - n.pathLength, path.length());
    }

    public String toString() {
        MutableString s = new MutableString();
        this.recToString(this.root, new MutableString(), s, new MutableString(), 0);
        return s.toString();
    }

    protected static class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Node left;
        public Node right;
        public final long[] path;
        public final int pathLength;
        public final int word;

        public Node(BitVector path, int word) {
            if (path == null) {
                this.path = null;
                this.pathLength = 0;
            } else {
                this.path = path.elements();
                this.pathLength = path.size();
            }
            this.word = word;
        }

        public Node(BitVector path) {
            this(path, -1);
        }

        public boolean isLeaf() {
            return this.right == null && this.left == null;
        }

        public String toString() {
            return "[" + this.path + ", " + this.word + "]";
        }
    }
}

