/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.DocumentSequence;
import it.unimi.dsi.mg4j.document.IdentityDocumentFactory;
import it.unimi.dsi.mg4j.tool.Scan;
import it.unimi.dsi.mg4j.util.MG4JClassParser;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public class ScanMetadata {
    private static final Logger LOGGER = Util.getLogger(ScanMetadata.class);
    private static final char[] LINE_TERMINATORS = new char[]{'\n', '\r'};
    private static final char[] SPACES = new char[]{' ', ' '};

    public static void main(String[] arg) throws JSAPException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, IOException, IllegalAccessException, InstantiationException {
        Document document;
        SimpleJSAP jsap = new SimpleJSAP(ScanMetadata.class.getName(), "Scans and prints to standard output metadata of a collection. All line terminators in the metadata will be substituted with spaces.", new Parameter[]{new FlaggedOption("sequence", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'S', "sequence", "A serialised document sequence that will be used instead of stdin."), new FlaggedOption("delimiter", (StringParser)JSAP.INTEGER_PARSER, Integer.toString(10), false, 'd', "delimiter", "The document delimiter."), new FlaggedOption("factory", (StringParser)MG4JClassParser.getParser(), IdentityDocumentFactory.class.getName(), false, 'f', "factory", "A document factory with a standard constructor."), new FlaggedOption("property", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'p', "property", "A 'key=value' specification, or the name of a property file").setAllowMultipleDeclarations(true), new FlaggedOption("renumber", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'r', "renumber", "The filename of a document renumbering."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new FlaggedOption("titles", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 't', "titles", "The resulting document titles."), new FlaggedOption("uris", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'u', "uris", "The resulting document URIs.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        DocumentSequence documentSequence = Scan.getSequence(jsapResult.getString("sequence"), jsapResult.getClass("factory"), jsapResult.getStringArray("property"), jsapResult.getInt("delimiter"), LOGGER);
        if (!jsapResult.userSpecified("uris") && !jsapResult.userSpecified("titles")) {
            throw new IllegalArgumentException("You specify either a title or a URI output file");
        }
        Util.ensureLog4JIsConfigured();
        DocumentIterator documentIterator = documentSequence.iterator();
        FastBufferedOutputStream uriStream = null;
        FastBufferedOutputStream titleStream = null;
        if (jsapResult.userSpecified("uris")) {
            uriStream = new FastBufferedOutputStream((OutputStream)new FileOutputStream(jsapResult.getString("uris")));
        }
        if (jsapResult.userSpecified("titles")) {
            titleStream = new FastBufferedOutputStream((OutputStream)new FileOutputStream(jsapResult.getString("titles")));
        }
        MutableString s = new MutableString();
        ProgressLogger progressLogger = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), "documents");
        if (documentSequence instanceof DocumentCollection) {
            progressLogger.expectedUpdates = ((DocumentCollection)documentSequence).size();
        }
        progressLogger.start((CharSequence)"Scanning...");
        while ((document = documentIterator.nextDocument()) != null) {
            if (uriStream != null) {
                s.replace(document.uri());
                s.replace(LINE_TERMINATORS, SPACES);
                s.writeUTF8((OutputStream)uriStream);
                uriStream.write(10);
            }
            if (titleStream != null) {
                s.replace(document.title());
                s.replace(LINE_TERMINATORS, SPACES);
                s.writeUTF8((OutputStream)titleStream);
                titleStream.write(10);
            }
            progressLogger.lightUpdate();
        }
        progressLogger.done();
        if (uriStream != null) {
            uriStream.close();
        }
        if (titleStream != null) {
            titleStream.close();
        }
    }
}

