/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.mg4j.index.BitStreamHPIndexWriter;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.BitStreamIndexWriter;
import it.unimi.dsi.mg4j.index.CachingOutputBitStream;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.DiskBasedIndex;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.IndexWriter;
import it.unimi.dsi.mg4j.index.SkipBitStreamIndexWriter;
import it.unimi.dsi.mg4j.index.cluster.ContiguousDocumentalStrategy;
import it.unimi.dsi.mg4j.index.cluster.DocumentalConcatenatedCluster;
import it.unimi.dsi.mg4j.index.cluster.DocumentalMergedCluster;
import it.unimi.dsi.mg4j.index.cluster.DocumentalPartitioningStrategy;
import it.unimi.dsi.mg4j.index.cluster.DocumentalStrategies;
import it.unimi.dsi.mg4j.index.cluster.IndexCluster;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.util.BloomFilter;
import it.unimi.dsi.util.Properties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionDocumentally {
    private static final Logger LOGGER = Util.getLogger(PartitionDocumentally.class);
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private final int numIndices;
    private final String outputBasename;
    private final String[] localBasename;
    private final String inputBasename;
    private final Properties inputProperties;
    private final int bufferSize;
    private final String strategyFilename;
    private final DocumentalPartitioningStrategy strategy;
    private final Properties[] strategyProperties;
    private final long logInterval;
    private final BitStreamIndex globalIndex;
    private final IndexReader indexReader;
    private final FastBufferedReader terms;
    private final IndexWriter[] indexWriter;
    private final boolean haveCounts;
    private final boolean havePositions;
    private final boolean havePayloads;
    private final OutputBitStream[] localGlobCounts;
    private final OutputBitStream[] localFrequencies;
    private final PrintWriter[] localTerms;
    private final int[] maxDocSize;
    private final int[] maxDocPos;
    private final int[] numTerms;
    private final long[] numPostings;
    private final long[] numOccurrences;
    private final long[] globCount;
    private final int bloomFilterPrecision;

    public PartitionDocumentally(String inputBasename, String outputBasename, DocumentalPartitioningStrategy strategy, String strategyFilename, int bloomFilterPrecision, int bufferSize, Map<CompressionFlags.Component, CompressionFlags.Coding> writerFlags, boolean interleaved, boolean skips, int quantum, int height, int skipBufferSize, long logInterval) throws ConfigurationException, IOException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException {
        int i;
        this.inputBasename = inputBasename;
        this.outputBasename = outputBasename;
        this.strategy = strategy;
        this.strategyFilename = strategyFilename;
        this.strategyProperties = strategy.properties();
        this.bufferSize = bufferSize;
        this.logInterval = logInterval;
        this.bloomFilterPrecision = bloomFilterPrecision;
        this.numIndices = strategy.numberOfLocalIndices();
        CompressionFlags.Coding positionCoding = writerFlags.get((Object)CompressionFlags.Component.POSITIONS);
        this.inputProperties = new Properties(inputBasename + ".properties");
        this.globalIndex = DiskBasedIndex.getInstance(inputBasename, this.inputProperties, false, positionCoding == CompressionFlags.Coding.GOLOMB || positionCoding == CompressionFlags.Coding.INTERPOLATIVE, false, null);
        this.indexReader = this.globalIndex.getReader();
        this.localBasename = new String[this.numIndices];
        for (i = 0; i < this.numIndices; ++i) {
            this.localBasename[i] = outputBasename + "-" + i;
        }
        this.localGlobCounts = new OutputBitStream[this.numIndices];
        this.localFrequencies = new OutputBitStream[this.numIndices];
        this.localTerms = new PrintWriter[this.numIndices];
        this.maxDocSize = new int[this.numIndices];
        this.maxDocPos = new int[this.numIndices];
        this.numTerms = new int[this.numIndices];
        this.globCount = new long[this.numIndices];
        this.numOccurrences = new long[this.numIndices];
        this.numPostings = new long[this.numIndices];
        this.indexWriter = new IndexWriter[this.numIndices];
        this.havePayloads = writerFlags.containsKey((Object)CompressionFlags.Component.PAYLOADS);
        if (this.havePayloads && !this.globalIndex.hasPayloads) {
            throw new IllegalArgumentException("You requested payloads, but the global index does not contain them.");
        }
        this.haveCounts = writerFlags.containsKey((Object)CompressionFlags.Component.COUNTS);
        if (this.haveCounts && !this.globalIndex.hasCounts) {
            throw new IllegalArgumentException("You requested counts, but the global index does not contain them.");
        }
        this.havePositions = writerFlags.containsKey((Object)CompressionFlags.Component.POSITIONS);
        if (this.havePositions && !this.globalIndex.hasPositions) {
            throw new IllegalArgumentException("You requested positions, but the global index does not contain them.");
        }
        interleaved |= !this.havePositions || this.havePayloads;
        for (i = 0; i < this.numIndices; ++i) {
            String name = this.localBasename[i];
            this.indexWriter[i] = !interleaved ? new BitStreamHPIndexWriter(this.localBasename[i], strategy.numberOfDocuments(i), true, skipBufferSize, writerFlags, quantum, height) : (!skips ? new BitStreamIndexWriter(this.localBasename[i], strategy.numberOfDocuments(i), true, writerFlags) : new SkipBitStreamIndexWriter(this.localBasename[i], strategy.numberOfDocuments(i), true, skipBufferSize, writerFlags, quantum, height));
            if (this.haveCounts) {
                this.localGlobCounts[i] = new OutputBitStream(name + ".globcounts");
            }
            this.localFrequencies[i] = new OutputBitStream(name + ".frequencies");
            this.localTerms[i] = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.localBasename[i] + ".terms"), "UTF-8")));
        }
        this.terms = new FastBufferedReader((Reader)new InputStreamReader((InputStream)new FileInputStream(inputBasename + ".terms"), "UTF-8"));
    }

    private void partitionSizes() throws IOException {
        File sizesFile = new File(this.inputBasename + ".sizes");
        if (sizesFile.exists()) {
            int size;
            int localIndex;
            int i;
            LOGGER.info((Object)"Partitioning sizes...");
            InputBitStream sizes = new InputBitStream(sizesFile);
            OutputBitStream[] localSizes = new OutputBitStream[this.numIndices];
            for (int i2 = 0; i2 < this.numIndices; ++i2) {
                localSizes[i2] = new OutputBitStream(this.localBasename[i2] + ".sizes");
            }
            if (this.globalIndex.numberOfDocuments == this.strategy.numberOfDocuments(0)) {
                for (i = 0; i < this.globalIndex.numberOfDocuments; ++i) {
                    localIndex = this.strategy.localIndex(i);
                    size = sizes.readGamma();
                    localSizes[localIndex].writeGamma(size);
                    if (this.maxDocSize[localIndex] < size) {
                        this.maxDocSize[localIndex] = size;
                    }
                    int l = this.numIndices;
                    while (l-- != 0) {
                        if (l == localIndex) continue;
                        localSizes[l].writeGamma(0);
                    }
                }
            } else {
                for (i = 0; i < this.globalIndex.numberOfDocuments; ++i) {
                    localIndex = this.strategy.localIndex(i);
                    size = sizes.readGamma();
                    localSizes[localIndex].writeGamma(size);
                    if (this.maxDocSize[localIndex] >= size) continue;
                    this.maxDocSize[localIndex] = size;
                }
            }
            sizes.close();
            for (i = 0; i < this.numIndices; ++i) {
                localSizes[i].close();
            }
        }
    }

    public void run() throws Exception {
        int i;
        ProgressLogger pl = new ProgressLogger(LOGGER, this.logInterval);
        IntList sizeList = this.globalIndex.sizes;
        this.partitionSizes();
        int[] position = new int[this.globalIndex.maxCount];
        int[] localFrequency = new int[this.numIndices];
        int[] usedIndex = new int[this.numIndices];
        InputBitStream[] direct = new InputBitStream[this.numIndices];
        InputBitStream[] indirect = new InputBitStream[this.numIndices];
        BloomFilter[] bloomFilter = this.bloomFilterPrecision != 0 ? new BloomFilter[this.numIndices] : null;
        File[] tempFile = new File[this.numIndices];
        CachingOutputBitStream[] temp = new CachingOutputBitStream[this.numIndices];
        for (int i2 = 0; i2 < this.numIndices; ++i2) {
            tempFile[i2] = new File(this.localBasename[i2] + ".temp");
            temp[i2] = new CachingOutputBitStream(tempFile[i2], this.bufferSize);
            direct[i2] = new InputBitStream(temp[i2].buffer());
            indirect[i2] = new InputBitStream(tempFile[i2]);
            if (this.bloomFilterPrecision == 0) continue;
            bloomFilter[i2] = new BloomFilter(this.globalIndex.numberOfTerms, this.bloomFilterPrecision);
        }
        MutableString currentTerm = new MutableString();
        Payload payload = null;
        int count = -1;
        pl.expectedUpdates = this.globalIndex.numberOfPostings;
        pl.itemsName = "postings";
        pl.logInterval = this.logInterval;
        pl.start((CharSequence)"Partitioning index...");
        for (int t = 0; t < this.globalIndex.numberOfTerms; ++t) {
            int globalPointer;
            this.terms.readLine(currentTerm);
            IndexIterator indexIterator = this.indexReader.nextIterator();
            int usedIndices = 0;
            int frequency = indexIterator.frequency();
            for (int j = 0; j < frequency; ++j) {
                globalPointer = indexIterator.nextDocument();
                int localIndex = this.strategy.localIndex(globalPointer);
                if (localFrequency[localIndex] == 0) {
                    currentTerm.println(this.localTerms[localIndex]);
                    int n = localIndex;
                    this.numTerms[n] = this.numTerms[n] + 1;
                    usedIndex[usedIndices++] = localIndex;
                    if (this.bloomFilterPrecision != 0) {
                        bloomFilter[localIndex].add((CharSequence)currentTerm);
                    }
                }
                int n = localIndex;
                localFrequency[n] = localFrequency[n] + 1;
                int n2 = localIndex;
                this.numPostings[n2] = this.numPostings[n2] + 1L;
                temp[localIndex].writeGamma(globalPointer);
                if (this.globalIndex.hasPayloads) {
                    payload = indexIterator.payload();
                }
                if (this.havePayloads) {
                    payload.write(temp[localIndex]);
                }
                if (!this.haveCounts) continue;
                count = indexIterator.count();
                temp[localIndex].writeGamma(count);
                int n3 = localIndex;
                this.globCount[n3] = this.globCount[n3] + (long)count;
                if (this.maxDocPos[localIndex] < count) {
                    this.maxDocPos[localIndex] = count;
                }
                if (!this.havePositions) continue;
                int[] pos = indexIterator.positionArray();
                for (int p = 0; p < count; ++p) {
                    temp[localIndex].writeGamma(pos[p]);
                }
            }
            for (int k = 0; k < usedIndices; ++k) {
                InputBitStream ibs;
                int i3 = usedIndex[k];
                this.localFrequencies[i3].writeGamma(localFrequency[i3]);
                if (this.haveCounts) {
                    int n = i3;
                    this.numOccurrences[n] = this.numOccurrences[n] + this.globCount[i3];
                }
                if (this.localGlobCounts[i3] != null) {
                    this.localGlobCounts[i3].writeLongGamma(this.globCount[i3]);
                }
                this.globCount[i3] = 0L;
                this.indexWriter[i3].newInvertedList();
                temp[i3].align();
                if (temp[i3].buffer() != null) {
                    ibs = direct[i3];
                } else {
                    ibs = indirect[i3];
                    ibs.flush();
                    temp[i3].flush();
                }
                ibs.position(0L);
                this.indexWriter[i3].writeFrequency(localFrequency[i3]);
                for (int j = 0; j < localFrequency[i3]; ++j) {
                    OutputBitStream obs = this.indexWriter[i3].newDocumentRecord();
                    globalPointer = ibs.readGamma();
                    int localPointer = this.strategy.localPointer(globalPointer);
                    this.indexWriter[i3].writeDocumentPointer(obs, localPointer);
                    if (this.havePayloads) {
                        payload.read(ibs);
                        this.indexWriter[i3].writePayload(obs, payload);
                    }
                    if (this.haveCounts) {
                        count = ibs.readGamma();
                        this.indexWriter[i3].writePositionCount(obs, count);
                    }
                    if (!this.havePositions) continue;
                    for (int p = 0; p < count; ++p) {
                        position[p] = ibs.readGamma();
                    }
                    this.indexWriter[i3].writeDocumentPositions(obs, position, 0, count, sizeList != null ? sizeList.getInt(globalPointer) : -1);
                }
                temp[i3].position(0L);
                temp[i3].writtenBits(0L);
                localFrequency[i3] = 0;
            }
            usedIndices = 0;
            pl.count += (long)(frequency - 1);
            pl.update();
        }
        pl.done();
        Properties globalProperties = new Properties();
        globalProperties.setProperty((Enum)Index.PropertyKeys.FIELD, this.inputProperties.getProperty((Enum)Index.PropertyKeys.FIELD));
        globalProperties.setProperty((Enum)Index.PropertyKeys.TERMPROCESSOR, this.inputProperties.getProperty((Enum)Index.PropertyKeys.TERMPROCESSOR));
        for (i = 0; i < this.numIndices; ++i) {
            this.localFrequencies[i].close();
            if (this.localGlobCounts[i] != null) {
                this.localGlobCounts[i].close();
            }
            this.localTerms[i].close();
            this.indexWriter[i].close();
            if (this.bloomFilterPrecision != 0) {
                BinIO.storeObject((Object)bloomFilter[i], (CharSequence)(this.localBasename[i] + ".bloom"));
            }
            temp[i].close();
            tempFile[i].delete();
            Properties localProperties = this.indexWriter[i].properties();
            localProperties.addAll((Configuration)globalProperties);
            localProperties.setProperty((Enum)Index.PropertyKeys.MAXCOUNT, (Object)String.valueOf(this.maxDocPos[i]));
            localProperties.setProperty((Enum)Index.PropertyKeys.MAXDOCSIZE, this.maxDocSize[i]);
            localProperties.setProperty((Enum)Index.PropertyKeys.FIELD, globalProperties.getProperty((Enum)Index.PropertyKeys.FIELD));
            localProperties.setProperty((Enum)Index.PropertyKeys.OCCURRENCES, this.haveCounts ? this.numOccurrences[i] : -1L);
            localProperties.setProperty((Enum)Index.PropertyKeys.POSTINGS, this.numPostings[i]);
            localProperties.setProperty((Enum)Index.PropertyKeys.TERMS, this.numTerms[i]);
            if (this.havePayloads) {
                localProperties.setProperty((Enum)Index.PropertyKeys.PAYLOADCLASS, (Object)payload.getClass().getName());
            }
            if (this.strategyProperties[i] != null) {
                localProperties.addAll((Configuration)this.strategyProperties[i]);
            }
            localProperties.save(this.localBasename[i] + ".properties");
        }
        if (this.strategyFilename != null) {
            globalProperties.setProperty((Enum)IndexCluster.PropertyKeys.STRATEGY, (Object)this.strategyFilename);
        }
        for (i = 0; i < this.numIndices; ++i) {
            globalProperties.addProperty((Enum)IndexCluster.PropertyKeys.LOCALINDEX, (Object)this.localBasename[i]);
        }
        globalProperties.setProperty((Enum)IndexCluster.PropertyKeys.BLOOM, this.bloomFilterPrecision != 0);
        globalProperties.setProperty((Enum)IndexCluster.PropertyKeys.FLAT, this.inputProperties.getInt((Enum)Index.PropertyKeys.TERMS) <= 1);
        globalProperties.setProperty((Enum)Index.PropertyKeys.MAXCOUNT, this.inputProperties.getProperty((Enum)Index.PropertyKeys.MAXCOUNT));
        globalProperties.setProperty((Enum)Index.PropertyKeys.MAXDOCSIZE, this.inputProperties.getProperty((Enum)Index.PropertyKeys.MAXDOCSIZE));
        globalProperties.setProperty((Enum)Index.PropertyKeys.POSTINGS, this.inputProperties.getProperty((Enum)Index.PropertyKeys.POSTINGS));
        globalProperties.setProperty((Enum)Index.PropertyKeys.OCCURRENCES, this.inputProperties.getProperty((Enum)Index.PropertyKeys.OCCURRENCES));
        globalProperties.setProperty((Enum)Index.PropertyKeys.DOCUMENTS, this.inputProperties.getProperty((Enum)Index.PropertyKeys.DOCUMENTS));
        globalProperties.setProperty((Enum)Index.PropertyKeys.TERMS, this.inputProperties.getProperty((Enum)Index.PropertyKeys.TERMS));
        if (this.havePayloads) {
            globalProperties.setProperty((Enum)Index.PropertyKeys.PAYLOADCLASS, (Object)payload.getClass().getName());
        }
        globalProperties.setProperty((Enum)Index.PropertyKeys.INDEXCLASS, (Object)(this.strategy instanceof ContiguousDocumentalStrategy ? DocumentalConcatenatedCluster.class.getName() : DocumentalMergedCluster.class.getName()));
        globalProperties.save(this.outputBasename + ".properties");
        LOGGER.debug((Object)("Properties for clustered index " + this.outputBasename + ": " + new ConfigurationMap((Configuration)globalProperties)));
    }

    public static void main(String[] arg) throws ConfigurationException, IOException, URISyntaxException, ClassNotFoundException, Exception {
        SimpleJSAP jsap = new SimpleJSAP(PartitionDocumentally.class.getName(), "Partitions an index documentally.", new Parameter[]{new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, Util.formatBinarySize((long)0x100000L), false, 'b', "buffer-size", "The size of an I/O buffer."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new FlaggedOption("strategy", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 's', "strategy", "A serialised documental partitioning strategy."), new FlaggedOption("uniformStrategy", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 'u', "uniform", "Requires a uniform partitioning in the given number of parts."), new FlaggedOption("bloom", (StringParser)JSAP.INTEGER_PARSER, "0", false, 'B', "bloom", "Generates Bloom filters with given precision."), new FlaggedOption("comp", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'c', "comp", "A compression flag for the index (may be specified several times).").setAllowMultipleDeclarations(true), new Switch("skips", '\u0000', "skips", "Requires skips (which however are present by default, unless you required an interleaved index)."), new Switch("interleaved", '\u0000', "interleaved", "Forces an interleaved index."), new FlaggedOption("quantum", (StringParser)JSAP.INTSIZE_PARSER, "64", false, 'Q', "quantum", "The skip quantum."), new FlaggedOption("height", (StringParser)JSAP.INTSIZE_PARSER, "8", false, 'H', "height", "The skip height."), new FlaggedOption("skipBufferSize", (StringParser)JSAP.INTSIZE_PARSER, Util.formatBinarySize((long)0x4000000L), false, '\u0000', "skip-buffer-size", "The size of the internal temporary buffer used while creating an index with skips."), new UnflaggedOption("inputBasename", (StringParser)JSAP.STRING_PARSER, true, "The basename of the global index."), new UnflaggedOption("outputBasename", (StringParser)JSAP.STRING_PARSER, true, "The basename of the local indices.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String inputBasename = jsapResult.getString("inputBasename");
        String outputBasename = jsapResult.getString("outputBasename");
        String strategyFilename = jsapResult.getString("strategy");
        DocumentalPartitioningStrategy strategy = null;
        if (jsapResult.userSpecified("uniformStrategy")) {
            strategy = DocumentalStrategies.uniform(jsapResult.getInt("uniformStrategy"), Index.getInstance((CharSequence)inputBasename).numberOfDocuments);
            strategyFilename = outputBasename + ".strategy";
            BinIO.storeObject((Object)strategy, (CharSequence)strategyFilename);
        } else if (strategyFilename != null) {
            strategy = (DocumentalPartitioningStrategy)BinIO.loadObject((CharSequence)strategyFilename);
        } else {
            throw new IllegalArgumentException("You must specify a partitioning strategy");
        }
        boolean skips = jsapResult.getBoolean("skips");
        boolean interleaved = jsapResult.getBoolean("interleaved");
        if (interleaved && !skips && (jsapResult.userSpecified("quantum") || jsapResult.userSpecified("height"))) {
            System.err.println("You specified quantum or height, but did not turn on skips.");
            return;
        }
        new PartitionDocumentally(inputBasename, outputBasename, strategy, strategyFilename, jsapResult.getInt("bloom"), jsapResult.getInt("bufferSize"), CompressionFlags.valueOf(jsapResult.getStringArray("comp"), CompressionFlags.DEFAULT_STANDARD_INDEX), interleaved, skips, jsapResult.getInt("quantum"), jsapResult.getInt("height"), jsapResult.getInt("skipBufferSize"), jsapResult.getLong("logInterval")).run();
    }
}

