/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.WordReader;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.DocumentSequence;
import it.unimi.dsi.mg4j.document.IdentityDocumentFactory;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.search.AndDocumentIterator;
import it.unimi.dsi.mg4j.search.OrDocumentIterator;
import it.unimi.dsi.mg4j.tool.Scan;
import it.unimi.dsi.mg4j.util.MG4JClassParser;
import java.io.File;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public final class Verifier {
    private static final Logger LOGGER = Util.getLogger(Verifier.class);

    private Verifier() {
    }

    public static void main(String[] arg) throws Throwable {
        IndexIterator indexIterator;
        int i;
        SimpleJSAP jsap = new SimpleJSAP(Verifier.class.getName(), "Scans an index and associated files, checking internal coherence. Optionally, compares the index with a document sequence.", new Parameter[]{new FlaggedOption("sequence", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'S', "sequence", "A serialised document sequence that will be used instead of stdin."), new FlaggedOption("factory", (StringParser)MG4JClassParser.getParser(), IdentityDocumentFactory.class.getName(), false, 'f', "factory", "A document factory with a standard constructor."), new FlaggedOption("property", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'p', "property", "A 'key=value' specification, or the name of a property file").setAllowMultipleDeclarations(true), new FlaggedOption("indexedField", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'I', "indexed-field", "The field(s) of the document factory that will be indexed. (default: all fields)").setAllowMultipleDeclarations(true), new Switch("allFields", 'a', "all-fields", "Index also all virtual fields; has no effect if indexedField has been used at least once."), new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, Util.formatBinarySize((long)65536L), false, 'b', "buffer-size", "The size of an I/O buffer."), new FlaggedOption("delimiter", (StringParser)JSAP.INTEGER_PARSER, Integer.toString(10), false, 'd', "delimiter", "The document delimiter."), new FlaggedOption("renumber", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'r', "renumber", "The filename of a document renumbering."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new Switch("termLists", 't', "term-lists", "Instead of assuming each index knows its terms, read a term file stemmed from the index name."), new Switch("stem", 's', "stem", "Stem basename using field names from the collection."), new Switch("random", 'R', "random", "Perform random access checks; requires a collection (will use stdin if none is specified)."), new Switch("virtual", '\u0000', "virtual", "Virtual collection; skip document size/occurrences check and random access check."), new Switch("noSeq", '\u0000', "no-seq", "Skip sequential check."), new Switch("noSkip", '\u0000', "no-skip", "Skip \"all-skips\" check."), new Switch("noComp", '\u0000', "no-comp", "Skip composite iterator check."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, true, "The basename of the index.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        DocumentSequence documentSequence = Scan.getSequence(jsapResult.getString("sequence"), jsapResult.getClass("factory"), jsapResult.getStringArray("property"), jsapResult.getInt("delimiter"), LOGGER);
        DocumentFactory factory = documentSequence.factory();
        boolean stem = jsapResult.getBoolean("stem");
        boolean termLists = jsapResult.getBoolean("termLists");
        int[] indexedField = Scan.parseFieldNames(jsapResult.getStringArray("indexedField"), factory, jsapResult.getBoolean("allFields"));
        LOGGER.debug((Object)("Parsed indexed field: " + IntArrayList.wrap((int[])indexedField)));
        String basename = jsapResult.getString("basename");
        String permutationFile = jsapResult.getString("renumber");
        int t = 0;
        ProgressLogger pl = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), "ints");
        Index[] index = stem ? new Index[indexedField.length] : new Index[1];
        int[] numberOfTerms = new int[indexedField.length];
        ObjectArrayList[] terms = new ObjectArrayList[indexedField.length];
        IndexReader[] indexReader = new IndexReader[index.length];
        InputBitStream[] frequencies = new InputBitStream[index.length];
        int[][] count = new int[index.length][];
        int[] permutation = permutationFile != null ? BinIO.loadInts((CharSequence)permutationFile) : null;
        int[][] occ = new int[index.length][];
        int[][] wordInPos = new int[index.length][];
        Int2IntOpenHashMap[] termsInDoc = new Int2IntOpenHashMap[index.length];
        int totalTerms = 0;
        boolean allBitStreamIndices = true;
        for (i = 0; i < index.length; ++i) {
            String basenameField = basename + (stem ? "-" + factory.fieldName(indexedField[i]) : "");
            index[i] = Index.getInstance(basenameField);
            if (!(index[i] instanceof BitStreamIndex)) {
                allBitStreamIndices = false;
            }
            if (termLists) {
                terms[i] = new ObjectArrayList((Collection)new FileLinesCollection((CharSequence)(basenameField + ".terms"), "UTF-8").allLines());
                numberOfTerms[i] = terms[i].size();
            } else {
                numberOfTerms[i] = index[i].numberOfTerms;
            }
            totalTerms += numberOfTerms[i];
            count[i] = new int[index[i].numberOfDocuments];
            occ[i] = index[i].maxCount > 0 ? new int[index[i].maxCount] : IntArrays.EMPTY_ARRAY;
            wordInPos[i] = new int[Math.max(0, index[i].properties.getInt((Enum)Index.PropertyKeys.MAXDOCSIZE))];
            indexReader[i] = index[i].getReader();
            if (new File(basenameField + ".frequencies").exists()) {
                frequencies[i] = new InputBitStream(basenameField + ".frequencies");
            }
            termsInDoc[i] = new Int2IntOpenHashMap();
        }
        int currDoc = 0;
        int pos = 0;
        int f = 0;
        pl.itemsName = "lists";
        pl.expectedUpdates = totalTerms;
        int indexFrequency = -1;
        if (!jsapResult.getBoolean("noSeq")) {
            try {
                for (i = 0; i < index.length; ++i) {
                    int p;
                    int numberOfPostings = 0;
                    pl.expectedUpdates = numberOfTerms[i];
                    pl.start((CharSequence)("Verifying sequentially index " + index[i] + "..."));
                    if (allBitStreamIndices) {
                        for (t = 0; t < numberOfTerms[i]; ++t) {
                            pl.update();
                            IndexIterator indexIterator2 = indexReader[i].nextIterator();
                            indexFrequency = indexIterator2.frequency();
                            numberOfPostings += indexFrequency;
                            if (frequencies[i] != null && indexFrequency != (f = frequencies[i].readGamma())) {
                                System.err.println("Error in frequency for term " + t + ": expected " + f + " documents, found " + indexFrequency);
                                return;
                            }
                            while (indexFrequency-- != 0) {
                                p = indexIterator2.nextDocument();
                                if (index[i].hasCounts) {
                                    int[] nArray = count[i];
                                    int n = p;
                                    nArray[n] = nArray[n] + indexIterator2.count();
                                }
                                if (!index[i].hasPositions) continue;
                                indexIterator2.positionArray();
                            }
                            if (indexIterator2.nextDocument() != -1) {
                                throw new AssertionError((Object)"nextDocument() is not -1 after exhaustive iteration");
                            }
                        }
                        if (!jsapResult.getBoolean("virtual") && ((BitStreamIndex)index[i]).sizes != null && index[i].hasCounts) {
                            for (p = 0; p < index[i].numberOfDocuments; ++p) {
                                if (index[i].sizes.getInt(p) == count[i][p]) continue;
                                System.err.println("Document " + p + " has size " + ((BitStreamIndex)index[i]).sizes.getInt(p) + " but " + count[i][p] + " occurrences have been stored.");
                            }
                        }
                    } else {
                        for (t = 0; t < numberOfTerms[i]; ++t) {
                            pl.update();
                            IndexIterator indexIterator3 = termLists ? indexReader[i].documents((CharSequence)terms[i].get(t)) : indexReader[i].documents(t);
                            indexFrequency = indexIterator3.frequency();
                            numberOfPostings += indexFrequency;
                            if (frequencies[i] != null && indexFrequency != (f = frequencies[i].readGamma())) {
                                System.err.println("Error in frequency for term " + t + ": expected " + f + " documents, found " + indexFrequency);
                                return;
                            }
                            int prevp = -1;
                            while (indexFrequency-- != 0) {
                                p = indexIterator3.nextDocument();
                                assert (prevp < p) : "previous pointer: " + prevp + "; current pointer: " + p;
                                prevp = p;
                                if (!index[i].hasCounts) continue;
                                int[] nArray = count[i];
                                int n = p;
                                nArray[n] = nArray[n] + indexIterator3.count();
                            }
                        }
                    }
                    pl.done();
                    if ((long)numberOfPostings != index[i].numberOfPostings) {
                        System.err.println("Index declares " + index[i].numberOfPostings + " postings, but we found " + numberOfPostings);
                    }
                    long numberOfOccurrences = 0L;
                    if (!index[i].hasCounts) continue;
                    for (p = 0; p < index[i].numberOfDocuments; ++p) {
                        numberOfOccurrences += (long)count[i][p];
                    }
                    if (numberOfOccurrences == index[i].numberOfOccurrences) continue;
                    System.err.println("Index declares " + index[i].numberOfOccurrences + " occurrences, but we found " + numberOfOccurrences);
                }
            }
            catch (Exception e) {
                System.err.println("Exception while scanning sequentially term " + t + " of index " + index[i]);
                System.err.println("Term frequency was " + f + " and position " + (f - indexFrequency - 1));
                throw e;
            }
        }
        IntArrayList l = new IntArrayList();
        ObjectArrayList positions = new ObjectArrayList();
        if (!jsapResult.getBoolean("noSkip")) {
            int start = 0;
            int end = 0;
            try {
                for (i = 0; i < index.length; ++i) {
                    pl.expectedUpdates = numberOfTerms[i];
                    pl.start((CharSequence)("Verifying all skips in " + index[i] + "..."));
                    for (t = 0; t < numberOfTerms[i]; ++t) {
                        int d;
                        IndexIterator documents;
                        l.clear();
                        positions.clear();
                        IndexIterator indexIterator4 = documents = termLists ? indexReader[i].documents((CharSequence)terms[i].get(t)) : indexReader[i].documents(t);
                        while ((d = documents.nextDocument()) != -1) {
                            l.add(d);
                            if (!index[i].hasPositions) continue;
                            positions.add((Object)ArrayUtils.subarray((int[])documents.positionArray(), (int)0, (int)documents.count()));
                        }
                        for (start = 0; start < l.size(); ++start) {
                            int result;
                            for (end = start + 1; end < l.size(); ++end) {
                                indexIterator = termLists ? indexReader[i].documents((CharSequence)terms[i].get(t)) : indexReader[i].documents(t);
                                result = indexIterator.skipTo(l.getInt(start));
                                assert (indexIterator.document() == l.getInt(start) && result == l.getInt(start)) : "Trying to skip to document " + l.getInt(start) + " (term " + t + ") moved to " + indexIterator.document() + "(skipTo() returned " + result + ")";
                                result = indexIterator.skipTo(l.getInt(end));
                                assert (indexIterator.document() == l.getInt(end) && result == l.getInt(end)) : "Trying to skip to document " + l.getInt(end) + " (term " + t + ") after a skip to " + start + " moved to " + indexIterator.document() + "(skipTo() returned " + result + ")";
                                if (!index[i].hasPositions) continue;
                                indexIterator = termLists ? indexReader[i].documents((CharSequence)terms[i].get(t)) : indexReader[i].documents(t);
                                indexIterator.skipTo(l.getInt(start));
                                assert (indexIterator.document() == l.getInt(start)) : indexIterator.document() + " != " + l.getInt(start);
                                assert (indexIterator.count() == ((int[])positions.get(start)).length) : indexIterator.count() + " != " + ((int[])positions.get(start)).length;
                                assert (Arrays.equals((int[])positions.get(start), ArrayUtils.subarray((int[])indexIterator.positionArray(), (int)0, (int)indexIterator.count()))) : Arrays.toString((int[])positions.get(start)) + "!=" + Arrays.toString(ArrayUtils.subarray((int[])indexIterator.positionArray(), (int)0, (int)indexIterator.count()));
                                indexIterator.skipTo(l.getInt(end));
                                assert (indexIterator.document() == l.getInt(end)) : indexIterator.document() + " != " + l.getInt(end);
                                assert (indexIterator.count() == ((int[])positions.get(end)).length) : indexIterator.count() + " != " + ((int[])positions.get(end)).length;
                                assert (Arrays.equals((int[])positions.get(end), ArrayUtils.subarray((int[])indexIterator.positionArray(), (int)0, (int)indexIterator.count()))) : Arrays.toString((int[])positions.get(end)) + "!=" + Arrays.toString(ArrayUtils.subarray((int[])indexIterator.positionArray(), (int)0, (int)indexIterator.count()));
                            }
                            indexIterator = termLists ? indexReader[i].documents((CharSequence)terms[i].get(t)) : indexReader[i].documents(t);
                            result = indexIterator.skipTo(l.getInt(start));
                            assert (indexIterator.document() == l.getInt(start) && result == l.getInt(start)) : "Trying to skip to document " + l.getInt(start) + " (term " + t + ") moved to " + indexIterator.document() + "(skipTo() returned " + result + ")";
                            result = indexIterator.skipTo(Integer.MAX_VALUE);
                            assert (!indexIterator.hasNext() && result == Integer.MAX_VALUE) : "Trying to skip beyond end of list (term " + t + ") after a skip to " + start + " returned " + result + " (hasNext()=" + indexIterator.hasNext() + ")";
                        }
                        pl.update();
                    }
                    pl.done();
                }
            }
            catch (Throwable e) {
                System.err.println("Exception during all-skip test (index=" + index[i] + ", term=" + t + ", start=" + start + ", end=" + end + ")");
                throw e;
            }
        }
        if (!jsapResult.getBoolean("noComp")) {
            IntLinkedOpenHashSet s0 = new IntLinkedOpenHashSet();
            IntOpenHashSet s1 = new IntOpenHashSet();
            IntAVLTreeSet s2 = new IntAVLTreeSet();
            int u = 0;
            try {
                for (i = 0; i < index.length; ++i) {
                    pl.expectedUpdates = numberOfTerms[i];
                    pl.start((CharSequence)("Verifying composite iterators in " + index[i] + "..."));
                    IndexReader additionalReader = index[i].getReader();
                    for (t = 0; t < numberOfTerms[i]; ++t) {
                        for (u = 0; u < numberOfTerms[i]; ++u) {
                            s0.clear();
                            s1.clear();
                            IntIterators.pour((IntIterator)(termLists ? indexReader[i].documents((CharSequence)terms[i].get(t)) : indexReader[i].documents(t)), (IntCollection)s0);
                            IntIterators.pour((IntIterator)(termLists ? indexReader[i].documents((CharSequence)terms[i].get(u)) : indexReader[i].documents(u)), (IntCollection)s1);
                            s0.retainAll((IntCollection)s1);
                            indexIterator = termLists ? indexReader[i].documents((CharSequence)terms[i].get(t)) : indexReader[i].documents(t);
                            IndexIterator additionalIterator = termLists ? additionalReader.documents((CharSequence)terms[i].get(u)) : additionalReader.documents(u);
                            IntBidirectionalIterator it = s0.iterator();
                            it.unimi.dsi.mg4j.search.DocumentIterator documentIterator = AndDocumentIterator.getInstance(indexIterator, additionalIterator);
                            int j = s0.size();
                            while (j-- != 0) {
                                assert (it.nextInt() == documentIterator.nextDocument());
                            }
                            assert (!documentIterator.hasNext());
                            s2.clear();
                            IntIterators.pour((IntIterator)(termLists ? indexReader[i].documents((CharSequence)terms[i].get(t)) : indexReader[i].documents(t)), (IntCollection)s2);
                            IntIterators.pour((IntIterator)(termLists ? indexReader[i].documents((CharSequence)terms[i].get(u)) : indexReader[i].documents(u)), (IntCollection)s2);
                            indexIterator = termLists ? indexReader[i].documents((CharSequence)terms[i].get(t)) : indexReader[i].documents(t);
                            additionalIterator = termLists ? additionalReader.documents((CharSequence)terms[i].get(u)) : additionalReader.documents(u);
                            it = s2.iterator();
                            documentIterator = OrDocumentIterator.getInstance(indexIterator, additionalIterator);
                            j = s2.size();
                            while (j-- != 0) {
                                assert (it.nextInt() == documentIterator.nextDocument());
                            }
                            assert (!documentIterator.hasNext());
                        }
                        pl.update();
                    }
                    pl.done();
                    additionalReader.close();
                }
            }
            catch (Throwable e) {
                System.err.println("Exception during composite iterator test (index=" + index[i] + ", first term=" + t + ", second term =" + u + ")");
                throw e;
            }
        }
        if (!jsapResult.getBoolean("virtual") && jsapResult.getBoolean("random")) {
            WordReader wordReader;
            Payload payload;
            Object content;
            Document document;
            int docCounter;
            MutableString nonWord;
            MutableString word;
            DocumentIterator documentIterator;
            pl.expectedUpdates = index[0].numberOfDocuments;
            pl.itemsName = "documents";
            pl.start((CharSequence)"Verifying random access...");
            if (allBitStreamIndices) {
                documentIterator = documentSequence.iterator();
                word = new MutableString();
                nonWord = new MutableString();
                docCounter = 0;
                while ((document = documentIterator.nextDocument()) != null) {
                    currDoc = permutation != null ? permutation[docCounter] : docCounter;
                    for (i = 0; i < index.length; ++i) {
                        IntIterator x;
                        content = document.content(stem || index[i].field == null ? indexedField[i] : factory.fieldIndex(index[i].field));
                        if (index[i].hasPayloads) {
                            IndexIterator indexIterator5;
                            if (allBitStreamIndices) {
                                indexIterator5 = indexReader[i].documents(0);
                                int pointer = indexIterator5.skipTo(currDoc);
                                if (pointer == currDoc) {
                                    payload = indexIterator5.payload();
                                    if (payload.get().equals(content)) continue;
                                    LOGGER.error((Object)(index[i] + ": Document " + currDoc + " has payload " + content + " but the index says " + payload));
                                    continue;
                                }
                                LOGGER.error((Object)(index[i] + ": Document " + currDoc + " does not appear in the inverted list of term " + t));
                                continue;
                            }
                            indexIterator5 = indexReader[i].documents(0);
                            if (indexIterator5.skipTo(currDoc) == currDoc) {
                                if (indexIterator5.payload().get().equals(content)) continue;
                                LOGGER.error((Object)(index[i] + ": Document " + currDoc + " has payload " + content + " but the index says " + indexIterator5.payload().get()));
                                continue;
                            }
                            LOGGER.error((Object)(index[i] + ": Document " + currDoc + " does not appear in the inverted list of term " + t));
                            continue;
                        }
                        pos = 0;
                        termsInDoc[i].clear();
                        Reader reader = (Reader)content;
                        wordReader = document.wordReader(stem || index[i].field == null ? indexedField[i] : factory.fieldIndex(index[i].field));
                        wordReader.setReader(reader);
                        while (wordReader.next(word, nonWord)) {
                            if (word.length() == 0 || index[i].termProcessor != null && !index[i].termProcessor.processTerm(word)) continue;
                            t = (int)((BitStreamIndex)index[i]).termMap.getLong((Object)word);
                            if (t == -1) {
                                LOGGER.error((Object)(index[i] + ": Could not find term " + word + " in term index"));
                                continue;
                            }
                            if (index[i].hasCounts) {
                                termsInDoc[i].put(t, termsInDoc[i].get(t) + 1);
                            }
                            if (!index[i].hasPositions) continue;
                            wordInPos[i][pos++] = t;
                        }
                        if (allBitStreamIndices) {
                            x = termsInDoc[i].keySet().iterator();
                            while (x.hasNext()) {
                                t = x.nextInt();
                                IndexIterator indexIterator6 = indexReader[i].documents(t);
                                int pointer = indexIterator6.skipTo(currDoc);
                                if (pointer == currDoc) {
                                    if (!index[i].hasCounts) continue;
                                    int c = indexIterator6.count();
                                    if (termsInDoc[i].get(t) != c) {
                                        LOGGER.error((Object)(index[i] + ": The count for term " + t + " in document " + currDoc + " is " + c + " instead of " + termsInDoc[i].get(t)));
                                        continue;
                                    }
                                    if (!index[i].hasPositions) continue;
                                    indexIterator6.positions(occ[i]);
                                    for (int j = 0; j < c; ++j) {
                                        if (wordInPos[i][occ[i][j]] == t) continue;
                                        LOGGER.error((Object)(index[i] + ": The occurrence of index " + i + " of term " + t + " (position " + occ[i] + ") in document " + currDoc + " is occupied instead by term " + wordInPos[i][occ[i][j]]));
                                    }
                                    continue;
                                }
                                LOGGER.error((Object)(index[i] + ": Document " + currDoc + " does not appear in the inverted list of term " + t + "(skipTo returned " + pointer + ")"));
                            }
                            continue;
                        }
                        x = termsInDoc[i].keySet().iterator();
                        while (x.hasNext()) {
                            IndexIterator indexIterator7;
                            t = x.nextInt();
                            IndexIterator indexIterator8 = indexIterator7 = termLists ? indexReader[i].documents((CharSequence)terms[i].get(t)) : indexReader[i].documents(t);
                            if (indexIterator7.skipTo(currDoc) == currDoc) {
                                if (!index[i].hasCounts) continue;
                                int c = indexIterator7.count();
                                if (termsInDoc[i].get(t) != c) {
                                    LOGGER.error((Object)(index[i] + ": The count for term " + t + " in document " + currDoc + " is " + c + " instead of " + termsInDoc[i].get(t)));
                                    continue;
                                }
                                if (!index[i].hasPositions) continue;
                                indexIterator7.positions(occ[i]);
                                for (int j = 0; j < c; ++j) {
                                    if (wordInPos[i][occ[i][j]] == t) continue;
                                    LOGGER.error((Object)(index[i] + ": The occurrence of index " + i + " of term " + t + " (position " + occ[i] + ") in document " + currDoc + " is occupied instead by term " + wordInPos[i][occ[i][j]]));
                                }
                                continue;
                            }
                            LOGGER.error((Object)(index[i] + ": Document " + currDoc + " does not appear in the inverted list of term " + t));
                        }
                    }
                    ++docCounter;
                    document.close();
                    pl.update();
                }
            } else {
                LOGGER.warn((Object)"Random access tests require very slow single-term scanning as not all indices are disk based");
                documentIterator = documentSequence.iterator();
                word = new MutableString();
                nonWord = new MutableString();
                docCounter = 0;
                while ((document = documentIterator.nextDocument()) != null) {
                    currDoc = permutation != null ? permutation[docCounter] : docCounter;
                    for (i = 0; i < index.length; ++i) {
                        IndexIterator indexIterator9;
                        content = document.content(stem || index[i].field == null ? indexedField[i] : factory.fieldIndex(index[i].field));
                        if (index[i].hasPayloads) {
                            if (allBitStreamIndices) {
                                indexIterator9 = indexReader[i].documents(0);
                                int pointer = indexIterator9.skipTo(currDoc);
                                if (pointer == currDoc) {
                                    payload = indexIterator9.payload();
                                    if (payload.get().equals(content)) continue;
                                    LOGGER.error((Object)(index[i] + ": Document " + currDoc + " has payload " + content + " but the index says " + payload));
                                    continue;
                                }
                                LOGGER.error((Object)(index[i] + ": Document " + currDoc + " does not appear in the inverted list of term " + t));
                                continue;
                            }
                            indexIterator9 = indexReader[i].documents("#");
                            if (indexIterator9.skipTo(currDoc) == currDoc) {
                                if (indexIterator9.payload().get().equals(content)) continue;
                                LOGGER.error((Object)(index[i] + ": Document " + currDoc + " has payload " + content + " but the index says " + indexIterator9.payload().get()));
                                continue;
                            }
                            LOGGER.error((Object)(index[i] + ": Document " + currDoc + " does not appear in the inverted list of term " + t));
                            continue;
                        }
                        pos = 0;
                        Reader reader = (Reader)content;
                        wordReader = document.wordReader(stem || index[i].field == null ? indexedField[i] : factory.fieldIndex(index[i].field));
                        wordReader.setReader(reader);
                        while (wordReader.next(word, nonWord)) {
                            if (word.length() == 0 || index[i].termProcessor != null && !index[i].termProcessor.processTerm(word)) continue;
                            indexIterator9 = indexReader[i].documents((CharSequence)word);
                            if (currDoc != indexIterator9.skipTo(currDoc)) {
                                LOGGER.error((Object)(index[i] + ": Document " + currDoc + " does not appear in the inverted list of term " + word));
                            } else if (index[i].hasPositions) {
                                indexIterator9.positions(occ[i]);
                                if (IntArrayList.wrap((int[])occ[i], (int)indexIterator9.count()).indexOf(pos) == -1) {
                                    LOGGER.error((Object)(index[i] + ": Position " + pos + " does not appear in the position list of term " + word + " in document " + currDoc));
                                }
                            }
                            ++pos;
                        }
                    }
                    document.close();
                    pl.update();
                    ++docCounter;
                }
            }
            pl.done();
        }
        for (IndexReader ir : indexReader) {
            ir.close();
        }
    }
}

