/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.util.Properties;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

public final class SelectStats {
    private static final Logger LOGGER = Util.getLogger(SelectStats.class);
    private static final NumberFormat formatDouble = new DecimalFormat("#,##0.00000");

    private SelectStats() {
    }

    public static String format(double d) {
        StringBuffer s = new StringBuffer();
        return formatDouble.format(d, s, new FieldPosition(0)).toString();
    }

    public static void main(String[] arg) throws IOException, JSAPException, ConfigurationException {
        SimpleJSAP jsap = new SimpleJSAP(SelectStats.class.getName(), "Prints or selects parts of a stat file using global counts.", new Parameter[]{new Switch("print", 'p', "print", "Just print global occurrences."), new FlaggedOption("globalFrequency", (StringParser)JSAP.DOUBLE_PARSER, JSAP.NO_DEFAULT, false, 'g', "global-frequency", "The global count divided by the sum of document lengths that will be used to choose words to dump."), new FlaggedOption("quantumBitLength", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 'q', "quantum-bit-length", "The quantum bit length that will be used to choose words to dump."), new FlaggedOption("error", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 'e', "error", "The error w.r.t. frequency (as a percentage) that will be used to choose words to dump."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, true, "The index basename."), new UnflaggedOption("statFile", (StringParser)JSAP.STRING_PARSER, true, "The stat file to be scanned.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        boolean print = jsapResult.getBoolean("print");
        String basename = jsapResult.getString("basename");
        String statFile = jsapResult.getString("statFile");
        int quantumBitLength = jsapResult.getInt("quantumBitLength", 0);
        double globalFrequency = jsapResult.getDouble("globalFrequency", 0.0);
        int error = jsapResult.getInt("error", 1);
        double lowGlobFreq = globalFrequency * (1.0 - (double)error / 100.0);
        double highGlobFreq = globalFrequency * (1.0 + (double)error / 100.0);
        int lowQbl = (int)Math.round((double)quantumBitLength * (1.0 - (double)error / 100.0));
        int highQbl = (int)Math.round((double)quantumBitLength * (1.0 + (double)error / 100.0));
        Properties properties = new Properties(basename + ".properties");
        int numberOfTerms = properties.getInt((Enum)Index.PropertyKeys.TERMS);
        long numberOfoccurrences = properties.getLong((Enum)Index.PropertyKeys.OCCURRENCES);
        InputBitStream globCounts = new InputBitStream(basename + ".globcounts");
        long[] gc = new long[numberOfTerms];
        for (int t = 0; t < numberOfTerms; ++t) {
            gc[t] = globCounts.readLongGamma();
        }
        globCounts.close();
        MutableString line = new MutableString();
        FastBufferedReader reader = new FastBufferedReader((Reader)new FileReader(statFile));
        boolean dumping = false;
        reader.readLine(line);
        while (reader.readLine(line) != null) {
            if (line.charAt(0) == '#') {
                MutableString number = line.substring(2);
                int f = Integer.parseInt(number.delete(number.indexOf(' '), number.length()).toString());
                double freq = (double)gc[f] / (double)numberOfoccurrences;
                if (print) {
                    System.out.println(line + " " + SelectStats.format(freq));
                } else if (quantumBitLength != 0) {
                    number = line.substring(2);
                    int q = Integer.parseInt((number = number.substring(number.indexOf(' ') + 1)).delete(number.indexOf(' '), number.length()).toString());
                    dumping = q >= lowQbl && q <= highQbl;
                } else {
                    boolean bl = dumping = freq >= lowGlobFreq && freq <= highGlobFreq;
                }
                if (!dumping) continue;
                line.println(System.out);
                continue;
            }
            if (print || !dumping) continue;
            line.println(System.out);
        }
    }
}

