/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.test;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.lang.MutableString;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SelectHeights {
    private SelectHeights() {
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(SelectHeights.class.getName(), "Prints or selects parts of a stat file using global counts.", new Parameter[]{new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, true, "The basename of the height files."), new UnflaggedOption("h", (StringParser)JSAP.INTEGER_PARSER, true, "The maximum height to scan.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        Pattern pattern = Pattern.compile("\t");
        Matcher matcher = pattern.matcher("");
        int h = jsapResult.getInt("h");
        String basename = jsapResult.getString("basename");
        PrintStream[] printStream = new PrintStream[h + 1];
        for (int i = 0; i <= h; ++i) {
            printStream[i] = new PrintStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(basename + "-" + i + ".stats")));
        }
        MutableString line = new MutableString();
        FastBufferedReader reader = new FastBufferedReader((Reader)new InputStreamReader(System.in));
        while (reader.readLine(line) != null) {
            if (line.charAt(0) == '#') continue;
            matcher.reset((CharSequence)line);
            int start = 0;
            for (int l = 0; matcher.find() && l <= h; ++l) {
                printStream[l].println(line.subSequence(start, matcher.start()));
                start = matcher.end();
            }
        }
        for (int i = 0; i <= h; ++i) {
            printStream[i].close();
        }
    }
}

