/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.test;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.DiskBasedIndex;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.util.Interval;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import junit.framework.Assert;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

public class RemoteIndexIteratorTest {
    private static final Logger LOGGER = Util.getLogger(RemoteIndexIteratorTest.class);
    private static final boolean _DEBUG_SERVER = false;
    private static final boolean _DEBUG_CLUSTER = false;
    private static BitStreamIndex firstIndex;
    private static Index secondIndex;
    private static String firstBaseName;
    private static String secondBaseName;
    private static boolean textTerm;

    public static void testIndexIterator() throws IOException {
        IndexReader firstIndexReader = firstIndex.getReader();
        IndexReader secondIndexReader = secondIndex.getReader(1000);
        IndexIterator firstIterator = null;
        IndexIterator secondIterator = null;
        for (int i = 0; i < RemoteIndexIteratorTest.firstIndex.numberOfTerms; ++i) {
            try {
                System.out.println("term: " + i);
                firstIterator = firstIndexReader.documents(i);
                secondIterator = !textTerm ? secondIndexReader.documents(i) : secondIndexReader.documents((CharSequence)RemoteIndexIteratorTest.firstIndex.termMap.list().get(i));
                Assert.assertEquals((boolean)firstIterator.hasNext(), (boolean)secondIterator.hasNext());
                Assert.assertEquals((int)firstIterator.frequency(), (int)secondIterator.frequency());
                while (firstIterator.hasNext()) {
                    int fr = firstIterator.nextDocument();
                    int sr = secondIterator.nextDocument();
                    Assert.assertEquals((int)fr, (int)sr);
                    Assert.assertEquals((int)firstIterator.count(), (int)secondIterator.count());
                    int[] firstPos = new int[1000];
                    int[] secondPos = new int[1000];
                    int fRet = firstIterator.positions(firstPos);
                    int sRet = secondIterator.positions(secondPos);
                    System.out.println(fRet + "  " + sRet);
                    Assert.assertTrue((fRet == sRet ? 1 : 0) != 0);
                    for (int j = 0; j < fRet; ++j) {
                        Assert.assertEquals((int)firstPos[j], (int)secondPos[j]);
                    }
                }
                while (firstIterator.hasNext()) {
                    secondIterator.next();
                    int[] firstPos = firstIterator.positionArray();
                    int[] secondPos = secondIterator.positionArray();
                    Assert.assertTrue((firstPos.length == secondPos.length ? 1 : 0) != 0);
                    for (int j = 0; j < firstPos.length; ++j) {
                        Assert.assertTrue((firstPos[j] == secondPos[j] ? 1 : 0) != 0);
                    }
                }
                firstIterator = firstIndexReader.documents(i);
                IndexIterator indexIterator = secondIterator = !textTerm ? secondIndexReader.documents(i) : secondIndexReader.documents((CharSequence)RemoteIndexIteratorTest.firstIndex.termMap.list().get(i));
                while (firstIterator.hasNext()) {
                    firstIterator.next();
                    secondIterator.next();
                    IntIterator firstIntIt = firstIterator.positions();
                    IntIterator secondIntIt = secondIterator.positions();
                    while (firstIntIt.hasNext()) {
                        Assert.assertEquals((int)firstIntIt.nextInt(), (int)secondIntIt.nextInt());
                    }
                    Assert.assertEquals((int)firstIntIt.skip(2), (int)secondIntIt.skip(2));
                    if (firstIntIt.hasNext()) {
                        Assert.assertEquals((int)firstIntIt.nextInt(), (int)secondIntIt.nextInt());
                    }
                    Assert.assertEquals((int)firstIntIt.skip(9999999), (int)secondIntIt.skip(9999999));
                    if (!firstIntIt.hasNext()) continue;
                    Assert.assertEquals((int)firstIntIt.nextInt(), (int)secondIntIt.nextInt());
                }
                firstIterator = firstIndexReader.documents(i);
                IndexIterator indexIterator2 = secondIterator = !textTerm ? secondIndexReader.documents(i) : secondIndexReader.documents((CharSequence)RemoteIndexIteratorTest.firstIndex.termMap.list().get(i));
                while (firstIterator.hasNext()) {
                    firstIterator.next();
                    secondIterator.next();
                    IntervalIterator firstIntervalIt = firstIterator.intervalIterator(firstIndex);
                    IntervalIterator secondIntervalIt = secondIterator.intervalIterator(secondIndex);
                    while (firstIntervalIt.hasNext()) {
                        Interval firstIntv = firstIntervalIt.nextInterval();
                        Interval secondIntv = secondIntervalIt.nextInterval();
                        System.out.println("left:" + firstIntv.left + "   " + "right:" + firstIntv.right);
                        Assert.assertEquals((int)firstIntv.left, (int)secondIntv.left);
                        Assert.assertEquals((int)firstIntv.right, (int)secondIntv.right);
                    }
                }
                continue;
            }
            catch (AssertionError ae) {
                System.out.println("Error on Term:" + i);
                ((Throwable)((Object)ae)).printStackTrace();
            }
        }
    }

    public static void main(String[] arg) throws FileNotFoundException, IOException, ClassNotFoundException, IllegalArgumentException, SecurityException, IllegalAccessException, JSAPException, URISyntaxException, ConfigurationException, InterruptedException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        String[] debugServerArg = new String("/home/alex/develop/MG4J/alex/sample/DOCS-text mg4j://localhost:9090").split(" ");
        String[] debugClusterArg = new String("-t /home/alex/develop/MG4J/alex/sample/DOCS-text /home/alex/develop/MG4J/alex/sample/DOCS-split").split(" ");
        SimpleJSAP jsap = new SimpleJSAP("java IndexIteratorTest", "Compare IndexIterator of equals indexes.\nGiven two index basename, IndexIteratorTest compare that every IndexIterator method give the same results.", new Parameter[]{new UnflaggedOption("basename_1", (StringParser)JSAP.STRING_PARSER, true, "The basename of the first index."), new Switch("text_term", 't', "use text term during document method invocation on second index"), new UnflaggedOption("basename_2", (StringParser)JSAP.STRING_PARSER, true, "The basename of the second index.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (!jsapResult.contains("basename_1") || !jsapResult.contains("basename_2")) {
            return;
        }
        firstBaseName = jsapResult.getString("basename_1");
        secondBaseName = jsapResult.getString("basename_2");
        firstIndex = DiskBasedIndex.getInstance(firstBaseName, true, true);
        textTerm = jsapResult.getBoolean("text_term");
        secondIndex = Index.getInstance(secondBaseName);
        long startTime = System.currentTimeMillis();
        RemoteIndexIteratorTest.testIndexIterator();
        long endTime = System.currentTimeMillis();
        System.out.println("Test terminate succesfully in:" + (endTime - startTime) / 1000L + " sec.");
    }

    static {
        textTerm = false;
    }
}

