/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public final class ProduceDNFFromLines {
    private static final Logger LOGGER = Util.getLogger(ProduceDNFFromLines.class);

    private ProduceDNFFromLines() {
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        int t;
        int j;
        int q;
        int i;
        SimpleJSAP jsap = new SimpleJSAP(ProduceDNFFromLines.class.getName(), "Prints or selects parts of a stat file using global counts.", new Parameter[]{new UnflaggedOption("numberOfDocuments", (StringParser)JSAP.INTEGER_PARSER, true, "The number of documents."), new FlaggedOption("queries", (StringParser)JSAP.INTEGER_PARSER, "1", false, 'q', "queries", "The number of queries to be produced."), new FlaggedOption("docperquery", (StringParser)JSAP.INTEGER_PARSER, "2", false, 'd', "docperquery", "The number of documents per query."), new FlaggedOption("wordsperdoc", (StringParser)JSAP.INTEGER_PARSER, "2", false, 'w', "words", "The (maximum) number of words per document.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int numberOfDocuments = jsapResult.getInt("numberOfDocuments");
        int queries = jsapResult.getInt("queries");
        int docperquery = jsapResult.getInt("docperquery");
        int wordsperdoc = jsapResult.getInt("wordsperdoc");
        if (docperquery > numberOfDocuments) {
            System.err.println("There are not enough documents for the number of documents/query required");
            System.exit(1);
        }
        int[] docs = new int[numberOfDocuments];
        int[][] docForQuery = new int[queries][docperquery];
        String[][][] query = new String[queries][docperquery][wordsperdoc];
        int[] coveredForQuery = new int[queries];
        int maxDoc = 0;
        boolean[] used = new boolean[numberOfDocuments];
        for (i = 0; i < numberOfDocuments; ++i) {
            docs[i] = i;
        }
        for (q = 0; q < queries; ++q) {
            for (i = 0; i < docperquery; ++i) {
                j = i + (int)((double)(numberOfDocuments - i) * Math.random());
                t = docs[i];
                docs[i] = docs[j];
                docs[j] = t;
                docForQuery[q][i] = docs[i];
                used[docs[i]] = true;
                if (docs[i] <= maxDoc) continue;
                maxDoc = docs[i];
            }
            Arrays.sort(docForQuery[q]);
        }
        int[] words = new int[1024];
        FastBufferedReader reader = new FastBufferedReader((Reader)new InputStreamReader(System.in, "UTF-8"));
        int lineNumber = 0;
        int numberOfPartialQueries = queries;
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.itemsName = "Klines";
        pl.expectedUpdates = maxDoc / 1000;
        pl.start((CharSequence)"Generating queries...");
        MutableString line = new MutableString();
        while (reader.readLine(line) != null && numberOfPartialQueries > 0) {
            if (used[lineNumber]) {
                for (q = 0; q < queries; ++q) {
                    if (coveredForQuery[q] >= docperquery || docForQuery[q][coveredForQuery[q]] != lineNumber) continue;
                    String[] split = line.toString().split(" ");
                    int nw = split.length;
                    words = IntArrays.ensureCapacity((int[])words, (int)(nw + 1));
                    for (i = 0; i < nw; ++i) {
                        words[i] = i;
                    }
                    for (i = 0; i < Math.min(wordsperdoc, nw); ++i) {
                        j = i + (int)((double)(nw - i) * Math.random());
                        t = words[i];
                        words[i] = words[j];
                        words[j] = t;
                        query[q][coveredForQuery[q]][i] = split[words[i]];
                    }
                    int n = q;
                    coveredForQuery[n] = coveredForQuery[n] + 1;
                    if (coveredForQuery[q] != docperquery) continue;
                    --numberOfPartialQueries;
                }
            }
            if (++lineNumber % 1000 != 0) continue;
            pl.update();
        }
        pl.done();
        MutableString[] p = new MutableString[Math.max(queries, wordsperdoc)];
        MutableString s = new MutableString();
        for (i = 0; i < p.length; ++i) {
            p[i] = new MutableString();
        }
        for (q = 0; q < queries; ++q) {
            for (int d = 0; d < wordsperdoc; ++d) {
                int last;
                for (last = 0; last < wordsperdoc && query[q][d][last] != null; ++last) {
                }
                p[d].replace('(').append(query[q][d], 0, last, (CharSequence)" AND ").append(')');
            }
            System.out.println(s.length(0).append((CharSequence[])p, 0, queries, (CharSequence)" OR "));
        }
        ArrayList<String> l = new ArrayList<String>();
        String[] emptyArray = new String[]{};
        for (q = 0; q < queries; ++q) {
            for (int w = 0; w < wordsperdoc; ++w) {
                l.clear();
                for (int d = 0; d < wordsperdoc; ++d) {
                    if (query[q][d][w] == null) continue;
                    l.add(query[q][d][w]);
                }
                p[w].replace('(').append((CharSequence[])l.toArray(emptyArray), (CharSequence)" OR ").append(')');
            }
            System.err.println(s.length(0).append((CharSequence[])p, 0, wordsperdoc, (CharSequence)" AND "));
        }
    }
}

