/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.test;

import it.unimi.dsi.bits.Fast;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

class DrawPanel
extends JPanel {
    static final int SS = 15;
    int q;
    int h;
    int cache;
    int b;

    DrawPanel() {
    }

    void setValues(int q, int h, int cache) {
        if (cache > (1 << h) * q) {
            throw new IllegalArgumentException("Maximum cache size: " + this.b);
        }
        this.q = q;
        this.h = h;
        this.cache = cache;
        this.b = (1 << h) * q;
    }

    private void paintSquare(Graphics g, int i, int h, boolean exists) {
        int x = this.getWidth();
        int y = this.getHeight();
        int xcenter = x / 2 - this.b * 15 / 2 + i * 15;
        int ycenter = 2 * y / 3 - (h + 1) * 15;
        if (exists) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(Color.YELLOW);
        }
        g.fill3DRect(xcenter - 7 + 1, ycenter - 7 + 1, 13, 13, false);
    }

    private void drawLine(Graphics g, int i, int h, int jt, Color c) {
        int x = this.getWidth();
        int y = this.getHeight();
        int xi = x / 2 - this.b * 15 / 2 + i * 15;
        int xjt = x / 2 - this.b * 15 / 2 + jt * 15;
        int yy = 2 * y / 3 - (h + 1) * 15;
        g.setColor(c);
        g.drawLine(xi, yy, xjt, yy);
        g.fillOval(xi - 2, yy - 2, 4, 4);
        g.fillOval(xjt - 2, yy - 2, 4, 4);
    }

    public void paint(Graphics g) {
        g.clearRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        for (int i = 0; i < this.b; ++i) {
            this.paintSquare(g, i, -1, i < this.cache);
        }
        for (int passage = 0; passage < 2; ++passage) {
            for (int kq = 0; kq < this.b; ++kq) {
                int nextAfter = (this.cache + this.q - 1) / this.q;
                if (kq % this.q != 0) continue;
                int k = kq / this.q;
                int st = k == 0 ? this.h : Fast.leastSignificantBit((long)k);
                int s = st;
                if (this.cache < this.b) {
                    s = Math.min(s, Fast.mostSignificantBit((int)(this.cache / this.q - k)));
                }
                for (int hh = 0; hh <= st; ++hh) {
                    if (passage == 1) {
                        this.paintSquare(g, kq, hh, hh <= s && kq < this.cache);
                        continue;
                    }
                    if (hh > s || kq >= this.cache) continue;
                    int pt = k + (1 << hh);
                    int p = Math.min(pt, nextAfter);
                    if (p < pt) {
                        this.drawLine(g, kq, hh, pt * this.q, Color.WHITE);
                        System.out.println("From " + kq + " (skip index " + k + ") at height " + hh + "(2^h=" + (1 << hh) + ") should go to " + pt + " but goes to " + p + " instead");
                    }
                    this.drawLine(g, kq, hh, p * this.q, Color.BLUE);
                }
            }
        }
    }
}

