/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.lang.FlyweightPrototype;
import it.unimi.dsi.lang.FlyweightPrototypes;
import it.unimi.dsi.mg4j.search.score.AbstractAggregator;
import it.unimi.dsi.mg4j.search.score.Scorer;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class LinearAggregator
extends AbstractAggregator {
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = Util.getLogger(LinearAggregator.class);
    protected final double[] weight;
    protected final double[] equalisationFactor;

    public LinearAggregator(Scorer[] scorer, double[] weight) {
        super(scorer);
        if (scorer.length != weight.length) {
            throw new IllegalArgumentException();
        }
        this.weight = (double[])weight.clone();
        this.equalisationFactor = new double[this.n];
    }

    public synchronized LinearAggregator copy() {
        LinearAggregator linearCombinationScorer = new LinearAggregator((Scorer[])FlyweightPrototypes.copy((FlyweightPrototype[])this.scorer), (double[])this.weight.clone());
        linearCombinationScorer.equalize(this.samples);
        return linearCombinationScorer;
    }

    protected double score(double[] score) {
        double total = 0.0;
        int i = this.n;
        while (i-- != 0) {
            total += this.weight[i] * score[i] / this.equalisationFactor[i];
        }
        return total;
    }

    protected void setupEqualizationFactors() {
        if (this.samples == 0) {
            DoubleArrays.fill((double[])this.equalisationFactor, (double)1.0);
        } else {
            double[][] sampleScore = this.sampleScore;
            int i = this.n;
            while (i-- != 0) {
                double m = 0.0;
                int j = this.actualSamples;
                while (j-- != 0) {
                    if (!(m < sampleScore[j][i])) continue;
                    m = sampleScore[j][i];
                }
                this.equalisationFactor[i] = m == 0.0 ? 1.0 : m;
            }
        }
        LOGGER.debug((Object)("Equalisation factors: " + Arrays.toString(this.equalisationFactor)));
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getName()).append('(');
        for (int i = 0; i < this.scorer.length; ++i) {
            if (i != 0) {
                s.append("; ");
            }
            s.append(this.scorer[i].toString()).append(":").append(this.weight[i]);
        }
        return s.append(')').toString();
    }
}

