/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.AbstractOrderedIntervalDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterators;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.NotDocumentIterator;
import it.unimi.dsi.util.Interval;
import it.unimi.dsi.util.Intervals;
import java.io.IOException;

public class OrderedAndDocumentIterator
extends AbstractOrderedIntervalDocumentIterator {
    private static final boolean ASSERTS = false;

    public static DocumentIterator getInstance(int numberOfDocuments, DocumentIterator ... documentIterator) throws IOException {
        if (documentIterator.length == 0) {
            return NotDocumentIterator.getInstance(DocumentIterators.EMPTY_ITERATOR, numberOfDocuments);
        }
        if (documentIterator.length == 1) {
            return documentIterator[0];
        }
        return new OrderedAndDocumentIterator(documentIterator);
    }

    public static DocumentIterator getInstance(DocumentIterator ... documentIterator) throws IOException {
        if (documentIterator.length == 0) {
            throw new IllegalArgumentException();
        }
        return OrderedAndDocumentIterator.getInstance(-1, documentIterator);
    }

    protected OrderedAndDocumentIterator(DocumentIterator[] documentIterator) throws IOException {
        super(documentIterator);
    }

    protected IntervalIterator getComposedIntervalIterator(Index unused) {
        return this.indexIterator == null ? new OrderedAndIntervalIterator() : new OrderedAndIndexIntervalIterator();
    }

    private class OrderedAndIndexIntervalIterator
    extends AbstractOrderedIntervalDocumentIterator.AbstractOrderedIndexIntervalIterator {
        private boolean endOfProcess;
        private int toBeAligned;

        private OrderedAndIndexIntervalIterator() {
        }

        public void reset() throws IOException {
            int[][] position = this.position;
            int[] curr = this.curr;
            int[] count = this.count;
            IntArrays.fill((int[])this.currPos, (int)-1);
            int i = OrderedAndDocumentIterator.this.n;
            while (i-- != 0) {
                count[i] = OrderedAndDocumentIterator.this.indexIterator[i].count();
                position[i] = OrderedAndDocumentIterator.this.indexIterator[i].positionArray();
                curr[i] = Integer.MIN_VALUE;
            }
            this.next = null;
            this.toBeAligned = 1;
            this.endOfProcess = false;
            this.currPos[0] = 0;
            curr[0] = position[0][0];
        }

        public void intervalTerms(IntSet terms) {
            int i = OrderedAndDocumentIterator.this.n;
            while (i-- != 0) {
                terms.add(OrderedAndDocumentIterator.this.indexIterator[i].termNumber());
            }
        }

        public Interval nextInterval() {
            if (this.next != null) {
                Interval result = this.next;
                this.next = null;
                return result;
            }
            if (this.endOfProcess) {
                return null;
            }
            int nextLeft = Integer.MAX_VALUE;
            int nextRight = 0x7FFFFFFE;
            int[][] position = this.position;
            int[] currPos = this.currPos;
            int[] count = this.count;
            int[] curr = this.curr;
            int n = OrderedAndDocumentIterator.this.n;
            int i = this.toBeAligned;
            while (true) {
                if (curr[i - 1] >= nextRight - (n - i - 1)) {
                    this.toBeAligned = i;
                    return Interval.valueOf((int)nextLeft, (int)nextRight);
                }
                if (i != n && curr[i] <= curr[i - 1]) {
                    do {
                        int n2 = i;
                        currPos[n2] = currPos[n2] + 1;
                        if (currPos[n2] == count[i]) {
                            this.endOfProcess = true;
                            return nextLeft == Integer.MAX_VALUE ? null : Interval.valueOf((int)nextLeft, (int)nextRight);
                        }
                        curr[i] = position[i][currPos[i]];
                    } while (curr[i] <= curr[i - 1]);
                    ++i;
                    continue;
                }
                nextLeft = curr[0];
                nextRight = curr[n - 1];
                i = 1;
                currPos[0] = currPos[0] + 1;
                if (currPos[0] == count[0]) {
                    this.endOfProcess = true;
                    return Interval.valueOf((int)nextLeft, (int)nextRight);
                }
                curr[0] = position[0][currPos[0]];
            }
        }
    }

    private class OrderedAndIntervalIterator
    extends AbstractOrderedIntervalDocumentIterator.AbstractOrderedIntervalIterator {
        private static final boolean DEBUG = false;
        private boolean endOfProcess;
        private int toBeAligned;
        private int m;

        private OrderedAndIntervalIterator() {
        }

        public void reset() throws IOException {
            this.m = 0;
            this.next = null;
            this.toBeAligned = 1;
            this.endOfProcess = false;
            for (int i = 0; i < OrderedAndDocumentIterator.this.n; ++i) {
                this.intervalIterator[this.m] = OrderedAndDocumentIterator.this.documentIterator[i].intervalIterator();
                if (this.intervalIterator[this.m] == IntervalIterators.TRUE) continue;
                this.curr[this.m++] = Intervals.MINUS_INFINITY;
            }
            if (this.m == 0) {
                throw new IllegalStateException();
            }
            this.curr[0] = this.intervalIterator[0].nextInterval();
            this.endOfProcess = this.curr[0] == null;
        }

        public void intervalTerms(IntSet terms) {
            int i = OrderedAndDocumentIterator.this.n;
            while (i-- != 0) {
                this.intervalIterator[i].intervalTerms(terms);
            }
        }

        public Interval nextInterval() throws IOException {
            if (this.next != null) {
                Interval result = this.next;
                this.next = null;
                return result;
            }
            if (this.endOfProcess) {
                return null;
            }
            Interval[] curr = this.curr;
            IntervalIterator[] intervalIterator = this.intervalIterator;
            int m = this.m;
            int nextLeft = Integer.MAX_VALUE;
            int nextRight = Integer.MAX_VALUE;
            int leftOfLast = 0x7FFFFFFE;
            int i = this.toBeAligned;
            while (true) {
                if (curr[i - 1].right >= leftOfLast - (m - i - 1)) {
                    this.toBeAligned = i;
                    return Interval.valueOf((int)nextLeft, (int)nextRight);
                }
                if (i != m && curr[i].left <= curr[i - 1].right) {
                    do {
                        if (curr[i].right < leftOfLast - (m - i - 2) && (curr[i] = intervalIterator[i].nextInterval()) != null) continue;
                        this.toBeAligned = i;
                        this.endOfProcess = curr[i] == null;
                        return nextLeft == Integer.MAX_VALUE ? null : Interval.valueOf((int)nextLeft, (int)nextRight);
                    } while (curr[i].left <= curr[i - 1].right);
                    ++i;
                    continue;
                }
                nextLeft = curr[0].left;
                nextRight = curr[m - 1].right;
                leftOfLast = curr[m - 1].left;
                i = 1;
                curr[0] = intervalIterator[0].nextInterval();
                if (curr[0] == null) break;
            }
            this.endOfProcess = true;
            this.toBeAligned = 1;
            return Interval.valueOf((int)nextLeft, (int)nextRight);
        }

        public int extent() {
            int s = 0;
            int i = this.m;
            while (i-- != 0) {
                s += this.intervalIterator[i].extent();
            }
            return s;
        }
    }
}

