/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import it.unimi.dsi.util.Interval;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LowPassDocumentIterator
extends AbstractDocumentIterator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    private final DocumentIterator documentIterator;
    private final Index soleIndex;
    protected final int threshold;
    private final Reference2ReferenceArrayMap<Index, IntervalIterator> intervalIterators;
    private final Reference2ReferenceArrayMap<Index, IntervalIterator> currentIterators;
    private final Reference2ReferenceMap<Index, IntervalIterator> unmodifiableCurrentIterators;

    protected LowPassDocumentIterator(DocumentIterator documentIterator, int threshold) {
        this.documentIterator = documentIterator;
        this.threshold = threshold;
        int n = documentIterator.indices().size();
        this.soleIndex = n == 1 ? (Index)this.indices().iterator().next() : null;
        this.intervalIterators = new Reference2ReferenceArrayMap(n);
        this.currentIterators = new Reference2ReferenceArrayMap(n);
        this.unmodifiableCurrentIterators = Reference2ReferenceMaps.unmodifiable(this.currentIterators);
    }

    public static LowPassDocumentIterator getInstance(DocumentIterator it, int threshold) {
        return new LowPassDocumentIterator(it, threshold);
    }

    @Override
    public ReferenceSet<Index> indices() {
        return this.documentIterator.indices();
    }

    @Override
    public int nextDocument() throws IOException {
        if (this.next >= 0) {
            this.last = this.next;
            this.next = -1;
            return this.last;
        }
        do {
            this.currentIterators.clear();
        } while ((this.last = this.documentIterator.nextDocument()) != -1 && !this.isValid());
        return this.last;
    }

    @Override
    public int skipTo(int n) throws IOException {
        if (this.last >= n) {
            return this.last;
        }
        this.next = -1;
        this.last = -1;
        this.currentIterators.clear();
        int res = this.documentIterator.skipTo(n);
        if (res == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        this.last = res;
        if (this.isValid()) {
            return res;
        }
        return this.nextDocument() != -1 ? this.last : Integer.MAX_VALUE;
    }

    private boolean isValid() throws IOException {
        if (this.soleIndex == null) {
            return this.intervalIterator(this.soleIndex).hasNext();
        }
        for (Index index : this.indices()) {
            if (!this.intervalIterator(index).hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
        ObjectIterator i = this.indices().iterator();
        while (i.hasNext()) {
            this.intervalIterator((Index)i.next());
        }
        return this.unmodifiableCurrentIterators;
    }

    @Override
    public IntervalIterator intervalIterator() throws IOException {
        if (this.soleIndex == null) {
            throw new IllegalStateException();
        }
        return this.intervalIterator(this.soleIndex);
    }

    @Override
    public IntervalIterator intervalIterator(Index index) throws IOException {
        if (this.last == -1) {
            throw new IllegalStateException();
        }
        if (!this.documentIterator.indices().contains((Object)index)) {
            return IntervalIterators.TRUE;
        }
        IntervalIterator intervalIterator = (IntervalIterator)this.currentIterators.get((Object)index);
        if (intervalIterator != null) {
            return intervalIterator;
        }
        intervalIterator = this.documentIterator.intervalIterator(index);
        if (intervalIterator != IntervalIterators.FALSE && intervalIterator != IntervalIterators.TRUE) {
            intervalIterator = (IntervalIterator)this.intervalIterators.get((Object)index);
            if (intervalIterator == null) {
                intervalIterator = new LowPassIntervalIterator(index);
                this.intervalIterators.put((Object)index, (Object)intervalIterator);
            }
            intervalIterator.reset();
        }
        this.currentIterators.put((Object)index, (Object)intervalIterator);
        return intervalIterator;
    }

    @Override
    public void dispose() throws IOException {
        this.documentIterator.dispose();
    }

    @Override
    public boolean accept(DocumentIteratorVisitor visitor) throws IOException {
        return visitor.visitPre(this) && this.documentIterator.accept(visitor) && visitor.visitPost(this);
    }

    @Override
    public boolean acceptOnTruePaths(DocumentIteratorVisitor visitor) throws IOException {
        return visitor.visitPre(this) && this.documentIterator.acceptOnTruePaths(visitor) && visitor.visitPost(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.documentIterator + ", " + this.threshold + ")";
    }

    private class LowPassIntervalIterator
    extends AbstractDocumentIterator.AbstractIntervalIterator
    implements IntervalIterator {
        final Index index;
        private IntervalIterator intervalIterator;

        public LowPassIntervalIterator(Index index) {
            this.index = index;
        }

        public void reset() throws IOException {
            this.next = null;
            this.intervalIterator = LowPassDocumentIterator.this.documentIterator.intervalIterator(this.index);
        }

        public void intervalTerms(IntSet terms) {
            this.intervalIterator.intervalTerms(terms);
        }

        public Interval nextInterval() throws IOException {
            Interval result;
            if (this.next != null) {
                Interval result2 = this.next;
                this.next = null;
                return result2;
            }
            while ((result = this.intervalIterator.nextInterval()) != null && result.length() > LowPassDocumentIterator.this.threshold) {
            }
            return result;
        }

        public int extent() {
            return Math.min(this.intervalIterator.extent(), LowPassDocumentIterator.this.threshold);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.intervalIterator + ", " + LowPassDocumentIterator.this.threshold + ")";
        }
    }
}

