/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import it.unimi.dsi.util.Interval;
import it.unimi.dsi.util.Intervals;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceDocumentIterator
extends AbstractDocumentIterator
implements DocumentIterator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    private final DocumentIterator minuendIterator;
    private final DocumentIterator subtrahendIterator;
    private final Index soleIndex;
    private final Reference2ReferenceArrayMap<Index, IntervalIterator> intervalIterators;
    private final Reference2ReferenceArrayMap<Index, IntervalIterator> currentIterators;
    private final Reference2ReferenceMap<Index, IntervalIterator> unmodifiableCurrentIterators;
    private final int leftMargin;
    private final int rightMargin;

    protected DifferenceDocumentIterator(DocumentIterator minuendIterator, DocumentIterator subtrahendIterator, int leftMargin, int rightMargin) {
        if (leftMargin < 0 || rightMargin < 0) {
            throw new IllegalArgumentException("Illegal margins: " + leftMargin + ", " + rightMargin);
        }
        this.minuendIterator = minuendIterator;
        this.subtrahendIterator = subtrahendIterator;
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        int n = minuendIterator.indices().size();
        this.soleIndex = n == 1 ? (Index)this.indices().iterator().next() : null;
        this.intervalIterators = new Reference2ReferenceArrayMap(n);
        this.currentIterators = new Reference2ReferenceArrayMap(n);
        this.unmodifiableCurrentIterators = Reference2ReferenceMaps.unmodifiable(this.currentIterators);
    }

    public static DocumentIterator getInstance(DocumentIterator minuendIterator, DocumentIterator subtrahendIterator) {
        return DifferenceDocumentIterator.getInstance(minuendIterator, subtrahendIterator, 0, 0);
    }

    public static DocumentIterator getInstance(DocumentIterator minuendIterator, DocumentIterator subtrahendIterator, int leftMargin, int rightMargin) {
        if (!subtrahendIterator.hasNext()) {
            return minuendIterator;
        }
        return new DifferenceDocumentIterator(minuendIterator, subtrahendIterator, leftMargin, rightMargin);
    }

    @Override
    public ReferenceSet<Index> indices() {
        return this.minuendIterator.indices();
    }

    @Override
    public int nextDocument() throws IOException {
        if (this.next >= 0) {
            this.last = this.next;
            this.next = -1;
            return this.last;
        }
        do {
            this.currentIterators.clear();
        } while ((this.last = this.minuendIterator.nextDocument()) != -1 && !this.isValid());
        return this.last;
    }

    @Override
    public int skipTo(int n) throws IOException {
        if (this.last >= n) {
            return this.last;
        }
        this.next = -1;
        this.currentIterators.clear();
        this.last = this.minuendIterator.skipTo(n);
        if (this.last == Integer.MAX_VALUE) {
            this.last = -1;
            return Integer.MAX_VALUE;
        }
        if (this.isValid()) {
            return this.last;
        }
        return this.nextDocument() != -1 ? this.last : Integer.MAX_VALUE;
    }

    private boolean isValid() throws IOException {
        if (this.subtrahendIterator.skipTo(this.last) != this.last) {
            return true;
        }
        if (this.soleIndex != null) {
            return this.intervalIterator(this.soleIndex).hasNext();
        }
        for (Index index : this.indices()) {
            if (!this.intervalIterator(index).hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
        if (this.last == -1) {
            throw new IllegalStateException();
        }
        for (Index index : this.indices()) {
            this.intervalIterator(index);
        }
        return this.unmodifiableCurrentIterators;
    }

    @Override
    public IntervalIterator intervalIterator() throws IOException {
        if (this.soleIndex == null) {
            throw new IllegalStateException();
        }
        return this.intervalIterator(this.soleIndex);
    }

    @Override
    public IntervalIterator intervalIterator(Index index) throws IOException {
        IntervalIterator subtrahendIntervalIterator;
        if (this.last == -1) {
            throw new IllegalStateException();
        }
        if (!this.minuendIterator.indices().contains((Object)index)) {
            return IntervalIterators.TRUE;
        }
        IntervalIterator intervalIterator = (IntervalIterator)this.currentIterators.get((Object)index);
        if (intervalIterator != null) {
            return intervalIterator;
        }
        intervalIterator = this.minuendIterator.intervalIterator(index);
        if (this.subtrahendIterator.document() == this.minuendIterator.document() && intervalIterator.hasNext() && (subtrahendIntervalIterator = this.subtrahendIterator.intervalIterator(index)).hasNext()) {
            if (subtrahendIntervalIterator == IntervalIterators.TRUE) {
                intervalIterator = IntervalIterators.FALSE;
            } else if (intervalIterator != IntervalIterators.TRUE) {
                intervalIterator = (IntervalIterator)this.intervalIterators.get((Object)index);
                if (intervalIterator == null) {
                    intervalIterator = new DifferenceIntervalIterator(index);
                    this.intervalIterators.put((Object)index, (Object)intervalIterator);
                }
                intervalIterator.reset();
            }
        }
        this.currentIterators.put((Object)index, (Object)intervalIterator);
        return intervalIterator;
    }

    @Override
    public void dispose() throws IOException {
        this.minuendIterator.dispose();
        this.subtrahendIterator.dispose();
    }

    @Override
    public boolean accept(DocumentIteratorVisitor visitor) throws IOException {
        return visitor.visitPre(this) && this.minuendIterator.accept(visitor) && this.subtrahendIterator.accept(visitor) && visitor.visitPost(this);
    }

    @Override
    public boolean acceptOnTruePaths(DocumentIteratorVisitor visitor) throws IOException {
        return visitor.visitPre(this) && this.minuendIterator.acceptOnTruePaths(visitor) && visitor.visitPost(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.minuendIterator + (this.leftMargin == 0 && this.rightMargin == 0 ? " - " : " -[" + this.leftMargin + "," + this.rightMargin + "] ") + this.subtrahendIterator + ")";
    }

    private class DifferenceIntervalIterator
    extends AbstractDocumentIterator.AbstractIntervalIterator
    implements IntervalIterator {
        final Index index;
        private IntervalIterator minuendIntervalIterator;
        private IntervalIterator subtrahendIntervalIterator;
        private Interval subtrahendInterval;

        public DifferenceIntervalIterator(Index index) {
            this.index = index;
        }

        public void reset() throws IOException {
            this.next = null;
            this.subtrahendInterval = Intervals.MINUS_INFINITY;
            this.minuendIntervalIterator = DifferenceDocumentIterator.this.minuendIterator.intervalIterator(this.index);
            this.subtrahendIntervalIterator = DifferenceDocumentIterator.this.subtrahendIterator.intervalIterator(this.index);
        }

        public void intervalTerms(IntSet terms) {
            this.minuendIntervalIterator.intervalTerms(terms);
        }

        public Interval nextInterval() throws IOException {
            Interval minuendInterval;
            if (this.next != null) {
                Interval result = this.next;
                this.next = null;
                return result;
            }
            if (this.subtrahendInterval == Intervals.MINUS_INFINITY) {
                this.subtrahendInterval = this.subtrahendIntervalIterator.nextInterval();
            }
            while ((minuendInterval = this.minuendIntervalIterator.nextInterval()) != null) {
                while (this.subtrahendInterval != null && this.subtrahendInterval.left - DifferenceDocumentIterator.this.leftMargin < minuendInterval.left && this.subtrahendInterval.right + DifferenceDocumentIterator.this.rightMargin < minuendInterval.right) {
                    this.subtrahendInterval = this.subtrahendIntervalIterator.nextInterval();
                }
                if (this.subtrahendInterval != null && this.subtrahendInterval.left - DifferenceDocumentIterator.this.leftMargin >= minuendInterval.left && this.subtrahendInterval.right + DifferenceDocumentIterator.this.rightMargin <= minuendInterval.right) continue;
                return minuendInterval;
            }
            return null;
        }

        public int extent() {
            return this.minuendIntervalIterator.extent();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.minuendIntervalIterator + (DifferenceDocumentIterator.this.leftMargin == 0 && DifferenceDocumentIterator.this.rightMargin == 0 ? " - " : " -[" + DifferenceDocumentIterator.this.leftMargin + "," + DifferenceDocumentIterator.this.rightMargin + "] ") + this.subtrahendIntervalIterator + ")";
        }
    }
}

