/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.AbstractOrderedIntervalDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterators;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.NotDocumentIterator;
import it.unimi.dsi.util.Interval;
import it.unimi.dsi.util.Intervals;
import java.io.IOException;

public class ConsecutiveDocumentIterator
extends AbstractOrderedIntervalDocumentIterator {
    private final int[] gap;

    public static DocumentIterator getInstance(int numberOfDocuments, DocumentIterator ... documentIterator) throws IOException {
        if (documentIterator.length == 0) {
            return NotDocumentIterator.getInstance(DocumentIterators.EMPTY_ITERATOR, numberOfDocuments);
        }
        if (documentIterator.length == 1) {
            return documentIterator[0];
        }
        return new ConsecutiveDocumentIterator(documentIterator, null);
    }

    public static DocumentIterator getInstance(DocumentIterator ... documentIterator) throws IOException {
        if (documentIterator.length == 1) {
            return documentIterator[0];
        }
        return ConsecutiveDocumentIterator.getInstance(-1, documentIterator);
    }

    public static DocumentIterator getInstance(DocumentIterator[] documentIterator, int[] gap) throws IOException {
        if (gap != null && gap.length != documentIterator.length) {
            throw new IllegalArgumentException("The number of gaps (" + gap.length + ") is not equal to the number of document iterators (" + documentIterator.length + ")");
        }
        if (documentIterator.length == 1 && (gap == null || gap[0] == 0)) {
            return documentIterator[0];
        }
        return new ConsecutiveDocumentIterator(documentIterator, gap);
    }

    protected ConsecutiveDocumentIterator(DocumentIterator[] documentIterator, int[] gap) throws IOException {
        super(documentIterator);
        this.gap = gap == null ? new int[this.n] : (int[])gap.clone();
    }

    protected IntervalIterator getComposedIntervalIterator(Index unused) {
        if (this.indexIterator == null) {
            return new ConsecutiveIntervalIterator(this.gap);
        }
        for (int i = 1; i < this.n; ++i) {
            int n = i;
            this.gap[n] = this.gap[n] + (this.gap[i - 1] + 1);
        }
        return new ConsecutiveIndexIntervalIterator(this.gap);
    }

    private class ConsecutiveIndexIntervalIterator
    extends AbstractOrderedIntervalDocumentIterator.AbstractOrderedIndexIntervalIterator {
        private final int[] gap;
        private boolean endOfProcess;

        public ConsecutiveIndexIntervalIterator(int[] gap) {
            this.gap = gap;
        }

        public void reset() throws IOException {
            int[][] position = this.position;
            int[] currPos = this.currPos;
            int[] curr = this.curr;
            int[] count = this.count;
            int[] gap = this.gap;
            IntArrays.fill((int[])currPos, (int)0);
            int i = ConsecutiveDocumentIterator.this.n;
            while (i-- != 0) {
                count[i] = ConsecutiveDocumentIterator.this.indexIterator[i].count();
                position[i] = ConsecutiveDocumentIterator.this.indexIterator[i].positionArray();
                curr[i] = position[i][0];
            }
            this.endOfProcess = false;
            i = ConsecutiveDocumentIterator.this.n;
            while (i-- != 0) {
                int n = i;
                curr[n] = curr[n] - gap[i];
            }
            if (gap[0] != 0) {
                this.next = null;
                while (curr[0] < 0 && (currPos[0] = currPos[0] + 1) < count[0]) {
                    curr[0] = position[0][currPos[0]] - gap[0];
                }
                boolean bl = this.endOfProcess = currPos[0] == count[0];
            }
            if (!this.endOfProcess) {
                this.next = this.align();
            }
        }

        public void intervalTerms(IntSet terms) {
            int i = ConsecutiveDocumentIterator.this.n;
            while (i-- != 0) {
                terms.add(ConsecutiveDocumentIterator.this.indexIterator[i].termNumber());
            }
        }

        private Interval align() {
            int[][] position = this.position;
            int[] currPos = this.currPos;
            int[] curr = this.curr;
            int[] count = this.count;
            int[] gap = this.gap;
            int k = 1;
            int l = ConsecutiveDocumentIterator.this.n <= 2 ? 0 : 2;
            boolean oneRoundDone = false;
            int start = curr[0];
            while (true) {
                int c;
                int[] p = position[k];
                for (c = currPos[k]; c < count[k] && p[c] - gap[k] < start; ++c) {
                }
                if (c == count[k]) {
                    this.endOfProcess = true;
                    return null;
                }
                currPos[k] = c;
                curr[k] = p[currPos[k]] - gap[k];
                if (curr[k] > start) {
                    start = curr[k];
                }
                if ((oneRoundDone |= k == 0) && curr[l] == start) {
                    return Interval.valueOf((int)curr[0], (int)(curr[0] + gap[ConsecutiveDocumentIterator.this.n - 1]));
                }
                k = l++;
                if (l != ConsecutiveDocumentIterator.this.n) continue;
                l = 0;
            }
        }

        public Interval nextInterval() {
            if (this.next != null) {
                Interval result = this.next;
                this.next = null;
                return result;
            }
            if (this.endOfProcess) {
                return null;
            }
            this.currPos[0] = this.currPos[0] + 1;
            if (this.currPos[0] >= this.count[0]) {
                this.endOfProcess = true;
                return null;
            }
            this.curr[0] = this.position[0][this.currPos[0]] - this.gap[0];
            return this.align();
        }
    }

    private class ConsecutiveIntervalIterator
    extends AbstractOrderedIntervalDocumentIterator.AbstractOrderedIntervalIterator {
        private final int[] gap;
        private final int[] actualGap;
        private boolean endOfProcess;
        private int m;

        public ConsecutiveIntervalIterator(int[] gap) {
            this.gap = gap;
            this.actualGap = new int[ConsecutiveDocumentIterator.this.n + 1];
        }

        public void reset() throws IOException {
            int[] actualGap = this.actualGap;
            int[] gap = this.gap;
            IntervalIterator[] intervalIterator = this.intervalIterator;
            this.m = 0;
            actualGap[0] = 0;
            for (int i = 0; i < ConsecutiveDocumentIterator.this.n; ++i) {
                intervalIterator[this.m] = ConsecutiveDocumentIterator.this.documentIterator[i].intervalIterator();
                int n = this.m;
                actualGap[n] = actualGap[n] + gap[i];
                this.curr[this.m] = Intervals.MINUS_INFINITY;
                if (intervalIterator[this.m] == IntervalIterators.TRUE) continue;
                actualGap[++this.m] = 1;
            }
            if (this.m == 0) {
                throw new IllegalStateException();
            }
            this.next = null;
            do {
                this.curr[0] = intervalIterator[0].nextInterval();
            } while (this.curr[0] != null && this.curr[0].left < actualGap[0]);
            this.endOfProcess = this.curr[0] == null;
            if (!this.endOfProcess) {
                this.next = this.align();
            }
        }

        public void intervalTerms(IntSet terms) {
            int i = this.m;
            while (i-- != 0) {
                this.intervalIterator[i].intervalTerms(terms);
            }
        }

        private Interval align() throws IOException {
            Interval[] curr = this.curr;
            int[] actualGap = this.actualGap;
            IntervalIterator[] intervalIterator = this.intervalIterator;
            int k = 0;
            block0: while (k < this.m) {
                for (k = 1; k < this.m; ++k) {
                    Interval interval;
                    while (curr[k].left < curr[k - 1].right + actualGap[k]) {
                        curr[k] = intervalIterator[k].nextInterval();
                        if (curr[k] != null) continue;
                        this.endOfProcess = true;
                        return null;
                    }
                    if (curr[k].left <= curr[k - 1].right + actualGap[k]) continue;
                    int limit = curr[k].left - actualGap[k];
                    while ((interval = intervalIterator[0].nextInterval()) != null && interval.right < limit) {
                    }
                    this.endOfProcess = interval == null;
                    if (this.endOfProcess) {
                        return null;
                    }
                    curr[0] = interval;
                    continue block0;
                }
            }
            return Interval.valueOf((int)(curr[0].left - actualGap[0]), (int)curr[this.m - 1].right);
        }

        public Interval nextInterval() throws IOException {
            if (this.next != null) {
                Interval result = this.next;
                this.next = null;
                return result;
            }
            if (this.endOfProcess) {
                return null;
            }
            this.curr[0] = this.intervalIterator[0].nextInterval();
            if (this.curr[0] == null) {
                this.endOfProcess = true;
                return null;
            }
            return this.align();
        }

        public int extent() {
            int s = 0;
            int i = this.m;
            while (i-- != 0) {
                s += this.intervalIterator[i].extent() + this.actualGap[i];
            }
            return s;
        }
    }
}

