/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import it.unimi.dsi.util.Interval;
import java.io.IOException;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingDocumentIterator
extends AbstractIntIterator
implements DocumentIterator {
    private final DocumentIterator documentIterator;
    private final Index soleIndex;
    private final Reference2ReferenceArrayMap<Index, CachingIntervalIterator> cachingIterators;
    private final Reference2ReferenceArrayMap<Index, IntervalIterator> currentIterators;
    private final Reference2ReferenceMap<Index, IntervalIterator> unmodifiableCurrentIterators;

    public CachingDocumentIterator(DocumentIterator documentIterator) {
        this.documentIterator = documentIterator;
        int n = documentIterator.indices().size();
        this.soleIndex = n == 1 ? (Index)this.indices().iterator().next() : null;
        this.currentIterators = new Reference2ReferenceArrayMap((Object[])new Index[n], (Object[])new IntervalIterator[n]);
        this.cachingIterators = new Reference2ReferenceArrayMap((Object[])new Index[n], (Object[])new CachingIntervalIterator[n]);
        this.unmodifiableCurrentIterators = Reference2ReferenceMaps.unmodifiable(this.currentIterators);
    }

    @Override
    public int document() {
        return this.documentIterator.document();
    }

    public boolean hasNext() {
        return this.documentIterator.hasNext();
    }

    @Override
    public ReferenceSet<Index> indices() {
        return this.documentIterator.indices();
    }

    @Override
    public IntervalIterator intervalIterator(Index index) throws IOException {
        if (!this.documentIterator.indices().contains((Object)index)) {
            return IntervalIterators.TRUE;
        }
        CachingIntervalIterator result = (CachingIntervalIterator)this.cachingIterators.get((Object)index);
        if (this.currentIterators.containsKey((Object)index)) {
            result.restart();
            return result;
        }
        IntervalIterator intervalIterator = this.documentIterator.intervalIterator(index);
        if (intervalIterator == IntervalIterators.TRUE || !intervalIterator.hasNext()) {
            return intervalIterator;
        }
        if (result == null) {
            result = new CachingIntervalIterator();
            this.cachingIterators.put((Object)index, (Object)result);
        }
        result.wrap(intervalIterator);
        result.reset();
        this.currentIterators.put((Object)index, (Object)result);
        return result;
    }

    @Override
    public IntervalIterator intervalIterator() throws IOException {
        if (this.soleIndex == null) {
            throw new IllegalStateException();
        }
        return this.intervalIterator(this.soleIndex);
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
        for (Index i : this.indices()) {
            this.intervalIterator(i);
        }
        return this.unmodifiableCurrentIterators;
    }

    @Override
    public int nextDocument() throws IOException {
        this.currentIterators.clear();
        return this.documentIterator.nextDocument();
    }

    @Override
    public int nextInt() {
        this.currentIterators.clear();
        return this.nextInt();
    }

    @Override
    public int skipTo(int n) throws IOException {
        this.currentIterators.clear();
        return this.documentIterator.skipTo(n);
    }

    @Override
    public void dispose() throws IOException {
        this.documentIterator.dispose();
    }

    @Override
    public boolean accept(DocumentIteratorVisitor visitor) throws IOException {
        return this.documentIterator.accept(visitor);
    }

    @Override
    public boolean acceptOnTruePaths(DocumentIteratorVisitor visitor) throws IOException {
        return this.documentIterator.acceptOnTruePaths(visitor);
    }

    @Override
    public IntervalIterator iterator() {
        try {
            return this.intervalIterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CachingIntervalIterator
    extends AbstractObjectIterator<Interval>
    implements IntervalIterator {
        private final ObjectArrayList<Interval> cachedIntervals = new ObjectArrayList();
        private IntervalIterator intervalIterator;
        private int pos = 0;

        private CachingIntervalIterator() {
        }

        public void wrap(IntervalIterator intervalIterator) {
            this.intervalIterator = intervalIterator;
        }

        @Override
        public int extent() {
            return this.intervalIterator.extent();
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.cachedIntervals.size() || this.intervalIterator.hasNext();
        }

        @Override
        @Deprecated
        public Interval next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.pos < this.cachedIntervals.size()) {
                return (Interval)this.cachedIntervals.get(this.pos++);
            }
            Interval next = this.intervalIterator.next();
            this.cachedIntervals.add((Object)next);
            ++this.pos;
            return next;
        }

        @Override
        public Interval nextInterval() throws IOException {
            if (this.pos < this.cachedIntervals.size()) {
                return (Interval)this.cachedIntervals.get(this.pos++);
            }
            Interval next = this.intervalIterator.nextInterval();
            if (next == null) {
                return null;
            }
            this.cachedIntervals.add((Object)next);
            ++this.pos;
            return next;
        }

        @Override
        public void reset() {
            this.cachedIntervals.clear();
            this.restart();
        }

        public void restart() {
            this.pos = 0;
        }

        @Override
        public void intervalTerms(IntSet terms) {
            throw new UnsupportedOperationException("This should be implemented!");
        }
    }
}

