/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.IntHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.AbstractCompositeDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUnionDocumentIterator
extends AbstractCompositeDocumentIterator {
    private static final boolean DEBUG = false;
    protected final IntHeapSemiIndirectPriorityQueue queue;
    protected final int[] front;
    protected final int[] curr = new int[this.n];
    private final Reference2ReferenceArrayMap<Index, IntervalIterator> intervalIterators;
    private final Reference2ReferenceArrayMap<Index, IntervalIterator> currentIterators;
    private final Reference2ReferenceMap<Index, IntervalIterator> unmodifiableCurrentIterators;
    protected int frontSize = -1;

    protected AbstractUnionDocumentIterator(DocumentIterator ... documentIterator) throws IOException {
        super(documentIterator);
        this.queue = new IntHeapSemiIndirectPriorityQueue(this.curr);
        this.intervalIterators = new Reference2ReferenceArrayMap(this.indices.size());
        this.currentIterators = new Reference2ReferenceArrayMap(this.indices.size());
        this.unmodifiableCurrentIterators = Reference2ReferenceMaps.unmodifiable(this.currentIterators);
        for (int i = 0; i < this.n; ++i) {
            this.curr[i] = documentIterator[i].nextDocument();
            if (this.curr[i] == -1) continue;
            this.queue.enqueue(i);
        }
        if (!this.queue.isEmpty()) {
            this.next = this.curr[this.queue.first()];
        }
        this.front = new int[this.queue.size()];
    }

    @Override
    public int skipTo(int n) throws IOException {
        int first;
        if (this.last >= n) {
            return this.last;
        }
        if (this.queue.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        this.next = -1;
        this.last = -1;
        this.currentIterators.clear();
        this.frontSize = -1;
        while (this.curr[first = this.queue.first()] < n) {
            int res = this.documentIterator[first].skipTo(n);
            if (res == Integer.MAX_VALUE) {
                this.queue.dequeue();
                if (!this.queue.isEmpty()) continue;
                return Integer.MAX_VALUE;
            }
            this.curr[first] = res;
            this.queue.changed();
        }
        this.last = this.curr[first];
        return this.last;
    }

    @Override
    public int nextDocument() throws IOException {
        int first;
        if (this.next != -1) {
            this.last = this.next;
            this.next = -1;
            return this.last;
        }
        this.currentIterators.clear();
        this.frontSize = -1;
        if (this.queue.isEmpty()) {
            this.last = -1;
            return -1;
        }
        int c = this.curr[this.queue.first()];
        while (this.curr[first = this.queue.first()] == c) {
            this.curr[first] = this.documentIterator[first].nextDocument();
            if (this.curr[first] != -1) {
                this.queue.changed();
                continue;
            }
            this.queue.dequeue();
            if (!this.queue.isEmpty()) continue;
            this.last = -1;
            return -1;
        }
        this.last = this.curr[first];
        return this.last;
    }

    protected int computeFront() {
        if (this.frontSize == -1) {
            this.frontSize = this.queue.front(this.front);
        }
        return this.frontSize;
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
        ObjectIterator i = this.indices.iterator();
        while (i.hasNext()) {
            this.intervalIterator((Index)i.next());
        }
        return this.unmodifiableCurrentIterators;
    }

    @Override
    public IntervalIterator intervalIterator(Index index) throws IOException {
        if (this.last == -1) {
            throw new IllegalStateException();
        }
        if (!this.indices.contains((Object)index)) {
            return IntervalIterators.TRUE;
        }
        IntervalIterator intervalIterator = (IntervalIterator)this.currentIterators.get((Object)index);
        if (intervalIterator != null) {
            return intervalIterator;
        }
        boolean atLeastOneIsTrue = false;
        int c = 0;
        IntervalIterator oneNotTrue = null;
        int i = this.computeFront();
        while (i-- != 0) {
            intervalIterator = this.documentIterator[this.front[i]].intervalIterator(index);
            if (intervalIterator == IntervalIterators.TRUE) {
                atLeastOneIsTrue = true;
                continue;
            }
            oneNotTrue = intervalIterator;
            if (intervalIterator == IntervalIterators.FALSE) continue;
            ++c;
        }
        if (c == 0) {
            intervalIterator = atLeastOneIsTrue ? IntervalIterators.TRUE : IntervalIterators.FALSE;
        } else if (c == 1) {
            intervalIterator = oneNotTrue;
        } else {
            intervalIterator = (IntervalIterator)this.intervalIterators.get((Object)index);
            if (intervalIterator == null) {
                intervalIterator = this.getComposedIntervalIterator(index);
                this.intervalIterators.put((Object)index, (Object)intervalIterator);
            }
            intervalIterator.reset();
        }
        this.currentIterators.put((Object)index, (Object)intervalIterator);
        return intervalIterator;
    }

    protected abstract IntervalIterator getComposedIntervalIterator(Index var1);

    @Override
    public boolean acceptOnTruePaths(DocumentIteratorVisitor visitor) throws IOException {
        if (!visitor.visitPre(this)) {
            return false;
        }
        int s = this.computeFront();
        for (int i = 0; i < s; ++i) {
            if (this.documentIterator[this.front[i]].acceptOnTruePaths(visitor)) continue;
            return false;
        }
        return visitor.visitPost(this);
    }
}

