/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import java.io.Reader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.servlet.VelocityServlet;

public class GenericItem
extends VelocityServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Util.getLogger(GenericItem.class);

    public Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context context) throws Exception {
        if (request.getParameter("doc") != null) {
            DocumentCollection collection = (DocumentCollection)this.getServletContext().getAttribute("collection");
            response.setContentType(request.getParameter("m"));
            response.setCharacterEncoding("UTF-8");
            Document document = collection.document(Integer.parseInt(request.getParameter("doc")));
            DocumentFactory factory = collection.factory();
            ObjectArrayList fields = new ObjectArrayList();
            int numberOfFields = factory.numberOfFields();
            LOGGER.debug((Object)("ParsingFactory declares " + numberOfFields + " fields"));
            for (int field = 0; field < numberOfFields; ++field) {
                if (factory.fieldType(field) != DocumentFactory.FieldType.TEXT) {
                    fields.add((Object)StringEscapeUtils.escapeHtml((String)document.content(field).toString()));
                    continue;
                }
                fields.add((Object)StringEscapeUtils.escapeHtml((String)IOUtils.toString((Reader)((Reader)document.content(field)))).replaceAll("\n", "<br>\n"));
            }
            context.put("title", (Object)document.title());
            context.put("fields", (Object)fields);
            context.put("factory", (Object)factory);
            return Velocity.getTemplate((String)"it/unimi/dsi/mg4j/query/generic.velocity");
        }
        return null;
    }
}

