/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.wired;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.mg4j.index.AbstractIndexIterator;
import it.unimi.dsi.mg4j.index.AbstractIndexReader;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.util.Interval;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class GammaDeltaGammaDeltaBitStreamIndexReader
extends AbstractIndexReader {
    private static final Logger LOGGER = Util.getLogger(GammaDeltaGammaDeltaBitStreamIndexReader.class);
    protected final BitStreamIndex index;
    private static final boolean ASSERTS = false;
    private static final boolean DEBUG = false;
    protected final BitStreamIndexReaderIndexIterator indexIterator;

    public GammaDeltaGammaDeltaBitStreamIndexReader(BitStreamIndex index, InputBitStream ibs) {
        this.index = index;
        this.indexIterator = new BitStreamIndexReaderIndexIterator(this, ibs);
    }

    private IndexIterator documents(CharSequence term, int termNumber) throws IOException {
        this.indexIterator.term(term);
        this.indexIterator.position(termNumber);
        return this.indexIterator;
    }

    public IndexIterator documents(int term) throws IOException {
        return this.documents(null, term);
    }

    public IndexIterator documents(CharSequence term) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("This " + this.getClass().getSimpleName() + " has been closed");
        }
        if (this.index.termMap != null) {
            int termIndex = (int)this.index.termMap.getLong((Object)term);
            if (termIndex == -1) {
                return this.index.emptyIndexIterator;
            }
            return this.documents(term, termIndex);
        }
        throw new UnsupportedOperationException("Index " + this.index + " has no term map");
    }

    public IndexIterator nextIterator() throws IOException {
        return this.indexIterator.advance();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.index + "]";
    }

    public void close() throws IOException {
        super.close();
        this.indexIterator.ibs.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class BitStreamIndexReaderIndexIterator
    extends AbstractIndexIterator
    implements IndexIterator {
        private final GammaDeltaGammaDeltaBitStreamIndexReader parent;
        protected final BitStreamIndex index;
        protected final InputBitStream ibs;
        private final IndexIntervalIterator intervalIterator;
        private final Reference2ReferenceMap<Index, IntervalIterator> singletonIntervalIterator;
        private final Index keyIndex;
        protected final CompressionFlags.Coding pointerCoding;
        protected final CompressionFlags.Coding countCoding;
        protected final CompressionFlags.Coding positionCoding;
        protected int currentTerm = -1;
        protected int frequency;
        protected boolean hasPointers;
        protected int count;
        protected int currentDocument;
        protected int numberOfDocumentRecord;
        protected int state;
        private static final int BEFORE_PAYLOAD = 1;
        private static final int BEFORE_COUNT = 2;
        private static final int BEFORE_POSITIONS = 3;
        private static final int BEFORE_POINTER = 4;
        protected int[] positionCache = new int[16];

        public BitStreamIndexReaderIndexIterator(GammaDeltaGammaDeltaBitStreamIndexReader parent, InputBitStream ibs) {
            this.parent = parent;
            this.ibs = ibs;
            this.index = parent.index;
            this.keyIndex = this.index.keyIndex;
            this.pointerCoding = this.index.pointerCoding;
            if (this.index.hasPayloads) {
                throw new IllegalStateException();
            }
            if (!this.index.hasCounts) {
                throw new IllegalStateException();
            }
            this.countCoding = this.index.countCoding;
            if (!this.index.hasPositions) {
                throw new IllegalStateException();
            }
            this.positionCoding = this.index.positionCoding;
            this.intervalIterator = this.index.hasPositions ? new IndexIntervalIterator() : null;
            this.singletonIntervalIterator = this.index.hasPositions ? Reference2ReferenceMaps.singleton((Object)this.keyIndex, (Object)this.intervalIterator) : null;
        }

        protected void position(int term) throws IOException {
            if (term == 0) {
                this.ibs.position(0L);
                this.ibs.readBits(0L);
            } else {
                if (this.index.offsets == null) {
                    throw new IllegalStateException("You cannot position an index without offsets");
                }
                long offset = this.index.offsets.getLong(term);
                this.ibs.position(offset);
                this.ibs.readBits(offset);
            }
            this.currentTerm = term;
            this.readFrequency();
        }

        @Override
        public int termNumber() {
            return this.currentTerm;
        }

        protected IndexIterator advance() throws IOException {
            if (this.currentTerm == this.index.numberOfTerms - 1) {
                return null;
            }
            if (this.currentTerm != -1) {
                this.skipTo(Integer.MAX_VALUE);
                this.nextDocument();
            }
            ++this.currentTerm;
            this.readFrequency();
            return this;
        }

        private void readFrequency() throws IOException {
            this.frequency = this.ibs.readGamma() + 1;
            this.hasPointers = this.frequency < this.index.numberOfDocuments;
            this.count = -1;
            this.currentDocument = -1;
            this.numberOfDocumentRecord = -1;
            this.state = 4;
        }

        @Override
        public Index index() {
            return this.keyIndex;
        }

        @Override
        public int frequency() {
            return this.frequency;
        }

        private void ensureCurrentDocument() {
            if (this.currentDocument < 0) {
                throw new IllegalStateException("nextDocument() has never been called for (term=" + this.currentTerm + ")");
            }
            if (this.currentDocument == Integer.MAX_VALUE) {
                throw new IllegalStateException("This reader is positioned beyond the end of list of (term=" + this.currentTerm + ")");
            }
        }

        private boolean endOfList() {
            return this.numberOfDocumentRecord >= this.frequency - 1;
        }

        @Override
        public int document() {
            return this.currentDocument;
        }

        @Override
        public Payload payload() throws IOException {
            throw new UnsupportedOperationException("This index (" + this.index + ") does not contain payloads");
        }

        @Override
        public int count() throws IOException {
            if (this.count != -1) {
                return this.count;
            }
            this.state = 3;
            this.count = this.ibs.readGamma() + 1;
            return this.count;
        }

        protected void updatePositionCache() throws IOException {
            if (this.state < 3 && this.state == 2) {
                this.state = 3;
                this.count = this.ibs.readGamma() + 1;
            }
            if (this.count > this.positionCache.length) {
                this.positionCache = new int[Math.max(this.positionCache.length * 2, this.count)];
            }
            int[] occ = this.positionCache;
            this.state = 4;
            this.ibs.readDeltas(occ, this.count);
            for (int i = 1; i < this.count; ++i) {
                int n = i;
                occ[n] = occ[n] + (occ[i - 1] + 1);
            }
        }

        @Override
        public IntIterator positions() throws IOException {
            if (this.state <= 3) {
                this.updatePositionCache();
            }
            return IntIterators.wrap((int[])this.positionCache, (int)0, (int)this.count);
        }

        @Override
        public int[] positionArray() throws IOException {
            if (this.state <= 3) {
                this.updatePositionCache();
            }
            return this.positionCache;
        }

        @Override
        public int positions(int[] position) throws IOException {
            if (this.state <= 3) {
                this.updatePositionCache();
            }
            if (position.length < this.count) {
                return -this.count;
            }
            int i = this.count;
            while (i-- != 0) {
                position[i] = this.positionCache[i];
            }
            return this.count;
        }

        @Override
        public int nextDocument() throws IOException {
            if (this.state != 4) {
                if (this.state == 2) {
                    this.state = 3;
                    this.count = this.ibs.readGamma() + 1;
                }
                if (this.state == 3) {
                    this.state = 4;
                    this.ibs.skipDeltas(this.count);
                }
            }
            if (this.endOfList()) {
                return -1;
            }
            this.currentDocument = this.hasPointers ? (this.currentDocument += this.ibs.readDelta() + 1) : ++this.currentDocument;
            ++this.numberOfDocumentRecord;
            this.state = 2;
            this.count = -1;
            return this.currentDocument;
        }

        @Override
        public int skipTo(int p) throws IOException {
            if (this.numberOfDocumentRecord == -1) {
                this.nextDocument();
            }
            if (this.currentDocument >= p) {
                return this.currentDocument;
            }
            while (this.currentDocument < p) {
                if (this.nextDocument() != -1) continue;
                return Integer.MAX_VALUE;
            }
            return this.currentDocument;
        }

        @Override
        public void dispose() throws IOException {
            this.parent.close();
        }

        public boolean hasNext() {
            return !this.endOfList();
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return this.nextDocument();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.index + " [" + this.currentTerm + "]";
        }

        @Override
        public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
            this.intervalIterator();
            return this.singletonIntervalIterator;
        }

        @Override
        public IntervalIterator intervalIterator() throws IOException {
            return this.intervalIterator(this.keyIndex);
        }

        @Override
        public IntervalIterator intervalIterator(Index index) throws IOException {
            if (index != this.keyIndex) {
                return IntervalIterators.TRUE;
            }
            this.intervalIterator.reset();
            return this.intervalIterator;
        }

        @Override
        public ReferenceSet<Index> indices() {
            return this.index.singletonSet;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class IndexIntervalIterator
        extends AbstractObjectIterator<Interval>
        implements IntervalIterator {
            int pos = -1;

            private IndexIntervalIterator() {
            }

            @Override
            public void reset() throws IOException {
                this.pos = -1;
                if (BitStreamIndexReaderIndexIterator.this.state <= 3) {
                    BitStreamIndexReaderIndexIterator.this.updatePositionCache();
                }
            }

            @Override
            public void intervalTerms(IntSet terms) {
                terms.add(BitStreamIndexReaderIndexIterator.this.currentTerm);
            }

            @Override
            public boolean hasNext() {
                return this.pos < BitStreamIndexReaderIndexIterator.this.count - 1;
            }

            @Override
            public Interval next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Interval.valueOf((int)BitStreamIndexReaderIndexIterator.this.positionCache[++this.pos]);
            }

            @Override
            public Interval nextInterval() {
                return this.pos < BitStreamIndexReaderIndexIterator.this.count - 1 ? Interval.valueOf((int)BitStreamIndexReaderIndexIterator.this.positionCache[++this.pos]) : null;
            }

            @Override
            public int extent() {
                return 1;
            }

            public String toString() {
                return BitStreamIndexReaderIndexIterator.this.index + ": " + BitStreamIndexReaderIndexIterator.this.term + "[doc=" + BitStreamIndexReaderIndexIterator.this.currentDocument + ", count=" + BitStreamIndexReaderIndexIterator.this.count + ", pos=" + this.pos + "]";
            }
        }
    }
}

