/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.remote;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.mg4j.index.remote.RemoteIndexServerConnection;
import it.unimi.dsi.util.StringMap;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketAddress;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteTermMap
extends AbstractObject2LongFunction<CharSequence>
implements StringMap<MutableString>,
Serializable {
    protected static final byte GET_NUMBER = 0;
    protected static final byte GET_TERM = 1;
    protected static final byte HAS_TERMS = 2;
    static final long serialVersionUID = 1L;
    protected SocketAddress address;
    protected final int size;
    protected transient RemoteIndexServerConnection remoteConnection;
    protected ObjectList<MutableString> list;
    private boolean hasTerms;

    public RemoteTermMap(SocketAddress address, int size) {
        this.address = address;
        this.size = size;
        this.hasTerms = this.hasTerms();
    }

    public int size() {
        return this.size;
    }

    private void ensureConnection() throws IOException {
        if (this.remoteConnection == null) {
            this.remoteConnection = new RemoteIndexServerConnection(this.address, 2);
        }
    }

    public boolean hasTerms() {
        try {
            this.ensureConnection();
            this.remoteConnection.outputStream.writeByte(2);
            this.remoteConnection.outputStream.flush();
            return this.remoteConnection.inputStream.readBoolean();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectList<MutableString> list() {
        if (this.hasTerms && this.list == null) {
            this.list = new AbstractObjectList<MutableString>(){

                public MutableString get(int index) {
                    try {
                        RemoteTermMap.this.ensureConnection();
                        RemoteTermMap.this.remoteConnection.outputStream.writeByte(1);
                        RemoteTermMap.this.remoteConnection.outputStream.writeInt(index);
                        RemoteTermMap.this.remoteConnection.outputStream.flush();
                        return new MutableString().readSelfDelimUTF8((InputStream)RemoteTermMap.this.remoteConnection.inputStream);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public int size() {
                    return RemoteTermMap.this.size;
                }
            };
        }
        return this.list;
    }

    public long getLong(Object o) {
        CharSequence term = (CharSequence)o;
        try {
            this.ensureConnection();
            this.remoteConnection.outputStream.writeByte(0);
            new MutableString(term).writeSelfDelimUTF8((OutputStream)this.remoteConnection.outputStream);
            this.remoteConnection.outputStream.flush();
            return this.remoteConnection.inputStream.readLong();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean containsKey(Object o) {
        return this.getLong(o) != -1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServerThread
    extends it.unimi.dsi.mg4j.index.remote.ServerThread {
        private static final boolean DEBUG = false;
        private static final Logger LOGGER = Util.getLogger(ServerThread.class);
        private final StringMap<? extends CharSequence> termMap;

        public ServerThread(Socket socket, StringMap<? extends CharSequence> termMap) throws IOException {
            super(socket);
            this.termMap = termMap;
        }

        @Override
        public void run() {
            try {
                MutableString s = new MutableString();
                block8: while (true) {
                    byte command = this.inputStream.readByte();
                    switch (command) {
                        case 0: {
                            this.outputStream.writeLong(this.termMap.getLong((Object)s.readSelfDelimUTF8((InputStream)this.inputStream)));
                            this.outputStream.flush();
                            continue block8;
                        }
                        case 1: {
                            new MutableString((CharSequence)this.termMap.list().get(this.inputStream.readInt())).writeSelfDelimUTF8((OutputStream)this.outputStream);
                            this.outputStream.flush();
                            continue block8;
                        }
                        case 2: {
                            this.outputStream.writeBoolean(this.termMap.list() != null);
                            this.outputStream.flush();
                            continue block8;
                        }
                    }
                    LOGGER.error((Object)("Unknown remote command: " + command));
                }
            }
            catch (EOFException e) {
                LOGGER.warn((Object)"The socket has been closed");
            }
            catch (Exception e) {
                LOGGER.fatal((Object)e, (Throwable)e);
            }
        }
    }
}

