/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.remote;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.objects.AbstractObject2ObjectFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectFunction;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.mg4j.index.remote.RemoteIndexServerConnection;
import it.unimi.dsi.mg4j.index.remote.RemoteTermMap;
import it.unimi.dsi.util.Interval;
import it.unimi.dsi.util.Intervals;
import it.unimi.dsi.util.PrefixMap;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketAddress;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotePrefixMap
extends RemoteTermMap
implements PrefixMap<MutableString>,
Serializable {
    public static final byte GET_INTERVAL = 3;
    public static final byte GET_PREFIX = 4;
    public static final byte HAS_PREFIXES = 5;
    static final long serialVersionUID = 1L;
    private boolean hasPrefixes = this.hasPrefixes();
    private AbstractObject2ObjectFunction<Interval, MutableString> prefixMap;
    private Object2ObjectFunction<CharSequence, Interval> rangeMap;

    public RemotePrefixMap(SocketAddress address, int size) {
        super(address, size);
    }

    private void ensureConnection() throws IOException {
        if (this.remoteConnection == null) {
            this.remoteConnection = new RemoteIndexServerConnection(this.address, 3);
        }
    }

    private boolean hasPrefixes() {
        try {
            this.ensureConnection();
            this.remoteConnection.outputStream.writeByte(5);
            this.remoteConnection.outputStream.flush();
            return this.remoteConnection.inputStream.readBoolean();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object2ObjectFunction<Interval, MutableString> prefixMap() {
        if (this.hasPrefixes && this.prefixMap == null) {
            this.prefixMap = new AbstractObject2ObjectFunction<Interval, MutableString>(){
                private static final long serialVersionUID = 1L;

                public boolean containsKey(Object o) {
                    Interval interval = (Interval)o;
                    return interval != Intervals.EMPTY_INTERVAL && interval.left >= 0 && interval.right < RemotePrefixMap.this.size();
                }

                public MutableString get(Object o) {
                    Interval interval = (Interval)o;
                    try {
                        RemotePrefixMap.this.ensureConnection();
                        RemotePrefixMap.this.remoteConnection.outputStream.writeByte(4);
                        RemotePrefixMap.this.remoteConnection.outputStream.writeInt(interval.left);
                        RemotePrefixMap.this.remoteConnection.outputStream.writeInt(interval.right);
                        RemotePrefixMap.this.remoteConnection.outputStream.flush();
                        return new MutableString().readSelfDelimUTF8((InputStream)RemotePrefixMap.this.remoteConnection.inputStream);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public int size() {
                    return -1;
                }
            };
        }
        return this.prefixMap;
    }

    public Object2ObjectFunction<CharSequence, Interval> rangeMap() {
        if (this.rangeMap == null) {
            this.rangeMap = new AbstractObject2ObjectFunction<CharSequence, Interval>(){
                private static final long serialVersionUID = 1L;

                public boolean containsKey(Object o) {
                    return this.get(o) != Intervals.EMPTY_INTERVAL;
                }

                public Interval get(Object o) {
                    CharSequence prefix = (CharSequence)o;
                    try {
                        RemotePrefixMap.this.ensureConnection();
                        RemotePrefixMap.this.remoteConnection.outputStream.writeByte(3);
                        new MutableString(prefix).writeSelfDelimUTF8((OutputStream)RemotePrefixMap.this.remoteConnection.outputStream);
                        RemotePrefixMap.this.remoteConnection.outputStream.flush();
                        return Interval.valueOf((int)RemotePrefixMap.this.remoteConnection.inputStream.readInt(), (int)RemotePrefixMap.this.remoteConnection.inputStream.readInt());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public int size() {
                    return -1;
                }
            };
        }
        return this.rangeMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServerThread
    extends it.unimi.dsi.mg4j.index.remote.ServerThread {
        private static final boolean DEBUG = false;
        private static final Logger LOGGER = Util.getLogger(ServerThread.class);
        private final PrefixMap<? extends CharSequence> prefixMap;

        public ServerThread(Socket socket, PrefixMap<? extends CharSequence> prefixMap) throws IOException {
            super(socket);
            this.prefixMap = prefixMap;
        }

        @Override
        public void run() {
            try {
                MutableString s = new MutableString();
                block11: while (true) {
                    byte command = this.inputStream.readByte();
                    switch (command) {
                        case 0: {
                            this.outputStream.writeLong(this.prefixMap.getLong((Object)s.readSelfDelimUTF8((InputStream)this.inputStream)));
                            this.outputStream.flush();
                            continue block11;
                        }
                        case 1: {
                            new MutableString((CharSequence)this.prefixMap.list().get(this.inputStream.readInt())).writeSelfDelimUTF8((OutputStream)this.outputStream);
                            this.outputStream.flush();
                            continue block11;
                        }
                        case 2: {
                            this.outputStream.writeBoolean(this.prefixMap.list() != null);
                            this.outputStream.flush();
                            continue block11;
                        }
                        case 3: {
                            Interval interval = (Interval)this.prefixMap.rangeMap().get((Object)s.readSelfDelimUTF8((InputStream)this.inputStream));
                            this.outputStream.writeInt(interval.left);
                            this.outputStream.writeInt(interval.right);
                            this.outputStream.flush();
                            continue block11;
                        }
                        case 4: {
                            new MutableString((CharSequence)this.prefixMap.prefixMap().get((Object)Interval.valueOf((int)this.inputStream.readInt(), (int)this.inputStream.readInt()))).writeSelfDelimUTF8((OutputStream)this.outputStream);
                            this.outputStream.flush();
                            continue block11;
                        }
                        case 5: {
                            this.outputStream.writeBoolean(this.prefixMap.prefixMap() != null);
                            this.outputStream.flush();
                            continue block11;
                        }
                    }
                    LOGGER.error((Object)("Unknown remote command: " + command));
                }
            }
            catch (EOFException e) {
                LOGGER.warn((Object)"The socket has been closed");
            }
            catch (Exception e) {
                LOGGER.fatal((Object)e, (Throwable)e);
            }
        }
    }
}

