/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.cluster;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.IndexIterators;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.MultiTermIndexIterator;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.index.TooManyTermsException;
import it.unimi.dsi.mg4j.index.cluster.IndexCluster;
import it.unimi.dsi.mg4j.index.cluster.LexicalClusterIndexReader;
import it.unimi.dsi.mg4j.index.cluster.LexicalClusteringStrategy;
import it.unimi.dsi.mg4j.index.cluster.LexicalPartitioningStrategy;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.util.BloomFilter;
import it.unimi.dsi.util.Properties;
import java.io.IOException;
import java.util.ArrayList;

public class LexicalCluster
extends IndexCluster {
    private static final long serialVersionUID = 1L;
    protected final LexicalClusteringStrategy strategy;
    protected final LexicalPartitioningStrategy partitioningStrategy;

    public LexicalCluster(Index[] localIndex, LexicalClusteringStrategy strategy, BloomFilter[] termFilter, int numberOfDocuments, int numberOfTerms, long numberOfPostings, long numberOfOccurrences, int maxCount, Payload payload, boolean hasCounts, boolean hasPositions, TermProcessor termProcessor, String field, IntList sizes, Properties properties) {
        super(localIndex, termFilter, numberOfDocuments, numberOfTerms, numberOfPostings, numberOfOccurrences, maxCount, payload, hasCounts, hasPositions, termProcessor, field, sizes, properties);
        this.strategy = strategy;
        this.partitioningStrategy = strategy instanceof LexicalPartitioningStrategy ? (LexicalPartitioningStrategy)((Object)strategy) : null;
    }

    public IndexReader getReader(int bufferSize) throws IOException {
        return new LexicalClusterIndexReader(this, bufferSize);
    }

    public IndexIterator documents(CharSequence prefix, int limit) throws IOException, TooManyTermsException {
        ArrayList<IndexIterator> iterators = new ArrayList<IndexIterator>(this.localIndex.length);
        for (int i = 0; i < this.localIndex.length; ++i) {
            IndexIterator documentIterator = this.localIndex[i].documents(prefix, limit);
            if (!documentIterator.hasNext()) continue;
            iterators.add(documentIterator);
        }
        return MultiTermIndexIterator.getInstance(this, iterators.toArray(IndexIterators.EMPTY_ARRAY));
    }
}

