/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.cluster;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.IndexIterators;
import it.unimi.dsi.mg4j.index.cluster.AbstractIndexClusterIndexReader;
import it.unimi.dsi.mg4j.index.cluster.DocumentalCluster;
import it.unimi.dsi.mg4j.index.cluster.DocumentalConcatenatedClusterIndexIterator;
import it.unimi.dsi.mg4j.index.cluster.DocumentalMergedClusterIndexIterator;
import it.unimi.dsi.mg4j.search.AbstractDocumentIterator;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DocumentalClusterIndexReader
extends AbstractIndexClusterIndexReader {
    private static final Logger LOGGER = Util.getLogger(DocumentalClusterIndexReader.class);
    private static final boolean DEBUG = false;
    protected final DocumentalCluster index;

    public DocumentalClusterIndexReader(DocumentalCluster index, int bufferSize) throws IOException {
        super(index, bufferSize);
        this.index = index;
    }

    public IndexIterator documents(int term) throws IOException {
        if (!this.index.flat) {
            throw new UnsupportedOperationException("Only flat documental clusters allow access by term number");
        }
        IndexIterator[] iterator = new IndexIterator[this.indexReader.length];
        for (int i = 0; i < this.indexReader.length; ++i) {
            iterator[i] = this.indexReader[i].documents(term);
        }
        AbstractDocumentIterator indexIterator = this.index.concatenated ? new DocumentalConcatenatedClusterIndexIterator(this, iterator, this.index.allIndices) : new DocumentalMergedClusterIndexIterator(this, iterator, this.index.allIndices);
        return indexIterator;
    }

    public IndexIterator documents(CharSequence term) throws IOException {
        ArrayList<IndexIterator> iterators = new ArrayList<IndexIterator>(this.indexReader.length);
        IntArrayList usedIndices = new IntArrayList();
        for (int i = 0; i < this.indexReader.length; ++i) {
            IndexIterator it;
            if (this.index.termFilter != null && !this.index.termFilter[i].contains(term) || !(it = this.indexReader[i].documents(term)).hasNext()) continue;
            iterators.add(it);
            usedIndices.add(i);
        }
        if (iterators.isEmpty()) {
            return this.index.emptyIndexIterator;
        }
        AbstractDocumentIterator indexIterator = this.index.concatenated ? new DocumentalConcatenatedClusterIndexIterator(this, iterators.toArray(IndexIterators.EMPTY_ARRAY), usedIndices.toIntArray()) : new DocumentalMergedClusterIndexIterator(this, iterators.toArray(IndexIterators.EMPTY_ARRAY), usedIndices.toIntArray());
        indexIterator.term(term);
        return indexIterator;
    }
}

