/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.cluster;

import it.unimi.dsi.mg4j.index.cluster.DocumentalClusteringStrategy;
import it.unimi.dsi.mg4j.index.cluster.DocumentalPartitioningStrategy;
import it.unimi.dsi.util.Properties;
import java.io.Serializable;
import java.util.Arrays;

public class ContiguousDocumentalStrategy
implements DocumentalPartitioningStrategy,
DocumentalClusteringStrategy,
Serializable {
    private static final long serialVersionUID = 0L;
    private final int[] cutPoint;
    private final int k;

    public ContiguousDocumentalStrategy(int ... cutPoint) {
        if (cutPoint.length == 0) {
            throw new IllegalArgumentException("Empty cutpoint array");
        }
        if (cutPoint[0] != 0) {
            throw new IllegalArgumentException("The first cutpoint must be 0");
        }
        this.cutPoint = cutPoint;
        this.k = cutPoint.length - 1;
    }

    public int numberOfLocalIndices() {
        return this.k;
    }

    public int localIndex(int globalPointer) {
        if (globalPointer >= this.cutPoint[this.k]) {
            throw new IndexOutOfBoundsException(Integer.toString(globalPointer));
        }
        int i = this.k;
        while (i-- != 0) {
            if (globalPointer < this.cutPoint[i]) continue;
            return i;
        }
        throw new IndexOutOfBoundsException(Integer.toString(globalPointer));
    }

    public int localPointer(int globalPointer) {
        return globalPointer - this.cutPoint[this.localIndex(globalPointer)];
    }

    public int globalPointer(int localIndex, int localPointer) {
        return localPointer + this.cutPoint[localIndex];
    }

    public int numberOfDocuments(int localIndex) {
        return this.cutPoint[localIndex + 1] - this.cutPoint[localIndex];
    }

    public Properties[] properties() {
        Properties[] properties = new Properties[this.k];
        for (int i = 0; i < this.k; ++i) {
            properties[i] = new Properties();
            properties[i].addProperty("pointerfrom", this.cutPoint[i]);
            properties[i].addProperty("pointerto", this.cutPoint[i + 1]);
        }
        return properties;
    }

    public String toString() {
        return Arrays.toString(this.cutPoint);
    }
}

