/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.cluster;

import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.cluster.LexicalClusteringStrategy;
import it.unimi.dsi.util.BloomFilter;
import it.unimi.dsi.util.StringMap;

public class ChainedLexicalClusteringStrategy
implements LexicalClusteringStrategy {
    static final long serialVersionUID = 0L;
    private final transient StringMap<? extends CharSequence>[] termMap;
    private final transient BloomFilter[] termFilter;

    public ChainedLexicalClusteringStrategy(Index[] index, BloomFilter[] termFilter) {
        this.termMap = new StringMap[index.length];
        int i = index.length;
        while (i-- != 0) {
            this.termMap[i] = ((BitStreamIndex)index[i]).termMap;
        }
        this.termFilter = termFilter;
    }

    public ChainedLexicalClusteringStrategy(Index[] index) {
        this(index, null);
    }

    public int numberOfLocalIndices() {
        return this.termMap.length;
    }

    public int localIndex(CharSequence term) {
        for (int i = 0; i < this.termMap.length; ++i) {
            if (this.termFilter != null && !this.termFilter[i].contains(term) || this.termMap[i].getLong((Object)term) == -1L) continue;
            return i;
        }
        return -1;
    }

    public int globalNumber(int localIndex, int localNumber) {
        throw new UnsupportedOperationException();
    }
}

