/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.search.AbstractCompositeDocumentIterator;
import it.unimi.dsi.mg4j.search.AbstractUnionDocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import it.unimi.dsi.util.Interval;
import java.io.IOException;

public class MultiTermIndexIterator
extends AbstractUnionDocumentIterator
implements IndexIterator {
    private static final boolean ASSERTS = false;
    private int frequency;
    protected String term;
    protected int id;
    private int count = -1;
    private final boolean hasCounts;
    private final boolean hasPositions;

    public static IndexIterator getInstance(IndexIterator ... indexIterator) throws IOException {
        return MultiTermIndexIterator.getInstance(Integer.MIN_VALUE, indexIterator);
    }

    public static IndexIterator getInstance(Index index, IndexIterator ... indexIterator) throws IOException {
        return MultiTermIndexIterator.getInstance(Integer.MIN_VALUE, index, indexIterator);
    }

    public static IndexIterator getInstance(int defaultFrequency, IndexIterator ... indexIterator) throws IOException {
        if (indexIterator.length == 0) {
            throw new IllegalArgumentException();
        }
        return MultiTermIndexIterator.getInstance(defaultFrequency, indexIterator[0].index(), indexIterator);
    }

    public static IndexIterator getInstance(int defaultFrequency, Index index, IndexIterator ... indexIterator) throws IOException {
        if (indexIterator.length == 0) {
            return index.emptyIndexIterator;
        }
        if (indexIterator.length == 1) {
            return indexIterator[0];
        }
        return new MultiTermIndexIterator(defaultFrequency, indexIterator);
    }

    protected MultiTermIndexIterator(int defaultFrequency, IndexIterator ... indexIterator) throws IOException {
        super(indexIterator);
        this.frequency = defaultFrequency;
        boolean havePositions = true;
        boolean haveCounts = true;
        for (IndexIterator i : indexIterator) {
            if (!i.index().hasCounts) {
                haveCounts = false;
            }
            if (i.index().hasPositions) continue;
            havePositions = false;
        }
        this.hasCounts = haveCounts;
        this.hasPositions = havePositions;
    }

    protected IntervalIterator getComposedIntervalIterator(Index index) {
        return new MultiTermIntervalIterator();
    }

    public int skipTo(int n) throws IOException {
        if (this.last >= n) {
            return this.last;
        }
        this.count = -1;
        return super.skipTo(n);
    }

    public int nextDocument() throws IOException {
        this.count = -1;
        return super.nextDocument();
    }

    public int count() throws IOException {
        if (!this.hasCounts) {
            throw new IllegalStateException("Some of the underlying iterators do not have counts");
        }
        if (this.last == -1) {
            throw new IllegalStateException();
        }
        if (this.count == -1) {
            int count = 0;
            int i = this.computeFront();
            while (i-- != 0) {
                count += this.indexIterator[this.front[i]].count();
            }
            this.count = count;
        }
        return this.count;
    }

    public int frequency() throws IOException {
        if (this.frequency != Integer.MIN_VALUE) {
            return this.frequency;
        }
        int frequency = Integer.MIN_VALUE;
        int i = this.n;
        while (i-- != 0) {
            frequency = Math.max(frequency, this.indexIterator[i].frequency());
        }
        this.frequency = frequency;
        return this.frequency;
    }

    public void term(CharSequence term) {
        this.term = term == null ? null : ((Object)term).toString();
    }

    public String term() {
        return this.term;
    }

    public int termNumber() {
        return this.indexIterator[0].termNumber();
    }

    public void id(int id) {
        this.id = id;
    }

    public int id() {
        return this.id;
    }

    public Index index() {
        return this.soleIndex;
    }

    public Payload payload() {
        throw new UnsupportedOperationException();
    }

    public int[] positionArray() throws IOException {
        if (!this.hasPositions) {
            throw new IllegalStateException("Some of the underlying iterators do not have positions");
        }
        if (this.computeFront() == 1) {
            return this.indexIterator[this.front[0]].positionArray();
        }
        MultiTermIntervalIterator multiTermIntervalIterator = (MultiTermIntervalIterator)this.intervalIterator();
        multiTermIntervalIterator.drain();
        return multiTermIntervalIterator.cache;
    }

    public IntIterator positions() throws IOException {
        return IntIterators.wrap((int[])this.positionArray(), (int)0, (int)this.count);
    }

    public int positions(int[] position) throws IOException {
        int c = this.count;
        if (position.length < c) {
            return -c;
        }
        int[] cache = this.positionArray();
        int i = c;
        while (i-- != 0) {
            position[i] = cache[i];
        }
        return c;
    }

    public boolean accept(DocumentIteratorVisitor visitor) throws IOException {
        return visitor.visit(this);
    }

    public boolean acceptOnTruePaths(DocumentIteratorVisitor visitor) throws IOException {
        return visitor.visit(this);
    }

    private class MultiTermIntervalIterator
    extends AbstractCompositeDocumentIterator.AbstractCompositeIndexIntervalIterator
    implements IntervalIterator {
        private static final boolean DEBUG = false;
        private static final boolean ASSERTS = false;
        private final IntHeapSemiIndirectPriorityQueue positionQueue;
        public int[] cache;
        private int emitted;
        private int extracted;

        public MultiTermIntervalIterator() {
            super(MultiTermIndexIterator.this.n);
            this.positionQueue = new IntHeapSemiIndirectPriorityQueue(this.curr);
            this.cache = new int[4];
        }

        public void reset() throws IOException {
            this.extracted = 0;
            this.emitted = 0;
            this.next = null;
            this.positionQueue.clear();
            int i = MultiTermIndexIterator.this.computeFront();
            while (i-- != 0) {
                int k = MultiTermIndexIterator.this.front[i];
                this.position[k] = MultiTermIndexIterator.this.indexIterator[k].positionArray();
                this.count[k] = MultiTermIndexIterator.this.indexIterator[k].count();
                this.curr[k] = this.position[k][0];
                this.currPos[k] = 0;
                this.positionQueue.enqueue(k);
            }
        }

        public void intervalTerms(IntSet terms) {
            terms.add(MultiTermIndexIterator.this.indexIterator[0].termNumber());
        }

        public Interval nextInterval() {
            if (this.next != null) {
                Interval result = this.next;
                this.next = null;
                return result;
            }
            if (this.emitted < this.extracted) {
                return Interval.valueOf((int)this.cache[this.emitted++]);
            }
            if (this.positionQueue.isEmpty()) {
                return null;
            }
            int first = this.positionQueue.first();
            if (this.extracted == this.cache.length) {
                this.cache = IntArrays.grow((int[])this.cache, (int)(this.extracted + 1));
            }
            this.cache[this.extracted++] = this.curr[first];
            int n = first;
            this.currPos[n] = this.currPos[n] + 1;
            if (this.currPos[n] < this.count[first]) {
                this.curr[first] = this.position[first][this.currPos[first]];
                this.positionQueue.changed();
                if (this.curr[this.positionQueue.first()] == this.cache[this.extracted - 1]) {
                    throw new IllegalArgumentException("Duplicate positions in " + this);
                }
            } else {
                this.positionQueue.dequeue();
            }
            return Interval.valueOf((int)this.cache[this.emitted++]);
        }

        public int extent() {
            return 1;
        }

        public void drain() {
            int emittedNow = this.emitted - (this.next != null ? 1 : 0);
            this.next = null;
            while (this.nextInterval() != null) {
            }
            this.emitted = emittedNow;
        }
    }
}

