/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongLists;
import it.unimi.dsi.io.ByteBufferInputStream;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.FileHPIndex;
import it.unimi.dsi.mg4j.index.FileIndex;
import it.unimi.dsi.mg4j.index.InMemoryHPIndex;
import it.unimi.dsi.mg4j.index.InMemoryIndex;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.MemoryMappedHPIndex;
import it.unimi.dsi.mg4j.index.MemoryMappedIndex;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.util.SemiExternalOffsetList;
import it.unimi.dsi.util.PrefixMap;
import it.unimi.dsi.util.Properties;
import it.unimi.dsi.util.StringMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskBasedIndex {
    private static final Logger LOGGER = Util.getLogger(DiskBasedIndex.class);
    private static final long serialVersionUID = 0L;
    public static final int DEFAULT_OFFSET_STEP = 256;
    public static final String INDEX_EXTENSION = ".index";
    public static final String POSITIONS_EXTENSION = ".positions";
    public static final String PROPERTIES_EXTENSION = ".properties";
    public static final String SIZES_EXTENSION = ".sizes";
    public static final String OFFSETS_EXTENSION = ".offsets";
    public static final String GLOBCOUNTS_EXTENSION = ".globcounts";
    public static final String FREQUENCIES_EXTENSION = ".frequencies";
    public static final String TERMS_EXTENSION = ".terms";
    public static final String UNSORTED_TERMS_EXTENSION = ".terms.unsorted";
    public static final String TERMMAP_EXTENSION = ".termmap";
    public static final String PREFIXMAP_EXTENSION = ".prefixmap";
    public static final String STATS_EXTENSION = ".stats";

    private DiskBasedIndex() {
    }

    public static LongList readOffsets(InputBitStream in, int T) throws IOException {
        long[] offset = new long[T + 1];
        LOGGER.debug((Object)"Loading offsets...");
        offset[0] = in.readLongGamma();
        for (int i = 0; i < T; ++i) {
            offset[i + 1] = in.readLongGamma() + offset[i];
        }
        LOGGER.debug((Object)"Completed.");
        return LongArrayList.wrap((long[])offset);
    }

    public static IntList readSizes(InputBitStream in, int N) throws IOException {
        int[] size = new int[N];
        LOGGER.debug((Object)"Loading sizes...");
        for (int i = 0; i < N; ++i) {
            size[i] = in.readGamma();
        }
        LOGGER.debug((Object)"Completed.");
        return IntArrayList.wrap((int[])size);
    }

    public static StringMap<? extends CharSequence> loadStringMap(String filename) throws IOException {
        try {
            return (StringMap)BinIO.loadObject((CharSequence)filename);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static PrefixMap<? extends CharSequence> loadPrefixMap(String filename) throws IOException {
        try {
            return (PrefixMap)BinIO.loadObject((CharSequence)filename);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static BitStreamIndex getInstance(CharSequence basename, Properties properties, StringMap<? extends CharSequence> termMap, PrefixMap<? extends CharSequence> prefixMap, boolean randomAccess, boolean documentSizes, EnumMap<Index.UriKeys, String> queryProperties) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        boolean highPerformance;
        LongList offsets;
        Class<?> indexClass = null;
        try {
            indexClass = Class.forName(properties.getString((Enum)Index.PropertyKeys.INDEXCLASS, "(missing index class)"));
        }
        catch (Exception ignore) {
            // empty catch block
        }
        File indexFile = new File(basename + INDEX_EXTENSION);
        if (!indexFile.exists()) {
            throw new FileNotFoundException("Cannot find index file " + indexFile.getName());
        }
        Map<CompressionFlags.Component, CompressionFlags.Coding> flags = CompressionFlags.valueOf(properties.getStringArray((Enum)Index.PropertyKeys.CODING), null);
        int numberOfDocuments = properties.getInt((Enum)Index.PropertyKeys.DOCUMENTS);
        int numberOfTerms = properties.getInt((Enum)Index.PropertyKeys.TERMS);
        long numberOfPostings = properties.getLong((Enum)Index.PropertyKeys.POSTINGS);
        long numberOfOccurrences = properties.getLong((Enum)Index.PropertyKeys.OCCURRENCES);
        int maxCount = properties.getInt((Enum)Index.PropertyKeys.MAXCOUNT, -1);
        String field = properties.getString((Enum)Index.PropertyKeys.FIELD);
        if (termMap != null && termMap.size() != numberOfTerms) {
            throw new IllegalArgumentException("The size of the term map (" + termMap.size() + ") is not equal to the number of terms (" + numberOfTerms + ")");
        }
        if (prefixMap != null && prefixMap.size() != numberOfTerms) {
            throw new IllegalArgumentException("The size of the prefix map (" + prefixMap.size() + ") is not equal to the number of terms (" + numberOfTerms + ")");
        }
        Payload payload = properties.containsKey((Enum)Index.PropertyKeys.PAYLOADCLASS) ? Class.forName(properties.getString((Enum)Index.PropertyKeys.PAYLOADCLASS)).newInstance() : null;
        CompressionFlags.Coding frequencyCoding = flags.get((Object)CompressionFlags.Component.FREQUENCIES);
        CompressionFlags.Coding pointerCoding = flags.get((Object)CompressionFlags.Component.POINTERS);
        CompressionFlags.Coding countCoding = flags.get((Object)CompressionFlags.Component.COUNTS);
        CompressionFlags.Coding positionCoding = flags.get((Object)CompressionFlags.Component.POSITIONS);
        if (countCoding == null && positionCoding != null) {
            throw new IllegalArgumentException("Index " + basename + " has positions but no counts (this can't happen)");
        }
        IntList sizes = null;
        if (payload == null && (documentSizes || positionCoding == CompressionFlags.Coding.GOLOMB || positionCoding == CompressionFlags.Coding.INTERPOLATIVE) && (sizes = DiskBasedIndex.readSizes(new InputBitStream(basename + SIZES_EXTENSION), numberOfDocuments)).size() != numberOfDocuments) {
            throw new IllegalStateException("The length of the size list (" + sizes.size() + ") is not equal to the number of documents (" + numberOfDocuments + ")");
        }
        if (payload == null && randomAccess) {
            int offsetStep;
            int n = offsetStep = queryProperties != null && queryProperties.get((Object)Index.UriKeys.OFFSETSTEP) != null ? Integer.parseInt(queryProperties.get((Object)Index.UriKeys.OFFSETSTEP)) : 256;
            if (offsetStep < 0) {
                offsetStep = -offsetStep;
                long length = new File(basename + OFFSETS_EXTENSION).length();
                offsets = LongLists.synchronize((LongList)new SemiExternalOffsetList(new InputBitStream((InputStream)new ByteBufferInputStream((ByteBuffer)new FileInputStream(basename + OFFSETS_EXTENSION).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, length))), offsetStep, numberOfTerms + 1));
            } else {
                LongList longList = offsets = offsetStep == 0 ? DiskBasedIndex.readOffsets(new InputBitStream(basename + OFFSETS_EXTENSION), numberOfTerms) : LongLists.synchronize((LongList)new SemiExternalOffsetList(new InputBitStream(basename + OFFSETS_EXTENSION, 1024), offsetStep, numberOfTerms + 1));
            }
            if (offsets.size() != numberOfTerms + 1) {
                throw new IllegalStateException("The length of the offset list (" + offsets.size() + ") is not equal to the number of terms plus one (" + numberOfTerms + " + 1)");
            }
        } else {
            offsets = null;
        }
        int quantum = properties.getInt((Enum)BitStreamIndex.PropertyKeys.SKIPQUANTUM, -1);
        int height = properties.getInt((Enum)BitStreamIndex.PropertyKeys.SKIPHEIGHT, -1);
        int bufferSize = properties.getInt((Enum)BitStreamIndex.PropertyKeys.BUFFERSIZE, 4096);
        TermProcessor termProcessor = Index.getTermProcessor(properties);
        boolean bl = highPerformance = indexClass != null && FileHPIndex.class.isAssignableFrom(indexClass);
        if (queryProperties != null && queryProperties.containsKey((Object)Index.UriKeys.INMEMORY)) {
            return highPerformance ? new InMemoryHPIndex(BinIO.loadBytes((CharSequence)indexFile.toString()), BinIO.loadBytes((CharSequence)(basename + POSITIONS_EXTENSION)), numberOfDocuments, numberOfTerms, numberOfPostings, numberOfOccurrences, maxCount, payload, frequencyCoding, pointerCoding, countCoding, positionCoding, quantum, height, termProcessor, field, properties, termMap, prefixMap, sizes, offsets) : new InMemoryIndex(BinIO.loadBytes((CharSequence)indexFile.toString()), numberOfDocuments, numberOfTerms, numberOfPostings, numberOfOccurrences, maxCount, payload, frequencyCoding, pointerCoding, countCoding, positionCoding, quantum, height, termProcessor, field, properties, termMap, prefixMap, sizes, offsets);
        }
        if (queryProperties != null && queryProperties.containsKey((Object)Index.UriKeys.MAPPED)) {
            File positionsFile = new File(basename + POSITIONS_EXTENSION);
            MappedByteBuffer index = new FileInputStream(indexFile).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, indexFile.length());
            return highPerformance ? new MemoryMappedHPIndex(index, new FileInputStream(positionsFile).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, positionsFile.length()), numberOfDocuments, numberOfTerms, numberOfPostings, numberOfOccurrences, maxCount, payload, frequencyCoding, pointerCoding, countCoding, positionCoding, quantum, height, termProcessor, field, properties, termMap, prefixMap, sizes, offsets) : new MemoryMappedIndex(index, numberOfDocuments, numberOfTerms, numberOfPostings, numberOfOccurrences, maxCount, payload, frequencyCoding, pointerCoding, countCoding, positionCoding, quantum, height, termProcessor, field, properties, termMap, prefixMap, sizes, offsets);
        }
        return highPerformance ? new FileHPIndex(((Object)basename).toString(), numberOfDocuments, numberOfTerms, numberOfPostings, numberOfOccurrences, maxCount, payload, frequencyCoding, pointerCoding, countCoding, positionCoding, quantum, height, bufferSize, termProcessor, field, properties, termMap, prefixMap, sizes, offsets) : new FileIndex(((Object)basename).toString(), numberOfDocuments, numberOfTerms, numberOfPostings, numberOfOccurrences, maxCount, payload, frequencyCoding, pointerCoding, countCoding, positionCoding, quantum, height, bufferSize, termProcessor, field, properties, termMap, prefixMap, sizes, offsets);
    }

    public static BitStreamIndex getInstance(CharSequence basename, Properties properties, boolean randomAccess, boolean documentSizes, boolean maps, EnumMap<Index.UriKeys, String> queryProperties) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        StringMap<? extends CharSequence> termMap = null;
        PrefixMap<? extends CharSequence> prefixMap = null;
        if (maps) {
            termMap = DiskBasedIndex.loadStringMap(basename + TERMMAP_EXTENSION);
            if (termMap != null && termMap instanceof PrefixMap) {
                return DiskBasedIndex.getInstance(basename, properties, termMap, (PrefixMap<? extends CharSequence>)((PrefixMap)termMap), randomAccess, documentSizes, queryProperties);
            }
            prefixMap = DiskBasedIndex.loadPrefixMap(basename + PREFIXMAP_EXTENSION);
            if (termMap != null) {
                return DiskBasedIndex.getInstance(basename, properties, termMap, prefixMap, randomAccess, documentSizes, queryProperties);
            }
            if (prefixMap != null) {
                return DiskBasedIndex.getInstance(basename, properties, prefixMap, prefixMap, randomAccess, documentSizes, queryProperties);
            }
        }
        return DiskBasedIndex.getInstance(basename, properties, null, prefixMap, randomAccess, documentSizes, queryProperties);
    }

    public static BitStreamIndex getInstance(CharSequence basename, boolean randomAccess, boolean documentSizes, boolean maps, EnumMap<Index.UriKeys, String> queryProperties) throws ConfigurationException, ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        return DiskBasedIndex.getInstance(basename, new Properties(basename + PROPERTIES_EXTENSION), randomAccess, documentSizes, maps, queryProperties);
    }

    public static BitStreamIndex getInstance(CharSequence basename, boolean randomAccess, boolean documentSizes, boolean maps) throws ConfigurationException, ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        return DiskBasedIndex.getInstance(basename, new Properties(basename + PROPERTIES_EXTENSION), randomAccess, documentSizes, maps, null);
    }

    public static BitStreamIndex getInstance(CharSequence basename, boolean randomAccess, boolean documentSizes) throws ConfigurationException, ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        return DiskBasedIndex.getInstance(basename, randomAccess, documentSizes, true);
    }

    public static BitStreamIndex getInstance(CharSequence basename, boolean randomAccess) throws ConfigurationException, ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        return DiskBasedIndex.getInstance(basename, randomAccess, false);
    }

    public static BitStreamIndex getInstance(CharSequence basename) throws ConfigurationException, ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        return DiskBasedIndex.getInstance(basename, true);
    }
}

