/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.Util;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.mg4j.index.AbstractIndexIterator;
import it.unimi.dsi.mg4j.index.AbstractIndexReader;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.io.InterpolativeCoding;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.util.Interval;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class BitStreamIndexReader
extends AbstractIndexReader {
    private static final Logger LOGGER = Util.getLogger(BitStreamIndexReader.class);
    protected final BitStreamIndex index;
    private static final boolean ASSERTS = false;
    private static final boolean DEBUG = false;
    protected final BitStreamIndexReaderIndexIterator indexIterator;

    public BitStreamIndexReader(BitStreamIndex index, InputBitStream ibs) {
        this.index = index;
        this.indexIterator = new BitStreamIndexReaderIndexIterator(this, ibs);
    }

    private IndexIterator documents(CharSequence term, int termNumber) throws IOException {
        this.indexIterator.term(term);
        this.indexIterator.position(termNumber);
        return this.indexIterator;
    }

    public IndexIterator documents(int term) throws IOException {
        return this.documents(null, term);
    }

    public IndexIterator documents(CharSequence term) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("This " + this.getClass().getSimpleName() + " has been closed");
        }
        if (this.index.termMap != null) {
            int termIndex = (int)this.index.termMap.getLong((Object)term);
            if (termIndex == -1) {
                return this.index.emptyIndexIterator;
            }
            return this.documents(term, termIndex);
        }
        throw new UnsupportedOperationException("Index " + this.index + " has no term map");
    }

    public IndexIterator nextIterator() throws IOException {
        return this.indexIterator.advance();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.index + "]";
    }

    public void close() throws IOException {
        super.close();
        this.indexIterator.ibs.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class BitStreamIndexReaderIndexIterator
    extends AbstractIndexIterator
    implements IndexIterator {
        private final BitStreamIndexReader parent;
        protected final BitStreamIndex index;
        protected final InputBitStream ibs;
        private final IndexIntervalIterator intervalIterator;
        private final Reference2ReferenceMap<Index, IntervalIterator> singletonIntervalIterator;
        private final Index keyIndex;
        protected final boolean hasPositions;
        protected final boolean hasCounts;
        protected final boolean hasPayloads;
        protected final boolean hasSkips;
        protected final CompressionFlags.Coding pointerCoding;
        protected final CompressionFlags.Coding countCoding;
        protected final CompressionFlags.Coding positionCoding;
        protected final Payload payload;
        protected int b;
        protected int log2b;
        protected int currentTerm = -1;
        protected int frequency;
        protected boolean hasPointers;
        protected int count;
        protected int currentDocument;
        protected int numberOfDocumentRecord;
        protected int state;
        public final int height;
        public final int quantum;
        public final int quantumModuloMask;
        public final int quantumDivisionShift;
        private int maxh;
        private int s;
        private int lowest;
        private final int w;
        private final int wModuloMask;
        private final int wDivisionShift;
        private int[] towerTopB;
        private int[] towerTopLog2B;
        private int[] towerLowerB;
        private int[] towerLowerLog2B;
        private int[] pointerPrediction;
        private long[] bitSkip;
        private int[] pointerSkip;
        private long readBitsAtLastSkipTower;
        private int pointerAtLastSkipTower;
        private int quantumBitLength;
        private int entryBitLength;
        private static final int BEFORE_TOWER = 0;
        private static final int BEFORE_PAYLOAD = 1;
        private static final int BEFORE_COUNT = 2;
        private static final int BEFORE_POSITIONS = 3;
        private static final int BEFORE_POINTER = 4;
        protected int[] positionCache = new int[16];

        public BitStreamIndexReaderIndexIterator(BitStreamIndexReader parent, InputBitStream ibs) {
            this.parent = parent;
            this.ibs = ibs;
            this.index = parent.index;
            this.keyIndex = this.index.keyIndex;
            this.pointerCoding = this.index.pointerCoding;
            this.hasPayloads = this.index.hasPayloads;
            this.payload = this.hasPayloads ? this.index.payload.copy() : null;
            this.hasCounts = this.index.hasCounts;
            this.countCoding = this.index.countCoding;
            this.hasPositions = this.index.hasPositions;
            this.positionCoding = this.index.positionCoding;
            this.intervalIterator = this.index.hasPositions ? new IndexIntervalIterator() : null;
            this.singletonIntervalIterator = this.index.hasPositions ? Reference2ReferenceMaps.singleton((Object)this.keyIndex, (Object)this.intervalIterator) : null;
            this.quantum = this.index.quantum;
            this.height = this.index.height;
            if (this.quantum == -1 != (this.height == -1)) {
                throw new IllegalArgumentException();
            }
            boolean bl = this.hasSkips = this.quantum != -1 && this.height != -1;
            if (this.hasSkips) {
                this.w = (1 << this.height) * this.quantum;
                this.quantumModuloMask = this.quantum - 1;
                this.wModuloMask = this.w - 1;
                this.quantumDivisionShift = Fast.mostSignificantBit((int)this.quantum);
                this.wDivisionShift = Fast.mostSignificantBit((int)this.w);
                this.bitSkip = new long[this.height + 1];
                this.pointerSkip = new int[this.height + 1];
                this.towerTopB = new int[this.height + 1];
                this.towerTopLog2B = new int[this.height + 1];
                this.towerLowerB = new int[this.height + 1];
                this.towerLowerLog2B = new int[this.height + 1];
                this.pointerPrediction = new int[this.height + 1];
            } else {
                this.wDivisionShift = 0;
                this.quantumDivisionShift = 0;
                this.wModuloMask = 0;
                this.quantumModuloMask = 0;
                this.w = 0;
                this.bitSkip = null;
                this.pointerPrediction = null;
                this.towerLowerLog2B = null;
                this.towerLowerB = null;
                this.towerTopLog2B = null;
                this.towerTopB = null;
                this.pointerSkip = null;
            }
        }

        protected void position(int term) throws IOException {
            if (term == 0) {
                this.ibs.position(0L);
                this.ibs.readBits(0L);
            } else {
                if (this.index.offsets == null) {
                    throw new IllegalStateException("You cannot position an index without offsets");
                }
                long offset = this.index.offsets.getLong(term);
                this.ibs.position(offset);
                this.ibs.readBits(offset);
            }
            this.currentTerm = term;
            this.readFrequency();
        }

        @Override
        public int termNumber() {
            return this.currentTerm;
        }

        protected IndexIterator advance() throws IOException {
            if (this.currentTerm == this.index.numberOfTerms - 1) {
                return null;
            }
            if (this.currentTerm != -1) {
                this.skipTo(Integer.MAX_VALUE);
                this.nextDocument();
            }
            ++this.currentTerm;
            this.readFrequency();
            return this;
        }

        private void readFrequency() throws IOException {
            switch (this.index.frequencyCoding) {
                case GAMMA: {
                    this.frequency = this.ibs.readGamma() + 1;
                    break;
                }
                case SHIFTED_GAMMA: {
                    this.frequency = this.ibs.readShiftedGamma() + 1;
                    break;
                }
                case DELTA: {
                    this.frequency = this.ibs.readDelta() + 1;
                    break;
                }
                default: {
                    throw new IllegalStateException("The required frequency coding (" + (Object)((Object)this.index.frequencyCoding) + ") is not supported.");
                }
            }
            boolean bl = this.hasPointers = this.frequency < this.index.numberOfDocuments;
            if (this.pointerCoding == CompressionFlags.Coding.GOLOMB && this.hasPointers) {
                this.b = BitStreamIndex.golombModulus(this.frequency, this.index.numberOfDocuments);
                this.log2b = Fast.mostSignificantBit((int)this.b);
            }
            if (this.hasSkips) {
                this.entryBitLength = -1;
                this.quantumBitLength = -1;
                this.lowest = Integer.MAX_VALUE;
                long pointerQuantumSigma = BitStreamIndex.quantumSigma(this.frequency, this.index.numberOfDocuments, this.quantum);
                for (int i = Math.min(this.height, Fast.mostSignificantBit((int)(this.frequency >> this.quantumDivisionShift))); i >= 0; --i) {
                    this.towerTopB[i] = BitStreamIndex.gaussianGolombModulus(pointerQuantumSigma, i + 1);
                    this.towerTopLog2B[i] = Fast.mostSignificantBit((int)this.towerTopB[i]);
                    this.towerLowerB[i] = BitStreamIndex.gaussianGolombModulus(pointerQuantumSigma, i);
                    this.towerLowerLog2B[i] = Fast.mostSignificantBit((int)this.towerLowerB[i]);
                    this.pointerPrediction[i] = (int)(((long)this.quantum * (1L << i) * (long)this.index.numberOfDocuments + (long)(this.frequency / 2)) / (long)this.frequency);
                }
            }
            this.count = -1;
            this.currentDocument = -1;
            this.numberOfDocumentRecord = -1;
            this.state = 4;
        }

        @Override
        public Index index() {
            return this.keyIndex;
        }

        @Override
        public int frequency() {
            return this.frequency;
        }

        private void ensureCurrentDocument() {
            if (this.currentDocument < 0) {
                throw new IllegalStateException("nextDocument() has never been called for (term=" + this.currentTerm + ")");
            }
            if (this.currentDocument == Integer.MAX_VALUE) {
                throw new IllegalStateException("This reader is positioned beyond the end of list of (term=" + this.currentTerm + ")");
            }
        }

        private boolean endOfList() {
            return this.numberOfDocumentRecord >= this.frequency - 1;
        }

        @Override
        public int document() {
            return this.currentDocument;
        }

        @Override
        public Payload payload() throws IOException {
            if (!this.hasPayloads) {
                throw new UnsupportedOperationException("This index (" + this.index + ") does not contain payloads");
            }
            if (this.state <= 1) {
                if (this.state == 0) {
                    this.readTower();
                }
                this.payload.read(this.ibs);
                this.state = this.hasCounts ? 2 : 4;
            }
            return this.payload;
        }

        @Override
        public int count() throws IOException {
            if (this.count != -1) {
                return this.count;
            }
            if (!this.hasCounts) {
                throw new UnsupportedOperationException("This index (" + this.index + ") does not contain counts");
            }
            if (this.state == 0) {
                this.readTower();
            }
            if (this.state == 1) {
                this.payload.read(this.ibs);
            }
            this.state = this.hasPositions ? 3 : 4;
            switch (this.countCoding) {
                case UNARY: {
                    this.count = this.ibs.readUnary() + 1;
                    break;
                }
                case SHIFTED_GAMMA: {
                    this.count = this.ibs.readShiftedGamma() + 1;
                    break;
                }
                case GAMMA: {
                    this.count = this.ibs.readGamma() + 1;
                    break;
                }
                case DELTA: {
                    this.count = this.ibs.readDelta() + 1;
                    break;
                }
                default: {
                    throw new IllegalStateException("The required count coding (" + (Object)((Object)this.countCoding) + ") is not supported.");
                }
            }
            return this.count;
        }

        protected void updatePositionCache() throws IOException {
            if (!this.hasPositions) {
                throw new UnsupportedOperationException("This index(" + this.index + ") does not contain positions");
            }
            if (this.state < 3) {
                if (this.state == 0) {
                    this.readTower();
                }
                if (this.state == 1) {
                    this.payload.read(this.ibs);
                }
                if (this.state == 2) {
                    switch (this.countCoding) {
                        case UNARY: {
                            this.count = this.ibs.readUnary() + 1;
                            break;
                        }
                        case SHIFTED_GAMMA: {
                            this.count = this.ibs.readShiftedGamma() + 1;
                            break;
                        }
                        case GAMMA: {
                            this.count = this.ibs.readGamma() + 1;
                            break;
                        }
                        case DELTA: {
                            this.count = this.ibs.readDelta() + 1;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("The required count coding (" + (Object)((Object)this.countCoding) + ") is not supported.");
                        }
                    }
                }
            }
            if (this.count > this.positionCache.length) {
                this.positionCache = new int[Math.max(this.positionCache.length * 2, this.count)];
            }
            int[] occ = this.positionCache;
            this.state = 4;
            switch (this.positionCoding) {
                case SHIFTED_GAMMA: {
                    this.ibs.readShiftedGammas(occ, this.count);
                    for (int i = 1; i < this.count; ++i) {
                        int n = i;
                        occ[n] = occ[n] + (occ[i - 1] + 1);
                    }
                    return;
                }
                case GAMMA: {
                    this.ibs.readGammas(occ, this.count);
                    for (int i = 1; i < this.count; ++i) {
                        int n = i;
                        occ[n] = occ[n] + (occ[i - 1] + 1);
                    }
                    return;
                }
                case DELTA: {
                    this.ibs.readDeltas(occ, this.count);
                    for (int i = 1; i < this.count; ++i) {
                        int n = i;
                        occ[n] = occ[n] + (occ[i - 1] + 1);
                    }
                    return;
                }
                case GOLOMB: {
                    int docSize = this.index.sizes.getInt(this.currentDocument);
                    if (this.count < 3) {
                        for (int i = 0; i < this.count; ++i) {
                            occ[i] = this.ibs.readMinimalBinary(docSize);
                        }
                    } else {
                        int bb = BitStreamIndex.golombModulus(this.count, docSize);
                        int prev = -1;
                        if (bb != 0) {
                            int log2bb = Fast.mostSignificantBit((int)bb);
                            for (int i = 0; i < this.count; ++i) {
                                occ[i] = prev = this.ibs.readGolomb(bb, log2bb) + prev + 1;
                            }
                        } else {
                            for (int i = 0; i < this.count; ++i) {
                                occ[i] = i;
                            }
                        }
                    }
                    return;
                }
                case SKEWED_GOLOMB: {
                    int docSize2 = this.index.sizes.getInt(this.currentDocument);
                    if (this.count < 3) {
                        for (int i = 0; i < this.count; ++i) {
                            occ[i] = this.ibs.readMinimalBinary(docSize2);
                        }
                    } else {
                        int sb = this.ibs.readMinimalBinary(docSize2) + 1;
                        int prev2 = -1;
                        for (int i = 0; i < this.count; ++i) {
                            occ[i] = prev2 = this.ibs.readSkewedGolomb(sb) + prev2 + 1;
                        }
                    }
                    return;
                }
                case INTERPOLATIVE: {
                    InterpolativeCoding.read(this.ibs, occ, 0, this.count, 0, this.index.sizes.getInt(this.currentDocument) - 1);
                    return;
                }
            }
            throw new IllegalStateException("The required position coding (" + (Object)((Object)this.index.positionCoding) + ") is not supported.");
        }

        @Override
        public IntIterator positions() throws IOException {
            if (this.state <= 3) {
                this.updatePositionCache();
            }
            return IntIterators.wrap((int[])this.positionCache, (int)0, (int)this.count);
        }

        @Override
        public int[] positionArray() throws IOException {
            if (this.state <= 3) {
                this.updatePositionCache();
            }
            return this.positionCache;
        }

        @Override
        public int positions(int[] position) throws IOException {
            if (this.state <= 3) {
                this.updatePositionCache();
            }
            if (position.length < this.count) {
                return -this.count;
            }
            int i = this.count;
            while (i-- != 0) {
                position[i] = this.positionCache[i];
            }
            return this.count;
        }

        @Override
        public int nextDocument() throws IOException {
            block39: {
                block38: {
                    if (this.state != 4) {
                        if (this.state == 0) {
                            this.readTower();
                        }
                        if (this.state == 1) {
                            this.payload.read(this.ibs);
                        }
                        if (this.state == 2) {
                            this.state = this.hasPositions ? 3 : 4;
                            switch (this.countCoding) {
                                case UNARY: {
                                    this.count = this.ibs.readUnary() + 1;
                                    break;
                                }
                                case SHIFTED_GAMMA: {
                                    this.count = this.ibs.readShiftedGamma() + 1;
                                    break;
                                }
                                case GAMMA: {
                                    this.count = this.ibs.readGamma() + 1;
                                    break;
                                }
                                case DELTA: {
                                    this.count = this.ibs.readDelta() + 1;
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException("The required count coding (" + (Object)((Object)this.countCoding) + ") is not supported.");
                                }
                            }
                        }
                        if (this.state == 3) {
                            this.state = 4;
                            switch (this.positionCoding) {
                                case SHIFTED_GAMMA: {
                                    this.ibs.skipShiftedGammas(this.count);
                                    break;
                                }
                                case GAMMA: {
                                    this.ibs.skipGammas(this.count);
                                    break;
                                }
                                case DELTA: {
                                    this.ibs.skipDeltas(this.count);
                                    break;
                                }
                                case GOLOMB: {
                                    int docSize = this.index.sizes.getInt(this.currentDocument);
                                    if (this.count < 3) {
                                        for (int i = 0; i < this.count; ++i) {
                                            this.ibs.readMinimalBinary(docSize);
                                        }
                                    } else {
                                        int bb = BitStreamIndex.golombModulus(this.count, docSize);
                                        if (bb == 0) break;
                                        int log2bb = Fast.mostSignificantBit((int)bb);
                                        for (int i = 0; i < this.count; ++i) {
                                            this.ibs.readGolomb(bb, log2bb);
                                        }
                                    }
                                    break;
                                }
                                case SKEWED_GOLOMB: {
                                    int docSize = this.index.sizes.getInt(this.currentDocument);
                                    if (this.count < 3) {
                                        for (int i = 0; i < this.count; ++i) {
                                            this.ibs.readMinimalBinary(docSize);
                                        }
                                    } else {
                                        int sb = this.ibs.readMinimalBinary(docSize) + 1;
                                        for (int i = 0; i < this.count; ++i) {
                                            this.ibs.readSkewedGolomb(sb);
                                        }
                                    }
                                    break;
                                }
                                case INTERPOLATIVE: {
                                    InterpolativeCoding.read(this.ibs, null, 0, this.count, 0, this.index.sizes.getInt(this.currentDocument) - 1);
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException("The required position coding (" + (Object)((Object)this.positionCoding) + ") is not supported.");
                                }
                            }
                        }
                    }
                    if (this.endOfList()) {
                        return -1;
                    }
                    if (!this.hasPointers) break block38;
                    switch (this.pointerCoding) {
                        case SHIFTED_GAMMA: {
                            this.currentDocument += this.ibs.readShiftedGamma() + 1;
                            break block39;
                        }
                        case GAMMA: {
                            this.currentDocument += this.ibs.readGamma() + 1;
                            break block39;
                        }
                        case DELTA: {
                            this.currentDocument += this.ibs.readDelta() + 1;
                            break block39;
                        }
                        case GOLOMB: {
                            this.currentDocument += this.ibs.readGolomb(this.b, this.log2b) + 1;
                            break block39;
                        }
                        default: {
                            throw new IllegalStateException("The required pointer coding (" + (Object)((Object)this.pointerCoding) + ") is not supported.");
                        }
                    }
                }
                ++this.currentDocument;
            }
            ++this.numberOfDocumentRecord;
            if (this.hasPayloads) {
                this.state = 1;
            } else if (this.hasCounts) {
                this.state = 2;
            }
            this.count = -1;
            if (this.hasSkips && (this.numberOfDocumentRecord & this.quantumModuloMask) == 0) {
                this.state = 0;
            }
            return this.currentDocument;
        }

        private void readTower() throws IOException {
            this.readTower(-1);
        }

        private void readTower(int pointer) throws IOException {
            int j;
            int towerLength = 0;
            long bitsAtTowerStart = 0L;
            boolean truncated = false;
            int cacheOffset = this.numberOfDocumentRecord & this.wModuloMask;
            int k = cacheOffset >> this.quantumDivisionShift;
            this.s = k == 0 ? this.height : Fast.leastSignificantBit((long)k);
            int cache = this.frequency - this.w * (this.numberOfDocumentRecord >> this.wDivisionShift);
            if (cache < this.w) {
                this.maxh = Fast.mostSignificantBit((int)((cache >> this.quantumDivisionShift) - k));
                if (this.maxh < this.s) {
                    this.s = this.maxh;
                    truncated = true;
                } else {
                    truncated = false;
                }
            } else {
                cache = this.w;
                this.maxh = this.height;
                truncated = k == 0;
            }
            int i = this.s;
            if (this.s >= 0) {
                if (k == 0) {
                    if (this.quantumBitLength < 0) {
                        this.quantumBitLength = this.ibs.readDelta();
                        this.entryBitLength = this.ibs.readDelta();
                    } else {
                        this.quantumBitLength += Fast.nat2int((int)this.ibs.readDelta());
                        this.entryBitLength += Fast.nat2int((int)this.ibs.readDelta());
                    }
                }
                if (this.s > 0) {
                    towerLength = this.entryBitLength * (this.s + 1) + Fast.nat2int((int)this.ibs.readDelta());
                }
                bitsAtTowerStart = this.ibs.readBits();
                if (truncated) {
                    this.pointerSkip[this.s] = Fast.nat2int((int)this.ibs.readGolomb(this.towerTopB[this.s], this.towerTopLog2B[this.s])) + this.pointerPrediction[this.s];
                    this.bitSkip[this.s] = (long)(this.quantumBitLength * (1 << this.s) + this.entryBitLength * ((1 << this.s + 1) - this.s - 2)) + Fast.nat2int((long)this.ibs.readLongDelta());
                } else {
                    this.pointerSkip[this.s] = this.pointerSkip[this.s + 1] - (this.currentDocument - this.pointerAtLastSkipTower);
                    this.bitSkip[this.s] = this.bitSkip[this.s + 1] - (bitsAtTowerStart - this.readBitsAtLastSkipTower) - (long)towerLength;
                }
                if (this.currentDocument + this.pointerSkip[i] > pointer) {
                    for (i = this.s - 1; i >= 0; --i) {
                        this.pointerSkip[i] = Fast.nat2int((int)this.ibs.readGolomb(this.towerLowerB[i], this.towerLowerLog2B[i])) + this.pointerSkip[i + 1] / 2;
                        this.bitSkip[i] = (this.bitSkip[i + 1] - (long)(this.entryBitLength * (i + 1))) / 2L - Fast.nat2int((long)this.ibs.readLongDelta());
                        if (this.currentDocument + this.pointerSkip[i] <= pointer) break;
                    }
                }
            }
            if (i > 0) {
                long fix = this.ibs.readBits() - bitsAtTowerStart;
                j = this.s;
                while (j >= i) {
                    int n = j--;
                    this.bitSkip[n] = this.bitSkip[n] + ((long)towerLength - fix);
                }
            } else {
                this.state = this.hasPayloads ? 1 : (this.hasCounts ? 2 : 4);
            }
            long deltaBits = this.ibs.readBits() - this.readBitsAtLastSkipTower;
            int deltaPointers = this.currentDocument - this.pointerAtLastSkipTower;
            j = Fast.mostSignificantBit((int)(k ^ cache >> this.quantumDivisionShift));
            while (j >= this.s + 1) {
                int n = j;
                this.bitSkip[n] = this.bitSkip[n] - deltaBits;
                int n2 = j--;
                this.pointerSkip[n2] = this.pointerSkip[n2] - deltaPointers;
            }
            this.readBitsAtLastSkipTower = this.ibs.readBits();
            this.pointerAtLastSkipTower = this.currentDocument;
            this.lowest = i < 0 ? 0 : i;
        }

        @Override
        public int skipTo(int p) throws IOException {
            if (this.numberOfDocumentRecord == -1) {
                this.nextDocument();
            }
            if (this.currentDocument >= p) {
                return this.currentDocument;
            }
            if (this.hasSkips) {
                if (this.state == 0) {
                    this.readTower(p);
                }
                int[] pointerSkip = this.pointerSkip;
                while (this.maxh >= 0 && (this.lowest != 0 || this.pointerAtLastSkipTower + pointerSkip[0] <= p)) {
                    int i;
                    int cacheOffset = this.numberOfDocumentRecord & this.wModuloMask;
                    int k = cacheOffset >> this.quantumDivisionShift;
                    int top = Fast.mostSignificantBit((int)(k ^ Math.min(this.w, this.frequency - this.numberOfDocumentRecord + cacheOffset) >> this.quantumDivisionShift));
                    for (i = this.lowest; i <= top && this.pointerAtLastSkipTower + pointerSkip[i] <= p; ++i) {
                    }
                    if (--i < 0) break;
                    this.ibs.skip(this.bitSkip[i] - (this.ibs.readBits() - this.readBitsAtLastSkipTower));
                    this.state = 0;
                    this.currentDocument = pointerSkip[i] + this.pointerAtLastSkipTower;
                    this.numberOfDocumentRecord += ((k & -(1 << i)) + (1 << i)) * this.quantum - cacheOffset;
                    if (this.numberOfDocumentRecord == this.frequency) {
                        this.currentDocument = Integer.MAX_VALUE;
                        this.state = 4;
                    } else {
                        this.readTower(p);
                    }
                    this.count = -1;
                    if (!this.endOfList()) continue;
                    return p == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.currentDocument;
                }
            }
            while (this.currentDocument < p) {
                if (this.nextDocument() != -1) continue;
                return Integer.MAX_VALUE;
            }
            return this.currentDocument;
        }

        @Override
        public void dispose() throws IOException {
            this.parent.close();
        }

        public boolean hasNext() {
            return !this.endOfList();
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return this.nextDocument();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.index + " [" + this.currentTerm + "]";
        }

        @Override
        public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
            this.intervalIterator();
            return this.singletonIntervalIterator;
        }

        @Override
        public IntervalIterator intervalIterator() throws IOException {
            return this.intervalIterator(this.keyIndex);
        }

        @Override
        public IntervalIterator intervalIterator(Index index) throws IOException {
            if (index != this.keyIndex) {
                return IntervalIterators.TRUE;
            }
            this.intervalIterator.reset();
            return this.intervalIterator;
        }

        @Override
        public ReferenceSet<Index> indices() {
            return this.index.singletonSet;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class IndexIntervalIterator
        extends AbstractObjectIterator<Interval>
        implements IntervalIterator {
            int pos = -1;

            private IndexIntervalIterator() {
            }

            @Override
            public void reset() throws IOException {
                this.pos = -1;
                if (BitStreamIndexReaderIndexIterator.this.state <= 3) {
                    BitStreamIndexReaderIndexIterator.this.updatePositionCache();
                }
            }

            @Override
            public void intervalTerms(IntSet terms) {
                terms.add(BitStreamIndexReaderIndexIterator.this.currentTerm);
            }

            @Override
            public boolean hasNext() {
                return this.pos < BitStreamIndexReaderIndexIterator.this.count - 1;
            }

            @Override
            public Interval next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Interval.valueOf((int)BitStreamIndexReaderIndexIterator.this.positionCache[++this.pos]);
            }

            @Override
            public Interval nextInterval() {
                return this.pos < BitStreamIndexReaderIndexIterator.this.count - 1 ? Interval.valueOf((int)BitStreamIndexReaderIndexIterator.this.positionCache[++this.pos]) : null;
            }

            @Override
            public int extent() {
                return 1;
            }

            public String toString() {
                return BitStreamIndexReaderIndexIterator.this.index + ": " + BitStreamIndexReaderIndexIterator.this.term + "[doc=" + BitStreamIndexReaderIndexIterator.this.currentDocument + ", count=" + BitStreamIndexReaderIndexIterator.this.count + ", pos=" + this.pos + "]";
            }
        }
    }
}

